/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.object.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Represents a collaborator for an entry.", value="Collaborator")
@Schema(description="Represents a collaborator for an entry.", requiredProperties={"actionIds", "type"})
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Collaborator")
public class Collaborator
implements Serializable {
    @GraphQLField(description="The collaborator actions for the shared asset.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotNull
    protected @GraphQLField(description="The collaborator actions for the shared asset.") @NotNull String[] actionIds;
    @JsonIgnore
    private Supplier<String[]> _actionIdsSupplier;
    @GraphQLField(description="Block of actions allowed by the user making the request.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="Block of actions allowed by the user making the request.") Map<String, Object> actions;
    @JsonIgnore
    private Supplier<Map<String, Object>> _actionsSupplier;
    @GraphQLField(description="The object entry folder's creator.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The object entry folder's creator.") Creator creator;
    @JsonIgnore
    private Supplier<Creator> _creatorSupplier;
    @GraphQLField(description="The expiration date to be a collaborator of the asset.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The expiration date to be a collaborator of the asset.") Date dateExpired;
    @JsonIgnore
    private Supplier<Date> _dateExpiredSupplier;
    @GraphQLField(description="The collaborator external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The collaborator external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The collaborator ID.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The collaborator ID.") Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField(description="The collaborator name.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The collaborator name.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField(description="The collaborator portrait.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The collaborator portrait.") String portrait;
    @JsonIgnore
    private Supplier<String> _portraitSupplier;
    @GraphQLField(description="If the collaborator can share or not the asset.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="If the collaborator can share or not the asset.") Boolean share;
    @JsonIgnore
    private Supplier<Boolean> _shareSupplier;
    @GraphQLField(description="The collaborator type.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected @GraphQLField(description="The collaborator type.") @NotEmpty String type;
    @JsonIgnore
    private Supplier<String> _typeSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.object.dto.v1_0.Collaborator", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Collaborator toDTO(String json) {
        return (Collaborator)ObjectMapperUtil.readValue(Collaborator.class, (String)json);
    }

    public static Collaborator unsafeToDTO(String json) {
        return (Collaborator)ObjectMapperUtil.unsafeReadValue(Collaborator.class, (String)json);
    }

    @Schema(description="The collaborator actions for the shared asset.")
    public String[] getActionIds() {
        if (this._actionIdsSupplier != null) {
            this.actionIds = this._actionIdsSupplier.get();
            this._actionIdsSupplier = null;
        }
        return this.actionIds;
    }

    public void setActionIds(String[] actionIds) {
        this.actionIds = actionIds;
        this._actionIdsSupplier = null;
    }

    @JsonIgnore
    public void setActionIds(UnsafeSupplier<String[], Exception> actionIdsUnsafeSupplier) {
        this._actionIdsSupplier = () -> {
            try {
                return (String[])actionIdsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="Block of actions allowed by the user making the request.")
    @Valid
    public Map<String, Object> getActions() {
        if (this._actionsSupplier != null) {
            this.actions = this._actionsSupplier.get();
            this._actionsSupplier = null;
        }
        return this.actions;
    }

    public void setActions(Map<String, Object> actions) {
        this.actions = actions;
        this._actionsSupplier = null;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Object>, Exception> actionsUnsafeSupplier) {
        this._actionsSupplier = () -> {
            try {
                return (Map)actionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The object entry folder's creator.")
    @Valid
    public Creator getCreator() {
        if (this._creatorSupplier != null) {
            this.creator = this._creatorSupplier.get();
            this._creatorSupplier = null;
        }
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
        this._creatorSupplier = null;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        this._creatorSupplier = () -> {
            try {
                return (Creator)creatorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The expiration date to be a collaborator of the asset.")
    public Date getDateExpired() {
        if (this._dateExpiredSupplier != null) {
            this.dateExpired = this._dateExpiredSupplier.get();
            this._dateExpiredSupplier = null;
        }
        return this.dateExpired;
    }

    public void setDateExpired(Date dateExpired) {
        this.dateExpired = dateExpired;
        this._dateExpiredSupplier = null;
    }

    @JsonIgnore
    public void setDateExpired(UnsafeSupplier<Date, Exception> dateExpiredUnsafeSupplier) {
        this._dateExpiredSupplier = () -> {
            try {
                return (Date)dateExpiredUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The collaborator external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The collaborator ID.")
    public Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The collaborator name.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The collaborator portrait.")
    public String getPortrait() {
        if (this._portraitSupplier != null) {
            this.portrait = this._portraitSupplier.get();
            this._portraitSupplier = null;
        }
        return this.portrait;
    }

    public void setPortrait(String portrait) {
        this.portrait = portrait;
        this._portraitSupplier = null;
    }

    @JsonIgnore
    public void setPortrait(UnsafeSupplier<String, Exception> portraitUnsafeSupplier) {
        this._portraitSupplier = () -> {
            try {
                return (String)portraitUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="If the collaborator can share or not the asset.")
    public Boolean getShare() {
        if (this._shareSupplier != null) {
            this.share = this._shareSupplier.get();
            this._shareSupplier = null;
        }
        return this.share;
    }

    public void setShare(Boolean share) {
        this.share = share;
        this._shareSupplier = null;
    }

    @JsonIgnore
    public void setShare(UnsafeSupplier<Boolean, Exception> shareUnsafeSupplier) {
        this._shareSupplier = () -> {
            try {
                return (Boolean)shareUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The collaborator type.", example="User")
    public String getType() {
        if (this._typeSupplier != null) {
            this.type = this._typeSupplier.get();
            this._typeSupplier = null;
        }
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this._typeSupplier = null;
    }

    @JsonIgnore
    public void setType(UnsafeSupplier<String, Exception> typeUnsafeSupplier) {
        this._typeSupplier = () -> {
            try {
                return (String)typeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Collaborator)) {
            return false;
        }
        Collaborator collaborator = (Collaborator)object;
        return Objects.equals(this.toString(), collaborator.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        String type;
        Boolean share;
        String portrait;
        String name;
        Long id;
        String externalReferenceCode;
        Date dateExpired;
        Creator creator;
        Map<String, Object> actions;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String[] actionIds = this.getActionIds();
        if (actionIds != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actionIds\": ");
            sb.append("[");
            for (int i = 0; i < actionIds.length; ++i) {
                sb.append("\"");
                sb.append(Collaborator._escape(actionIds[i]));
                sb.append("\"");
                if (i + 1 >= actionIds.length) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        if ((actions = this.getActions()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(Collaborator._toJSON(actions));
        }
        if ((creator = this.getCreator()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((dateExpired = this.getDateExpired()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateExpired\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateExpired));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Collaborator._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Collaborator._escape(name));
            sb.append("\"");
        }
        if ((portrait = this.getPortrait()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"portrait\": ");
            sb.append("\"");
            sb.append(Collaborator._escape(portrait));
            sb.append("\"");
        }
        if ((share = this.getShare()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"share\": ");
            sb.append((Object)share);
        }
        if ((type = this.getType()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"type\": ");
            sb.append("\"");
            sb.append(Collaborator._escape(type));
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Collaborator._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Collaborator._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Collaborator._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Collaborator._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Collaborator._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

