/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.object.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.liferay.headless.delivery.dto.v1_0.Creator;
import com.liferay.headless.object.dto.v1_0.ParentObjectEntryFolderBrief;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Represents a object entry folder that contains objects entries and other object entry folders.", value="ObjectEntryFolder")
@Schema(description="Represents a object entry folder that contains objects entries and other object entry folders.", requiredProperties={"title"})
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="ObjectEntryFolder")
public class ObjectEntryFolder
implements Serializable {
    @GraphQLField(description="Block of actions allowed by the user making the request.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="Block of actions allowed by the user making the request.") Map<String, Map<String, String>> actions;
    @JsonIgnore
    private Supplier<Map<String, Map<String, String>>> _actionsSupplier;
    @GraphQLField(description="The object entry folder's creator.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The object entry folder's creator.") Creator creator;
    @JsonIgnore
    private Supplier<Creator> _creatorSupplier;
    @GraphQLField(description="The object entry folder's creation date.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The object entry folder's creation date.") Date dateCreated;
    @JsonIgnore
    private Supplier<Date> _dateCreatedSupplier;
    @GraphQLField(description="The last time a field of the folder changed.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The last time a field of the folder changed.") Date dateModified;
    @JsonIgnore
    private Supplier<Date> _dateModifiedSupplier;
    @GraphQLField(description="The object entry folder's description.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The object entry folder's description.") String description;
    @JsonIgnore
    private Supplier<String> _descriptionSupplier;
    @GraphQLField(description="The object entry folder's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The object entry folder's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The object entry folder's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The object entry folder's ID.") Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField(description="The object entry folder's label.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The object entry folder's label.") String label;
    @JsonIgnore
    private Supplier<String> _labelSupplier;
    @GraphQLField(description="The localized object entry folder's label.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The localized object entry folder's label.") Map<String, String> label_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _label_i18nSupplier;
    @GraphQLField(description="The number of object entries in this object entry folder.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of object entries in this object entry folder.") Integer numberOfObjectEntries;
    @JsonIgnore
    private Supplier<Integer> _numberOfObjectEntriesSupplier;
    @GraphQLField(description="The number of this object entry folder's child object entry folders.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The number of this object entry folder's child object entry folders.") Integer numberOfObjectEntryFolders;
    @JsonIgnore
    private Supplier<Integer> _numberOfObjectEntryFoldersSupplier;
    @GraphQLField(description="The object entry folder's parent, if it exists.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The object entry folder's parent, if it exists.") ParentObjectEntryFolderBrief parentObjectEntryFolderBrief;
    @JsonIgnore
    private Supplier<ParentObjectEntryFolderBrief> _parentObjectEntryFolderBriefSupplier;
    @GraphQLField(description="The parent entry folder's external reference code, if it exists.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The parent entry folder's external reference code, if it exists.") String parentObjectEntryFolderExternalReferenceCode;
    @JsonIgnore
    private Supplier<String> _parentObjectEntryFolderExternalReferenceCodeSupplier;
    @GraphQLField(description="The ID of the object entry folder's parent, if it exists.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    protected @GraphQLField(description="The ID of the object entry folder's parent, if it exists.") Long parentObjectEntryFolderId;
    @JsonIgnore
    private Supplier<Long> _parentObjectEntryFolderIdSupplier;
    @GraphQLField(description="The scope key of the object entry folder.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The scope key of the object entry folder.") String scopeKey;
    @JsonIgnore
    private Supplier<String> _scopeKeySupplier;
    @GraphQLField(description="The object entry folder's main title/name.")
    @JsonProperty(access=JsonProperty.Access.READ_WRITE)
    @NotEmpty
    protected @GraphQLField(description="The object entry folder's main title/name.") @NotEmpty String title;
    @JsonIgnore
    private Supplier<String> _titleSupplier;
    @GraphQLField(description="A write-only property that specifies the object entry folder's default permissions.")
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    protected @GraphQLField(description="A write-only property that specifies the object entry folder's default permissions.") ViewableBy viewableBy;
    @JsonIgnore
    private Supplier<ViewableBy> _viewableBySupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.object.dto.v1_0.ObjectEntryFolder", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static ObjectEntryFolder toDTO(String json) {
        return (ObjectEntryFolder)ObjectMapperUtil.readValue(ObjectEntryFolder.class, (String)json);
    }

    public static ObjectEntryFolder unsafeToDTO(String json) {
        return (ObjectEntryFolder)ObjectMapperUtil.unsafeReadValue(ObjectEntryFolder.class, (String)json);
    }

    @Schema(description="Block of actions allowed by the user making the request.")
    @Valid
    public Map<String, Map<String, String>> getActions() {
        if (this._actionsSupplier != null) {
            this.actions = this._actionsSupplier.get();
            this._actionsSupplier = null;
        }
        return this.actions;
    }

    public void setActions(Map<String, Map<String, String>> actions) {
        this.actions = actions;
        this._actionsSupplier = null;
    }

    @JsonIgnore
    public void setActions(UnsafeSupplier<Map<String, Map<String, String>>, Exception> actionsUnsafeSupplier) {
        this._actionsSupplier = () -> {
            try {
                return (Map)actionsUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The object entry folder's creator.")
    @Valid
    public Creator getCreator() {
        if (this._creatorSupplier != null) {
            this.creator = this._creatorSupplier.get();
            this._creatorSupplier = null;
        }
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
        this._creatorSupplier = null;
    }

    @JsonIgnore
    public void setCreator(UnsafeSupplier<Creator, Exception> creatorUnsafeSupplier) {
        this._creatorSupplier = () -> {
            try {
                return (Creator)creatorUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The object entry folder's creation date.")
    public Date getDateCreated() {
        if (this._dateCreatedSupplier != null) {
            this.dateCreated = this._dateCreatedSupplier.get();
            this._dateCreatedSupplier = null;
        }
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        this._dateCreatedSupplier = null;
    }

    @JsonIgnore
    public void setDateCreated(UnsafeSupplier<Date, Exception> dateCreatedUnsafeSupplier) {
        this._dateCreatedSupplier = () -> {
            try {
                return (Date)dateCreatedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The last time a field of the folder changed.")
    public Date getDateModified() {
        if (this._dateModifiedSupplier != null) {
            this.dateModified = this._dateModifiedSupplier.get();
            this._dateModifiedSupplier = null;
        }
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
        this._dateModifiedSupplier = null;
    }

    @JsonIgnore
    public void setDateModified(UnsafeSupplier<Date, Exception> dateModifiedUnsafeSupplier) {
        this._dateModifiedSupplier = () -> {
            try {
                return (Date)dateModifiedUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The object entry folder's description.")
    public String getDescription() {
        if (this._descriptionSupplier != null) {
            this.description = this._descriptionSupplier.get();
            this._descriptionSupplier = null;
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this._descriptionSupplier = null;
    }

    @JsonIgnore
    public void setDescription(UnsafeSupplier<String, Exception> descriptionUnsafeSupplier) {
        this._descriptionSupplier = () -> {
            try {
                return (String)descriptionUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The object entry folder's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The object entry folder's ID.")
    public Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The object entry folder's label.")
    public String getLabel() {
        if (this._labelSupplier != null) {
            this.label = this._labelSupplier.get();
            this._labelSupplier = null;
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this._labelSupplier = null;
    }

    @JsonIgnore
    public void setLabel(UnsafeSupplier<String, Exception> labelUnsafeSupplier) {
        this._labelSupplier = () -> {
            try {
                return (String)labelUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The localized object entry folder's label.")
    @Valid
    public Map<String, String> getLabel_i18n() {
        if (this._label_i18nSupplier != null) {
            this.label_i18n = this._label_i18nSupplier.get();
            this._label_i18nSupplier = null;
        }
        return this.label_i18n;
    }

    public void setLabel_i18n(Map<String, String> label_i18n) {
        this.label_i18n = label_i18n;
        this._label_i18nSupplier = null;
    }

    @JsonIgnore
    public void setLabel_i18n(UnsafeSupplier<Map<String, String>, Exception> label_i18nUnsafeSupplier) {
        this._label_i18nSupplier = () -> {
            try {
                return (Map)label_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The number of object entries in this object entry folder.")
    public Integer getNumberOfObjectEntries() {
        if (this._numberOfObjectEntriesSupplier != null) {
            this.numberOfObjectEntries = this._numberOfObjectEntriesSupplier.get();
            this._numberOfObjectEntriesSupplier = null;
        }
        return this.numberOfObjectEntries;
    }

    public void setNumberOfObjectEntries(Integer numberOfObjectEntries) {
        this.numberOfObjectEntries = numberOfObjectEntries;
        this._numberOfObjectEntriesSupplier = null;
    }

    @JsonIgnore
    public void setNumberOfObjectEntries(UnsafeSupplier<Integer, Exception> numberOfObjectEntriesUnsafeSupplier) {
        this._numberOfObjectEntriesSupplier = () -> {
            try {
                return (Integer)numberOfObjectEntriesUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The number of this object entry folder's child object entry folders.")
    public Integer getNumberOfObjectEntryFolders() {
        if (this._numberOfObjectEntryFoldersSupplier != null) {
            this.numberOfObjectEntryFolders = this._numberOfObjectEntryFoldersSupplier.get();
            this._numberOfObjectEntryFoldersSupplier = null;
        }
        return this.numberOfObjectEntryFolders;
    }

    public void setNumberOfObjectEntryFolders(Integer numberOfObjectEntryFolders) {
        this.numberOfObjectEntryFolders = numberOfObjectEntryFolders;
        this._numberOfObjectEntryFoldersSupplier = null;
    }

    @JsonIgnore
    public void setNumberOfObjectEntryFolders(UnsafeSupplier<Integer, Exception> numberOfObjectEntryFoldersUnsafeSupplier) {
        this._numberOfObjectEntryFoldersSupplier = () -> {
            try {
                return (Integer)numberOfObjectEntryFoldersUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The object entry folder's parent, if it exists.")
    @Valid
    public ParentObjectEntryFolderBrief getParentObjectEntryFolderBrief() {
        if (this._parentObjectEntryFolderBriefSupplier != null) {
            this.parentObjectEntryFolderBrief = this._parentObjectEntryFolderBriefSupplier.get();
            this._parentObjectEntryFolderBriefSupplier = null;
        }
        return this.parentObjectEntryFolderBrief;
    }

    public void setParentObjectEntryFolderBrief(ParentObjectEntryFolderBrief parentObjectEntryFolderBrief) {
        this.parentObjectEntryFolderBrief = parentObjectEntryFolderBrief;
        this._parentObjectEntryFolderBriefSupplier = null;
    }

    @JsonIgnore
    public void setParentObjectEntryFolderBrief(UnsafeSupplier<ParentObjectEntryFolderBrief, Exception> parentObjectEntryFolderBriefUnsafeSupplier) {
        this._parentObjectEntryFolderBriefSupplier = () -> {
            try {
                return (ParentObjectEntryFolderBrief)parentObjectEntryFolderBriefUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The parent entry folder's external reference code, if it exists.")
    public String getParentObjectEntryFolderExternalReferenceCode() {
        if (this._parentObjectEntryFolderExternalReferenceCodeSupplier != null) {
            this.parentObjectEntryFolderExternalReferenceCode = this._parentObjectEntryFolderExternalReferenceCodeSupplier.get();
            this._parentObjectEntryFolderExternalReferenceCodeSupplier = null;
        }
        return this.parentObjectEntryFolderExternalReferenceCode;
    }

    public void setParentObjectEntryFolderExternalReferenceCode(String parentObjectEntryFolderExternalReferenceCode) {
        this.parentObjectEntryFolderExternalReferenceCode = parentObjectEntryFolderExternalReferenceCode;
        this._parentObjectEntryFolderExternalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setParentObjectEntryFolderExternalReferenceCode(UnsafeSupplier<String, Exception> parentObjectEntryFolderExternalReferenceCodeUnsafeSupplier) {
        this._parentObjectEntryFolderExternalReferenceCodeSupplier = () -> {
            try {
                return (String)parentObjectEntryFolderExternalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The ID of the object entry folder's parent, if it exists.")
    public Long getParentObjectEntryFolderId() {
        if (this._parentObjectEntryFolderIdSupplier != null) {
            this.parentObjectEntryFolderId = this._parentObjectEntryFolderIdSupplier.get();
            this._parentObjectEntryFolderIdSupplier = null;
        }
        return this.parentObjectEntryFolderId;
    }

    public void setParentObjectEntryFolderId(Long parentObjectEntryFolderId) {
        this.parentObjectEntryFolderId = parentObjectEntryFolderId;
        this._parentObjectEntryFolderIdSupplier = null;
    }

    @JsonIgnore
    public void setParentObjectEntryFolderId(UnsafeSupplier<Long, Exception> parentObjectEntryFolderIdUnsafeSupplier) {
        this._parentObjectEntryFolderIdSupplier = () -> {
            try {
                return (Long)parentObjectEntryFolderIdUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The scope key of the object entry folder.")
    public String getScopeKey() {
        if (this._scopeKeySupplier != null) {
            this.scopeKey = this._scopeKeySupplier.get();
            this._scopeKeySupplier = null;
        }
        return this.scopeKey;
    }

    public void setScopeKey(String scopeKey) {
        this.scopeKey = scopeKey;
        this._scopeKeySupplier = null;
    }

    @JsonIgnore
    public void setScopeKey(UnsafeSupplier<String, Exception> scopeKeyUnsafeSupplier) {
        this._scopeKeySupplier = () -> {
            try {
                return (String)scopeKeyUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The object entry folder's main title/name.")
    public String getTitle() {
        if (this._titleSupplier != null) {
            this.title = this._titleSupplier.get();
            this._titleSupplier = null;
        }
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this._titleSupplier = null;
    }

    @JsonIgnore
    public void setTitle(UnsafeSupplier<String, Exception> titleUnsafeSupplier) {
        this._titleSupplier = () -> {
            try {
                return (String)titleUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="A write-only property that specifies the object entry folder's default permissions.")
    @JsonGetter(value="viewableBy")
    @Valid
    public ViewableBy getViewableBy() {
        if (this._viewableBySupplier != null) {
            this.viewableBy = this._viewableBySupplier.get();
            this._viewableBySupplier = null;
        }
        return this.viewableBy;
    }

    @JsonIgnore
    public String getViewableByAsString() {
        ViewableBy viewableBy = this.getViewableBy();
        if (viewableBy == null) {
            return null;
        }
        return viewableBy.toString();
    }

    public void setViewableBy(ViewableBy viewableBy) {
        this.viewableBy = viewableBy;
        this._viewableBySupplier = null;
    }

    @JsonIgnore
    public void setViewableBy(UnsafeSupplier<ViewableBy, Exception> viewableByUnsafeSupplier) {
        this._viewableBySupplier = () -> {
            try {
                return (ViewableBy)((Object)((Object)viewableByUnsafeSupplier.get()));
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectEntryFolder)) {
            return false;
        }
        ObjectEntryFolder objectEntryFolder = (ObjectEntryFolder)object;
        return Objects.equals(this.toString(), objectEntryFolder.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        ViewableBy viewableBy;
        String title;
        String scopeKey;
        Long parentObjectEntryFolderId;
        String parentObjectEntryFolderExternalReferenceCode;
        ParentObjectEntryFolderBrief parentObjectEntryFolderBrief;
        Integer numberOfObjectEntryFolders;
        Integer numberOfObjectEntries;
        Map<String, String> label_i18n;
        String label;
        Long id;
        String externalReferenceCode;
        String description;
        Date dateModified;
        Date dateCreated;
        Creator creator;
        StringBundler sb = new StringBundler();
        sb.append("{");
        SimpleDateFormat liferayToJSONDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        Map<String, Map<String, String>> actions = this.getActions();
        if (actions != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"actions\": ");
            sb.append(ObjectEntryFolder._toJSON(actions));
        }
        if ((creator = this.getCreator()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"creator\": ");
            sb.append((Object)creator);
        }
        if ((dateCreated = this.getDateCreated()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateCreated\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateCreated));
            sb.append("\"");
        }
        if ((dateModified = this.getDateModified()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"dateModified\": ");
            sb.append("\"");
            sb.append(liferayToJSONDateFormat.format(dateModified));
            sb.append("\"");
        }
        if ((description = this.getDescription()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"description\": ");
            sb.append("\"");
            sb.append(ObjectEntryFolder._escape(description));
            sb.append("\"");
        }
        if ((externalReferenceCode = this.getExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(ObjectEntryFolder._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((label = this.getLabel()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"label\": ");
            sb.append("\"");
            sb.append(ObjectEntryFolder._escape(label));
            sb.append("\"");
        }
        if ((label_i18n = this.getLabel_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"label_i18n\": ");
            sb.append(ObjectEntryFolder._toJSON(label_i18n));
        }
        if ((numberOfObjectEntries = this.getNumberOfObjectEntries()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfObjectEntries\": ");
            sb.append((Object)numberOfObjectEntries);
        }
        if ((numberOfObjectEntryFolders = this.getNumberOfObjectEntryFolders()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"numberOfObjectEntryFolders\": ");
            sb.append((Object)numberOfObjectEntryFolders);
        }
        if ((parentObjectEntryFolderBrief = this.getParentObjectEntryFolderBrief()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentObjectEntryFolderBrief\": ");
            sb.append(String.valueOf(parentObjectEntryFolderBrief));
        }
        if ((parentObjectEntryFolderExternalReferenceCode = this.getParentObjectEntryFolderExternalReferenceCode()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentObjectEntryFolderExternalReferenceCode\": ");
            sb.append("\"");
            sb.append(ObjectEntryFolder._escape(parentObjectEntryFolderExternalReferenceCode));
            sb.append("\"");
        }
        if ((parentObjectEntryFolderId = this.getParentObjectEntryFolderId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"parentObjectEntryFolderId\": ");
            sb.append((Object)parentObjectEntryFolderId);
        }
        if ((scopeKey = this.getScopeKey()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"scopeKey\": ");
            sb.append("\"");
            sb.append(ObjectEntryFolder._escape(scopeKey));
            sb.append("\"");
        }
        if ((title = this.getTitle()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"title\": ");
            sb.append("\"");
            sb.append(ObjectEntryFolder._escape(title));
            sb.append("\"");
        }
        if ((viewableBy = this.getViewableBy()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"viewableBy\": ");
            sb.append("\"");
            sb.append((Object)viewableBy);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(ObjectEntryFolder._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (ObjectEntryFolder._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(ObjectEntryFolder._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(ObjectEntryFolder._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(ObjectEntryFolder._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @GraphQLName(value="ViewableBy")
    public static enum ViewableBy {
        ANYONE("Anyone"),
        MEMBERS("Members"),
        OWNER("Owner");

        private final String _value;

        @JsonCreator
        public static ViewableBy create(String value) {
            if (value == null || value.equals("")) {
                return null;
            }
            for (ViewableBy viewableBy : ViewableBy.values()) {
                if (!Objects.equals(viewableBy.getValue(), value)) continue;
                return viewableBy;
            }
            throw new IllegalArgumentException("Invalid enum value: " + value);
        }

        @JsonValue
        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private ViewableBy(String value) {
            this._value = value;
        }
    }
}

