/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.cms.internal.resource.v1_0;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryService;
import com.liferay.headless.cms.dto.v1_0.AssetUsage;
import com.liferay.headless.cms.internal.resource.v1_0.BaseAssetUsageResourceImpl;
import com.liferay.headless.cms.resource.v1_0.AssetUsageResource;
import com.liferay.layout.model.LayoutClassedModelUsageTable;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTable;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.StringEntityField;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/asset-usage.properties"}, scope=ServiceScope.PROTOTYPE, service={AssetUsageResource.class})
public class AssetUsageResourceImpl
extends BaseAssetUsageResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetUsageResourceImpl.class);
    private static final EntityModel _entityModel = () -> EntityModel.toEntityFieldsMap((EntityField[])new EntityField[]{new StringEntityField("name", locale -> "name")});
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryService _depotEntryService;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Localization _localization;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private Portal _portal;

    @Override
    public Page<AssetUsage> getAssetUsagesAssetPage(Long assetId, String search, Pagination pagination, Sort[] sorts) throws Exception {
        List<AssetUsage> assetUsages = this._getAssetUsages(assetId, search);
        Sort sort = null;
        sort = ArrayUtil.isEmpty((Object[])sorts) ? new Sort("name", false) : sorts[0];
        boolean reverse = sort.isReverse();
        return Page.of((Collection)ListUtil.subList((List)ListUtil.sort(assetUsages, (assetUsage1, assetUsage2) -> {
            String name = assetUsage1.getName();
            int value = name.compareTo(assetUsage2.getName());
            if (!reverse) {
                return value;
            }
            return -value;
        }), (int)pagination.getStartPosition(), (int)pagination.getEndPosition()), (Pagination)pagination, (long)assetUsages.size());
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    private ThemeDisplay _createThemeDisplay(Layout layout) throws Exception {
        ThemeDisplay themeDisplay = new ThemeDisplay();
        themeDisplay.setCompany(this.contextCompany);
        themeDisplay.setLayout(layout);
        themeDisplay.setLayoutSet(layout.getLayoutSet());
        themeDisplay.setLocale(this.contextAcceptLanguage.getPreferredLocale());
        themeDisplay.setPathMain(this._portal.getPathMain());
        themeDisplay.setPermissionChecker(PermissionThreadLocal.getPermissionChecker());
        themeDisplay.setPlid(layout.getPlid());
        String portalURL = this._portal.getPortalURL(this.contextHttpServletRequest);
        themeDisplay.setPortalDomain(HttpComponentsUtil.getDomain((String)portalURL));
        themeDisplay.setPortalURL(portalURL);
        themeDisplay.setRequest(this.contextHttpServletRequest);
        themeDisplay.setScopeGroupId(layout.getGroupId());
        themeDisplay.setSiteGroupId(layout.getGroupId());
        themeDisplay.setURLCurrent(this._portal.getCurrentURL(this.contextHttpServletRequest));
        themeDisplay.setUser(this.contextUser);
        return themeDisplay;
    }

    private List<AssetUsage> _getAssetUsages(Long assetId, String search) throws Exception {
        ArrayList<AssetUsage> assetUsages = new ArrayList<AssetUsage>();
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(assetId.longValue());
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
        assetUsages.addAll(this._getLayoutAssetUsages(assetId, objectDefinition.getClassName(), search));
        assetUsages.addAll(this._getObjectEntryAssetUsages(assetId, objectDefinition, search));
        return assetUsages;
    }

    private Long[] _getGroupIds(List<DepotEntry> depotEntries) {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (DepotEntry depotEntry : depotEntries) {
            groupIds.add(depotEntry.getGroupId());
            List depotEntryGroupRels = this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(depotEntry);
            for (DepotEntryGroupRel depotEntryGroupRel : depotEntryGroupRels) {
                groupIds.add(depotEntryGroupRel.getGroupId());
            }
        }
        return groupIds.toArray(new Long[0]);
    }

    private List<AssetUsage> _getLayoutAssetUsages(Long assetId, String className, String search) {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this.contextUser);
        return this.transform(this._getLayoutClassedModelUsageObjectsList(className, assetId, search), objects -> {
            final Layout layout = this._layoutLocalService.getLayout(((Long)objects[0]).longValue());
            Integer finalType = (Integer)objects[1];
            if (finalType == 1 || finalType == 3 ? !this._hasPermission("UPDATE", layout, permissionChecker) : !this._hasPermission("VIEW", layout, permissionChecker)) {
                return null;
            }
            return new AssetUsage((Object[])objects, finalType){
                final /* synthetic */ Object[] val$objects;
                final /* synthetic */ Integer val$finalType;
                {
                    this.val$objects = objectArray;
                    this.val$finalType = n;
                    this.setName(() -> AssetUsageResourceImpl.this._getName(layout.isDraftLayout(), AssetUsageResourceImpl.this._localization.getLocalization((String)this.val$objects[2], AssetUsageResourceImpl.this.contextUser.getLanguageId(), true)));
                    this.setType(() -> AssetUsageResourceImpl.this._getLayoutUsageTypeLabel(this.val$finalType.intValue()));
                    this.setUrl(() -> AssetUsageResourceImpl.this._getLayoutURL(layout, this.val$finalType));
                }
            };
        });
    }

    private List<Object[]> _getLayoutClassedModelUsageObjectsList(String className, Long assetId, String search) {
        LayoutClassedModelUsageTable layoutClassedModelUsageTable = LayoutClassedModelUsageTable.INSTANCE;
        LayoutTable layoutTable = LayoutTable.INSTANCE;
        return (List)this._layoutClassedModelUsageLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{layoutClassedModelUsageTable.plid, layoutClassedModelUsageTable.type, layoutTable.name}).from((Table)layoutClassedModelUsageTable).innerJoinON((Table)layoutTable, layoutClassedModelUsageTable.plid.eq((Expression)layoutTable.plid)).where(layoutClassedModelUsageTable.classNameId.eq((Object)this._portal.getClassNameId(className)).and((Expression)layoutClassedModelUsageTable.classPK.eq((Object)assetId)).and((Expression)layoutClassedModelUsageTable.containerKey.isNotNull()).and((Expression)layoutClassedModelUsageTable.groupId.in((Object[])ArrayUtil.toArray((long[])this.contextUser.getGroupIds()))).and((Expression)layoutTable.name.like(StringBundler.concat((String[])new String[]{"%<Name%>%", GetterUtil.getString((String)search, (String)""), "%</Name>%"})))));
    }

    private String _getLayoutURL(Layout layout, Integer type) throws Exception {
        if (type == 1) {
            return null;
        }
        ThemeDisplay themeDisplay = this._createThemeDisplay(layout);
        if (type == 3) {
            String layoutFullURL = PortalUtil.getLayoutFullURL((Layout)layout, (ThemeDisplay)themeDisplay);
            layoutFullURL = HttpComponentsUtil.addParameter((String)layoutFullURL, (String)"p_l_mode", (String)"preview");
            return HttpComponentsUtil.addParameter((String)layoutFullURL, (String)"p_p_auth", (String)AuthTokenUtil.getToken((HttpServletRequest)this.contextHttpServletRequest));
        }
        return this._portal.getLayoutURL(layout, themeDisplay);
    }

    private String _getLayoutUsageTypeLabel(long type) {
        if (type == 1L) {
            return LanguageUtil.get((Locale)this.contextUser.getLocale(), (String)"display-page-template");
        }
        if (type == 3L) {
            return LanguageUtil.get((Locale)this.contextUser.getLocale(), (String)"page-template");
        }
        return LanguageUtil.get((Locale)this.contextUser.getLocale(), (String)"page");
    }

    private String _getName(boolean draft, String name) {
        if (draft) {
            name = (String)name + StringBundler.concat((String[])new String[]{" ", "(", LanguageUtil.get((Locale)LocaleUtil.fromLanguageId((String)this.contextUser.getLanguageId(), (boolean)true, (boolean)true), (String)"draft"), ")"});
        }
        return name;
    }

    private List<AssetUsage> _getObjectEntryAssetUsages(Long assetId, ObjectDefinition objectDefinition, String search) throws Exception {
        ArrayList<AssetUsage> assetUsages = new ArrayList<AssetUsage>();
        List objectRelationships = this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId());
        Object[] groupIds = this._getGroupIds(this._getViewableDepotEntries());
        final String languageId = this.contextUser.getLanguageId();
        for (ObjectRelationship objectRelationship : objectRelationships) {
            ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(objectDefinition.getClassName(), this.contextCompany.getCompanyId(), objectRelationship.getType());
            List objectEntries = objectRelatedModelsProvider.getRelatedModels(0L, objectRelationship.getObjectRelationshipId(), ObjectEntryTable.INSTANCE.groupId.in(groupIds), false, assetId.longValue(), search, -1, -1, null);
            for (final ObjectEntry objectEntry : objectEntries) {
                final String finalName = this._getName(objectEntry.isDraft(), objectEntry.getTitleValue(languageId));
                if (!Validator.isBlank((String)search) && !StringUtil.containsIgnoreCase((String)finalName, (String)search)) continue;
                final ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
                assetUsages.add(new AssetUsage(){
                    {
                        this.setName(() -> finalName);
                        this.setType(() -> relatedObjectDefinition.getLabel(languageId));
                        this.setUrl(() -> StringBundler.concat((Object[])new Object[]{AssetUsageResourceImpl.this._portal.getPortalURL(AssetUsageResourceImpl.this.contextHttpServletRequest), AssetUsageResourceImpl.this._portal.getPathMain(), "/cms", "/edit_content_item?&p_l_mode=read&", "p_p_state=", LiferayWindowState.POP_UP, "&objectEntryId=", objectEntry.getObjectEntryId()}));
                    }
                });
            }
        }
        return assetUsages;
    }

    private List<DepotEntry> _getViewableDepotEntries() throws Exception {
        ArrayList<DepotEntry> depotEntries = new ArrayList<DepotEntry>();
        SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, null, (String)DepotEntry.class.getName(), null, (Pagination)Pagination.of((int)-1, (int)-1), queryConfig -> {}, searchContext -> searchContext.setCompanyId(this.contextCompany.getCompanyId()), null, document -> {
            block2: {
                try {
                    depotEntries.add(this._depotEntryService.getDepotEntry(GetterUtil.getLong((String)document.get("entryClassPK"))));
                }
                catch (PortalException portalException) {
                    if (!_log.isInfoEnabled()) break block2;
                    _log.info((Object)("User does not have access to view space " + document.get("entryClassPK")), (Throwable)portalException);
                }
            }
            return null;
        });
        return depotEntries;
    }

    private boolean _hasPermission(String actionId, Layout layout, PermissionChecker permissionChecker) throws Exception {
        long plid = layout.getPlid();
        if (layout.isDraftLayout()) {
            plid = layout.getClassPK();
        }
        return LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (long)plid, (String)actionId);
    }
}

