/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.cms.internal.resource.v1_0;

import com.liferay.depot.model.DepotEntry;
import com.liferay.document.library.display.context.DLMimeTypeDisplayContext;
import com.liferay.headless.batch.engine.dto.v1_0.ImportTask;
import com.liferay.headless.batch.engine.resource.v1_0.ImportTaskResource;
import com.liferay.headless.cms.dto.v1_0.BulkAction;
import com.liferay.headless.cms.dto.v1_0.BulkActionItem;
import com.liferay.headless.cms.dto.v1_0.BulkActionTask;
import com.liferay.headless.cms.dto.v1_0.DefaultPermissionBulkAction;
import com.liferay.headless.cms.dto.v1_0.DeleteBulkAction;
import com.liferay.headless.cms.dto.v1_0.KeywordBulkAction;
import com.liferay.headless.cms.dto.v1_0.PermissionBulkAction;
import com.liferay.headless.cms.dto.v1_0.TaxonomyCategoryBulkAction;
import com.liferay.headless.cms.internal.odata.entity.v1_0.BulkActionEntityModel;
import com.liferay.headless.cms.internal.resource.v1_0.BaseBulkActionResourceImpl;
import com.liferay.headless.cms.resource.v1_0.BulkActionResource;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.model.ObjectEntryVersion;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.rest.filter.factory.FilterFactory;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectEntryVersionLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.search.rest.dto.v1_0.SearchResult;
import com.liferay.portal.search.rest.resource.v1_0.SearchResultResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.trash.TrashHelper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/bulk-action.properties"}, scope=ServiceScope.PROTOTYPE, service={BulkActionResource.class})
public class BulkActionResourceImpl
extends BaseBulkActionResourceImpl {
    private static final EntityModel _entityModel = new BulkActionEntityModel();
    private ObjectDefinition _bulkActionTaskItemObjectDefinition;
    private ObjectDefinition _bulkActionTaskObjectDefinition;
    @Reference
    private DLMimeTypeDisplayContext _dlMimeTypeDisplayContext;
    @Reference(target="(filter.factory.key=default)")
    private FilterFactory<Predicate> _filterFactory;
    @Reference
    private ImportTaskResource.Factory _importTaskResourceFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryFolderLocalService _objectEntryFolderLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryVersionLocalService _objectEntryVersionLocalService;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private SearchResultResource.Factory _searchResultResourceFactory;
    @Reference
    private TrashHelper _trashHelper;

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public BulkActionTask postBulkAction(String search, Filter filter, BulkAction bulkAction) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        BulkAction.Type type = bulkAction.getType();
        if (BulkAction.Type.DEFAULT_PERMISSION_BULK_ACTION.equals((Object)type)) {
            DefaultPermissionBulkAction defaultPermissionBulkAction = (DefaultPermissionBulkAction)bulkAction;
            return this._executeDefaultPermissionBulkAction(defaultPermissionBulkAction, this._getDefaultPermissionBulkActionItemsMap(bulkAction.getBulkActionItems(), GetterUtil.getLong((Object)defaultPermissionBulkAction.getDepotGroupId()), GetterUtil.getBoolean((Object)bulkAction.getSelectAll()), GetterUtil.getString((String)defaultPermissionBulkAction.getTreePath())));
        }
        if (BulkAction.Type.DELETE_BULK_ACTION.equals((Object)type)) {
            return this._executeDeleteBulkAction(bulkAction, this._getBulkActionItemsMap(bulkAction.getBulkActionItems(), filter, search, GetterUtil.getBoolean((Object)bulkAction.getSelectAll())));
        }
        if (BulkAction.Type.KEYWORD_BULK_ACTION.equals((Object)type)) {
            return this._executeKeywordBulkAction(bulkAction, this._getBulkActionItemsMap(bulkAction.getBulkActionItems(), filter, search, GetterUtil.getBoolean((Object)bulkAction.getSelectAll())));
        }
        if (BulkAction.Type.PERMISSION_BULK_ACTION.equals((Object)type)) {
            return this._executePermissionBulkAction(bulkAction, this._getBulkActionItemsMap(bulkAction.getBulkActionItems(), filter, search, GetterUtil.getBoolean((Object)bulkAction.getSelectAll())));
        }
        if (BulkAction.Type.TAXONOMY_CATEGORY_BULK_ACTION.equals((Object)type)) {
            return this._executeTaxonomyCategoryBulkAction(bulkAction, this._getBulkActionItemsMap(bulkAction.getBulkActionItems(), filter, search, GetterUtil.getBoolean((Object)bulkAction.getSelectAll())));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Page<BulkActionItem> postBulkActionItemPreviewPage(Boolean fetchChildren, String search, Filter filter, Pagination pagination, Sort[] sorts, BulkAction bulkAction) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564") || !Objects.equals(bulkAction.getType(), BulkAction.Type.DELETE_BULK_ACTION)) {
            throw new UnsupportedOperationException();
        }
        if (ArrayUtil.isNotEmpty((Object[])sorts)) {
            Sort sort = sorts[0];
            String fieldName = sort.getFieldName();
            if (!StringUtil.equalsIgnoreCase((String)fieldName, (String)"name") && !StringUtil.equalsIgnoreCase((String)fieldName, (String)"usages") || sorts.length > 1) {
                throw new BadRequestException("Only the fields \"name\" and \"usages\" are sortable");
            }
        } else {
            sorts = new Sort[]{new Sort("usages", true)};
        }
        Object[] bulkActionItems = bulkAction.getBulkActionItems();
        if (GetterUtil.getBoolean((Object)fetchChildren)) {
            if (ArrayUtil.isEmpty((Object[])bulkActionItems)) {
                return Page.of(Collections.emptyList());
            }
            Object bulkActionItem = bulkActionItems[0];
            if (bulkActionItems.length > 1 || !Objects.equals(bulkActionItem.getClassName(), ObjectEntryFolder.class.getName())) {
                throw new BadRequestException("\"fetchChildren\" is only supported with a single folder");
            }
            return this._getBulkActionItemPreviewPage(this._getObjectEntryFolderBulkActionItems(bulkActionItem.getClassPK()), pagination, search, sorts[0]);
        }
        if (ArrayUtil.isEmpty((Object[])bulkActionItems) && !GetterUtil.getBoolean((Object)bulkAction.getSelectAll())) {
            return Page.of(Collections.emptyList());
        }
        if (!GetterUtil.getBoolean((Object)bulkAction.getSelectAll())) {
            return this._getBulkActionItemPreviewPage(ListUtil.fromArray((Object[])bulkActionItems), pagination, search, sorts[0]);
        }
        return this._getBulkActionItemPreviewPage(filter, pagination, search, sorts[0]);
    }

    private BulkActionTask _addBulkActionTask(String type) throws Exception {
        final ObjectEntry objectEntry = this._objectEntryLocalService.addObjectEntry(0L, this.contextUser.getUserId(), this._getBulkActionTaskObjectDefinitionId(), 0L, null, (Map)HashMapBuilder.put((Object)"actionName", (Object)type).put((Object)"executionStatus", (Object)"initial").put((Object)"type", (Object)type).build(), new ServiceContext());
        final Map values = objectEntry.getValues();
        return new BulkActionTask(){
            {
                this.setActionName(() -> GetterUtil.getString(values.get("actionName")));
                this.setAuthor(() -> ((ObjectEntry)objectEntry).getUserName());
                this.setCreatedDate(() -> ((ObjectEntry)objectEntry).getCreateDate());
                this.setExecuteStatus(() -> GetterUtil.getString(values.get("executionStatus")));
                this.setExternalReferenceCode(() -> ((ObjectEntry)objectEntry).getExternalReferenceCode());
                this.setId(() -> ((ObjectEntry)objectEntry).getObjectEntryId());
                this.setType(() -> GetterUtil.getString(values.get("type")));
            }
        };
    }

    private void _addBulkActionTaskItem(List<BulkActionItem> bulkActionItems, BulkActionTask bulkActionTask, Map.Entry<String, List<BulkActionItem>> entry, ImportTask importTask, String taskItemDelegateName) throws Exception {
        for (BulkActionItem bulkActionItem : entry.getValue()) {
            this._objectEntryLocalService.addObjectEntry(0L, this.contextUser.getUserId(), this._getBulkActionTaskItemObjectDefinitionId(), 0L, null, (Map)HashMapBuilder.put((Object)"classExternalReferenceCode", (Object)bulkActionItem.getClassExternalReferenceCode()).put((Object)"classPK", (Object)bulkActionItem.getClassPK()).put((Object)"executionStatus", (Object)StringUtil.toLowerCase((String)importTask.getExecuteStatusAsString())).put((Object)"importTaskId", (Object)importTask.getId()).put((Object)"name", (Object)bulkActionItem.getName()).put((Object)"r_bulkActionTaskToBulkActionTaskItems_c_bulkActionTaskId", (Object)bulkActionTask.getId()).put((Object)"type", (Object)(taskItemDelegateName != null ? taskItemDelegateName : "ObjectEntryFolder")).build(), new ServiceContext());
            bulkActionItems.add(bulkActionItem);
        }
    }

    private ImportTaskResource _createImportTaskResource() {
        return this._importTaskResourceFactory.create().httpServletRequest(this.contextHttpServletRequest).httpServletResponse(this.contextHttpServletResponse).uriInfo(this.contextUriInfo).user(this.contextUser).build();
    }

    private BulkActionTask _executeDefaultPermissionBulkAction(DefaultPermissionBulkAction defaultPermissionBulkAction, Map<String, List<BulkActionItem>> bulkActionItemsMap) throws Exception {
        String defaultPermissions = defaultPermissionBulkAction.getDefaultPermissions();
        if (MapUtil.isEmpty(bulkActionItemsMap) || Validator.isNull((String)defaultPermissions)) {
            return new BulkActionTask();
        }
        BulkActionTask bulkActionTask = this._addBulkActionTask(defaultPermissionBulkAction.getTypeAsString());
        ArrayList<BulkActionItem> bulkActionItems = new ArrayList<BulkActionItem>();
        ImportTaskResource importTaskResource = this._createImportTaskResource();
        for (Map.Entry<String, List<BulkActionItem>> entry : bulkActionItemsMap.entrySet()) {
            String taskItemDelegateName = this._getTaskItemDelegateName(entry.getKey());
            ImportTask importTask = importTaskResource.putImportTaskObject(this._getClassName(entry.getKey()), null, null, ImportTask.ImportStrategy.ON_ERROR_CONTINUE.getValue(), taskItemDelegateName, "PARTIAL_UPDATE", this.transform((Collection)entry.getValue(), bulkActionItem -> HashMapBuilder.put((Object)"defaultPermissions", (Object)defaultPermissions).put((Object)"id", (Object)bulkActionItem.getClassPK()).build()));
            this._addBulkActionTaskItem(bulkActionItems, bulkActionTask, entry, importTask, taskItemDelegateName);
        }
        bulkActionTask.setNumberOfItems(bulkActionItems::size);
        return bulkActionTask;
    }

    private BulkActionTask _executeDeleteBulkAction(BulkAction bulkAction, Map<String, List<BulkActionItem>> bulkActionItemsMap) throws Exception {
        if (MapUtil.isEmpty(bulkActionItemsMap)) {
            return new BulkActionTask();
        }
        DeleteBulkAction deleteBulkAction = (DeleteBulkAction)bulkAction;
        BulkActionTask bulkActionTask = this._addBulkActionTask(deleteBulkAction.getTypeAsString());
        ArrayList<BulkActionItem> bulkActionItems = new ArrayList<BulkActionItem>();
        ImportTaskResource importTaskResource = this._createImportTaskResource();
        for (Map.Entry<String, List<BulkActionItem>> entry : bulkActionItemsMap.entrySet()) {
            String taskItemDelegateName = this._getTaskItemDelegateName(entry.getKey());
            ImportTask importTask = importTaskResource.deleteImportTaskObject(this._getClassName(entry.getKey()), null, null, ImportTask.ImportStrategy.ON_ERROR_CONTINUE.getValue(), taskItemDelegateName, this.transform((Collection)entry.getValue(), bulkActionItem -> HashMapBuilder.put((Object)"id", (Object)bulkActionItem.getClassPK()).build()));
            this._addBulkActionTaskItem(bulkActionItems, bulkActionTask, entry, importTask, taskItemDelegateName);
        }
        bulkActionTask.setNumberOfItems(bulkActionItems::size);
        return bulkActionTask;
    }

    private BulkActionTask _executeKeywordBulkAction(BulkAction bulkAction, Map<String, List<BulkActionItem>> bulkActionItemsMap) throws Exception {
        KeywordBulkAction keywordBulkAction = (KeywordBulkAction)bulkAction;
        Object[] keywords = keywordBulkAction.getKeywords();
        if (MapUtil.isEmpty(bulkActionItemsMap) || ArrayUtil.isEmpty((Object[])keywords)) {
            return new BulkActionTask();
        }
        BulkActionTask bulkActionTask = this._addBulkActionTask(keywordBulkAction.getTypeAsString());
        ArrayList<BulkActionItem> bulkActionItems = new ArrayList<BulkActionItem>();
        ImportTaskResource importTaskResource = this._createImportTaskResource();
        for (Map.Entry<String, List<BulkActionItem>> entry : bulkActionItemsMap.entrySet()) {
            if (StringUtil.equals((String)"com.liferay.object.model.ObjectEntryFolder", (String)entry.getKey())) continue;
            String taskItemDelegateName = this._getTaskItemDelegateName(entry.getKey());
            ImportTask importTask = importTaskResource.putImportTaskObject(this._getClassName(entry.getKey()), null, null, ImportTask.ImportStrategy.ON_ERROR_CONTINUE.getValue(), taskItemDelegateName, "PARTIAL_UPDATE", this.transform((Collection)entry.getValue(), arg_0 -> BulkActionResourceImpl.lambda$_executeKeywordBulkAction$2((String[])keywords, arg_0)));
            this._addBulkActionTaskItem(bulkActionItems, bulkActionTask, entry, importTask, taskItemDelegateName);
        }
        bulkActionTask.setNumberOfItems(bulkActionItems::size);
        return bulkActionTask;
    }

    private BulkActionTask _executePermissionBulkAction(BulkAction bulkAction, Map<String, List<BulkActionItem>> bulkActionItemsMap) throws Exception {
        PermissionBulkAction permissionBulkAction = (PermissionBulkAction)bulkAction;
        String configuration = permissionBulkAction.getConfiguration();
        Object[] permissions = permissionBulkAction.getPermissions();
        if (MapUtil.isEmpty(bulkActionItemsMap) || Validator.isNull((String)configuration) && ArrayUtil.isEmpty((Object[])permissions)) {
            return new BulkActionTask();
        }
        BulkActionTask bulkActionTask = this._addBulkActionTask(permissionBulkAction.getTypeAsString());
        ArrayList<BulkActionItem> bulkActionItems = new ArrayList<BulkActionItem>();
        JSONObject configurationJSONObject = this._jsonFactory.createJSONObject(GetterUtil.get((String)configuration, (String)"{}"));
        ImportTaskResource importTaskResource = this._createImportTaskResource();
        HashMap<String, Role> roles = new HashMap<String, Role>();
        for (Map.Entry<String, List<BulkActionItem>> entry : bulkActionItemsMap.entrySet()) {
            String taskItemDelegateName = this._getTaskItemDelegateName(entry.getKey());
            List<HashMap<String, Object>> permissionsList = this._getPermissionsList(configurationJSONObject, entry, (Permission[])permissions, roles);
            if (ListUtil.isEmpty(permissionsList)) continue;
            ImportTask importTask = importTaskResource.putImportTaskObject(this._getClassName(entry.getKey()), null, null, ImportTask.ImportStrategy.ON_ERROR_CONTINUE.getValue(), taskItemDelegateName, "PARTIAL_UPDATE", this.transform((Collection)entry.getValue(), bulkActionItem -> HashMapBuilder.put((Object)"id", (Object)bulkActionItem.getClassPK()).put((Object)"permissions", (Object)permissionsList).build()));
            this._addBulkActionTaskItem(bulkActionItems, bulkActionTask, entry, importTask, taskItemDelegateName);
        }
        bulkActionTask.setNumberOfItems(bulkActionItems::size);
        return bulkActionTask;
    }

    private BulkActionTask _executeTaxonomyCategoryBulkAction(BulkAction bulkAction, Map<String, List<BulkActionItem>> bulkActionItemsMap) throws Exception {
        TaxonomyCategoryBulkAction taxonomyCategoryBulkAction = (TaxonomyCategoryBulkAction)bulkAction;
        Object[] taxonomyCategoryIds = taxonomyCategoryBulkAction.getTaxonomyCategoryIds();
        if (MapUtil.isEmpty(bulkActionItemsMap) || ArrayUtil.isEmpty((Object[])taxonomyCategoryIds)) {
            return new BulkActionTask();
        }
        BulkActionTask bulkActionTask = this._addBulkActionTask(taxonomyCategoryBulkAction.getTypeAsString());
        ArrayList<BulkActionItem> bulkActionItems = new ArrayList<BulkActionItem>();
        ImportTaskResource importTaskResource = this._createImportTaskResource();
        for (Map.Entry<String, List<BulkActionItem>> entry : bulkActionItemsMap.entrySet()) {
            if (StringUtil.equals((String)"com.liferay.object.model.ObjectEntryFolder", (String)entry.getKey())) continue;
            String taskItemDelegateName = this._getTaskItemDelegateName(entry.getKey());
            ImportTask importTask = importTaskResource.putImportTaskObject(this._getClassName(entry.getKey()), null, null, ImportTask.ImportStrategy.ON_ERROR_CONTINUE.getValue(), taskItemDelegateName, "PARTIAL_UPDATE", this.transform((Collection)entry.getValue(), arg_0 -> BulkActionResourceImpl.lambda$_executeTaxonomyCategoryBulkAction$4((Long[])taxonomyCategoryIds, arg_0)));
            this._addBulkActionTaskItem(bulkActionItems, bulkActionTask, entry, importTask, taskItemDelegateName);
        }
        bulkActionTask.setNumberOfItems(bulkActionItems::size);
        return bulkActionTask;
    }

    private Page<BulkActionItem> _getBulkActionItemPreviewPage(Filter filter, Pagination pagination, String search, Sort sort) throws Exception {
        if (filter == null) {
            throw new ValidationException("Filter is null");
        }
        List<BulkActionItem> bulkActionItems = new ArrayList<BulkActionItem>();
        DynamicServletRequest dynamicServletRequest = new DynamicServletRequest(this.contextHttpServletRequest);
        dynamicServletRequest.setParameter("nestedFields", "embedded");
        SearchResultResource searchResultResource = this._searchResultResourceFactory.create().httpServletRequest((HttpServletRequest)dynamicServletRequest).httpServletResponse(this.contextHttpServletResponse).preferredLocale(this.contextUser.getLocale()).uriInfo(this.contextUriInfo).user(this.contextUser).build();
        if (StringUtil.equalsIgnoreCase((String)sort.getFieldName(), (String)"name")) {
            sort.setFieldName(Field.getSortableFieldName((String)"localized_title_".concat(this.contextUser.getLanguageId())));
        }
        Page searchPage = searchResultResource.getSearchPage(null, Boolean.valueOf(true), null, null, search, filter, pagination, new Sort[]{sort});
        for (SearchResult searchResult : searchPage.getItems()) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(String.valueOf(searchResult.getEmbedded()));
            bulkActionItems.add(this._toBulkActionItem(jsonObject.getLong("id")));
        }
        if (StringUtil.equalsIgnoreCase((String)sort.getFieldName(), (String)"usages")) {
            bulkActionItems = this._sortBulkActionItems(bulkActionItems, sort);
        }
        return Page.of(bulkActionItems, (Pagination)pagination, (long)searchPage.getTotalCount());
    }

    private Page<BulkActionItem> _getBulkActionItemPreviewPage(List<BulkActionItem> bulkActionItems1, Pagination pagination, String search, Sort sort) {
        List<Object> bulkActionItems2 = new ArrayList<BulkActionItem>();
        long totalCount = bulkActionItems1.size();
        for (BulkActionItem bulkActionItem2 : bulkActionItems1) {
            bulkActionItems2.add(this._toBulkActionItem(GetterUtil.getLong((Object)bulkActionItem2.getClassPK())));
        }
        if (Validator.isNotNull((String)search)) {
            bulkActionItems2 = ListUtil.filter(bulkActionItems2, bulkActionItem -> StringUtil.containsIgnoreCase((String)bulkActionItem.getName(), (String)search, (String)""));
            totalCount = bulkActionItems2.size();
        }
        return Page.of(this._sortBulkActionItems(bulkActionItems2, sort), (Pagination)pagination, (long)totalCount);
    }

    private Map<String, List<BulkActionItem>> _getBulkActionItemsMap(BulkActionItem[] bulkActionItems, Filter filter, String search, boolean selectAll) throws Exception {
        HashMap<String, List<BulkActionItem>> bulkActionItemsMap = new HashMap<String, List<BulkActionItem>>();
        if (selectAll && ArrayUtil.isEmpty((Object[])bulkActionItems)) {
            if (filter == null) {
                throw new ValidationException("Filter is null");
            }
            SearchResultResource searchResultResource = this._searchResultResourceFactory.create().httpServletRequest(this.contextHttpServletRequest).httpServletResponse(this.contextHttpServletResponse).preferredLocale(this.contextAcceptLanguage.getPreferredLocale()).uriInfo(this.contextUriInfo).user(this.contextUser).build();
            int pageSize = 500;
            int page = 1;
            while (true) {
                Page searchPage = searchResultResource.getSearchPage(null, Boolean.valueOf(true), null, null, search, filter, Pagination.of((int)page, (int)pageSize), null);
                for (SearchResult searchResult : searchPage.getItems()) {
                    final JSONObject jsonObject = this._jsonFactory.createJSONObject(String.valueOf(searchResult.getEmbedded()));
                    bulkActionItemsMap.computeIfAbsent(searchResult.getEntryClassName(), className -> new ArrayList()).add(new BulkActionItem(){
                        {
                            this.setClassExternalReferenceCode(() -> jsonObject.getString("externalReferenceCode"));
                            this.setClassPK(() -> jsonObject.getLong("id"));
                        }
                    });
                }
                if ((long)(page * pageSize) >= searchPage.getTotalCount()) break;
                ++page;
            }
            return bulkActionItemsMap;
        }
        if (ArrayUtil.isEmpty((Object[])bulkActionItems)) {
            return bulkActionItemsMap;
        }
        for (BulkActionItem bulkActionItem : bulkActionItems) {
            bulkActionItemsMap.computeIfAbsent(bulkActionItem.getClassName(), className -> new ArrayList()).add(bulkActionItem);
        }
        return bulkActionItemsMap;
    }

    private long _getBulkActionTaskItemObjectDefinitionId() throws Exception {
        if (this._bulkActionTaskItemObjectDefinition != null) {
            return this._bulkActionTaskItemObjectDefinition.getObjectDefinitionId();
        }
        this._bulkActionTaskItemObjectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_BULK_ACTION_TASK_ITEM", this.contextCompany.getCompanyId());
        return this._bulkActionTaskItemObjectDefinition.getObjectDefinitionId();
    }

    private long _getBulkActionTaskObjectDefinitionId() throws Exception {
        if (this._bulkActionTaskObjectDefinition != null) {
            return this._bulkActionTaskObjectDefinition.getObjectDefinitionId();
        }
        this._bulkActionTaskObjectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_BULK_ACTION_TASK", this.contextCompany.getCompanyId());
        return this._bulkActionTaskObjectDefinition.getObjectDefinitionId();
    }

    private String _getClassName(String key) {
        if (StringUtil.equals((String)key, (String)DepotEntry.class.getName())) {
            return "com.liferay.headless.asset.library.dto.v1_0.AssetLibrary";
        }
        if (StringUtil.equals((String)key, (String)ObjectEntryFolder.class.getName())) {
            return "com.liferay.headless.object.dto.v1_0.ObjectEntryFolder";
        }
        return "com.liferay.object.rest.dto.v1_0.ObjectEntry";
    }

    private Map<String, List<BulkActionItem>> _getDefaultPermissionBulkActionItemsMap(BulkActionItem[] bulkActionItems, long depotGroupId, boolean selectAll, String treePath) throws Exception {
        HashMap<String, List<BulkActionItem>> bulkActionItemsMap = new HashMap<String, List<BulkActionItem>>();
        if (selectAll && ArrayUtil.isEmpty((Object[])bulkActionItems)) {
            if (depotGroupId == 0L && Validator.isNull((String)treePath)) {
                throw new ValidationException();
            }
            String filterString = StringBundler.concat((String[])new String[]{"(className eq '", ObjectEntryFolder.class.getName(), "') and "});
            filterString = Validator.isNull((String)treePath) ? StringBundler.concat((Object[])new Object[]{filterString, "(depotGroupId eq ", depotGroupId, ")"}) : StringBundler.concat((String[])new String[]{filterString, "(startswith(treePath, '", treePath, "'))"});
            return this._populateDefaultPermissionBulkActionItemsMap(bulkActionItemsMap, filterString);
        }
        if (ArrayUtil.isEmpty((Object[])bulkActionItems)) {
            return bulkActionItemsMap;
        }
        BulkActionItem bulkActionItem = bulkActionItems[0];
        String filterString = StringBundler.concat((String[])new String[]{"(className eq '", bulkActionItem.getClassName(), "') and (", StringUtil.merge((Object[])this.transform(bulkActionItems, item -> "(classExternalReferenceCode eq '" + item.getClassExternalReferenceCode() + "')", String.class), (String)" or "), ")"});
        return this._populateDefaultPermissionBulkActionItemsMap(bulkActionItemsMap, filterString);
    }

    private String _getDeletionType(long groupId) throws PortalException {
        if (this._trashHelper.isTrashEnabled(groupId)) {
            return "RECYCLE_BIN";
        }
        return "PERMANENT_DELETION";
    }

    private String _getMimeType(ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws Exception {
        if (Objects.equals(objectDefinition.getExternalReferenceCode(), "L_BASIC_WEB_CONTENT")) {
            return "basic-web-content";
        }
        if (Objects.equals(objectDefinition.getExternalReferenceCode(), "L_BLOG")) {
            return "blog";
        }
        if (Objects.equals(objectDefinition.getExternalReferenceCode(), "L_KNOWLEDGE_BASE")) {
            return "knowledge-base";
        }
        ObjectEntryVersion objectEntryVersion = this._objectEntryVersionLocalService.getObjectEntryVersion(objectEntry.getObjectEntryId(), objectEntry.getVersion());
        JSONObject contentJSONObject = this._jsonFactory.createJSONObject(objectEntryVersion.getContent());
        JSONObject propertiesJSONObject = contentJSONObject.getJSONObject("properties");
        JSONObject fileJSONObject = propertiesJSONObject.getJSONObject("file");
        if (fileJSONObject != null) {
            return this._dlMimeTypeDisplayContext.getIconFileMimeType(fileJSONObject.getString("mimeType"));
        }
        return "custom-structure";
    }

    private List<BulkActionItem> _getObjectEntryFolderBulkActionItems(long objectObjectEntryFolderId) throws Exception {
        ObjectEntryFolder objectEntryFolder = this._objectEntryFolderLocalService.getObjectEntryFolder(objectObjectEntryFolderId);
        List<BulkActionItem> bulkActionItems = this.transform(this._objectEntryLocalService.getObjectEntryFolderObjectEntries(objectEntryFolder.getGroupId(), objectObjectEntryFolderId, -1, -1), this::_toBulkActionItem);
        bulkActionItems.addAll(this.transform(this._objectEntryFolderLocalService.getObjectEntryFolders(objectEntryFolder.getGroupId(), objectEntryFolder.getCompanyId(), objectObjectEntryFolderId, -1, -1), this::_toBulkActionItem));
        return bulkActionItems;
    }

    private List<HashMap<String, Object>> _getPermissionsList(JSONObject configurationJSONObject, Map.Entry<String, List<BulkActionItem>> entry, Permission[] permissions, Map<String, Role> roles) {
        if (ArrayUtil.isNotEmpty((Object[])permissions)) {
            return this.transformToList(permissions, permission -> HashMapBuilder.put((Object)"actionIds", (Object)ListUtil.fromArray((Object[])permission.getActionIds())).put((Object)"roleExternalReferenceCode", (Object)permission.getRoleExternalReferenceCode()).put((Object)"roleName", (Object)permission.getRoleName()).put((Object)"roleType", (Object)permission.getRoleType()).build());
        }
        JSONObject jsonObject = null;
        List resourceActions = null;
        if (Objects.equals(entry.getKey(), ObjectEntryFolder.class.getName())) {
            jsonObject = configurationJSONObject.getJSONObject("OBJECT_ENTRY_FOLDERS");
            resourceActions = ResourceActionsUtil.getResourceActions((String)ObjectEntryFolder.class.getName());
        } else {
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByClassName(this.contextCompany.getCompanyId(), entry.getKey());
            if (objectDefinition == null) {
                return null;
            }
            if (Objects.equals(objectDefinition.getObjectFolderExternalReferenceCode(), "L_CMS_CONTENT_STRUCTURES")) {
                jsonObject = configurationJSONObject.getJSONObject("L_CONTENTS");
            } else if (Objects.equals(objectDefinition.getObjectFolderExternalReferenceCode(), "L_CMS_FILE_TYPES")) {
                jsonObject = configurationJSONObject.getJSONObject("L_FILES");
            }
            resourceActions = ResourceActionsUtil.getResourceActions((String)objectDefinition.getClassName());
        }
        if (jsonObject == null) {
            return null;
        }
        ArrayList<HashMap<String, Object>> permissionsList = new ArrayList<HashMap<String, Object>>();
        JSONObject finalJSONObject = jsonObject;
        List finalResourceActions = resourceActions;
        Iterator iterator = jsonObject.keys();
        iterator.forEachRemaining(key -> {
            Role role;
            if (!roles.containsKey(key)) {
                role = this._roleLocalService.fetchRole(this.contextCompany.getCompanyId(), key);
                if (role == null) {
                    return;
                }
                roles.put((String)key, role);
            }
            role = (Role)roles.get(key);
            permissionsList.add(HashMapBuilder.put((Object)"actionIds", (Object)ListUtil.fromArray((Object[])((String[])ArrayUtil.filter((Object[])JSONUtil.toStringArray((JSONArray)finalJSONObject.getJSONArray(key)), action -> finalResourceActions.contains(action))))).put((Object)"roleExternalReferenceCode", (Object)role.getExternalReferenceCode()).put((Object)"roleName", (Object)role.getName()).put((Object)"roleType", (Object)role.getType()).build());
        });
        return permissionsList;
    }

    private String _getTaskItemDelegateName(String className) throws Exception {
        if (StringUtil.equals((String)DepotEntry.class.getName(), (String)className) || StringUtil.equals((String)ObjectEntryFolder.class.getName(), (String)className)) {
            return null;
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByClassName(this.contextCompany.getCompanyId(), className);
        return objectDefinition.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long _getUsagesCount(String className, long objectDefinitionId, long objectEntryId) throws Exception {
        int usagesCount = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesCount(this._portal.getClassNameId(className), objectEntryId);
        boolean skipObjectEntryResourcePermission = ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission();
        try {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)true);
            List objectRelationships = this._objectRelationshipLocalService.getObjectRelationships(objectDefinitionId);
            for (ObjectRelationship objectRelationship : objectRelationships) {
                ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(className, this.contextCompany.getCompanyId(), objectRelationship.getType());
                usagesCount += objectRelatedModelsProvider.getRelatedModelsCount(0L, objectRelationship.getObjectRelationshipId(), null, objectEntryId, null);
            }
        }
        finally {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)skipObjectEntryResourcePermission);
        }
        return usagesCount;
    }

    private Map<String, List<BulkActionItem>> _populateDefaultPermissionBulkActionItemsMap(Map<String, List<BulkActionItem>> bulkActionItemsMap, String filterString) throws Exception {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_CMS_DEFAULT_PERMISSION", this.contextCompany.getCompanyId());
        Predicate predicate = (Predicate)this._filterFactory.create(filterString, objectDefinition);
        List primaryKeys = this._objectEntryLocalService.getPrimaryKeys(new Long[0], this.contextCompany.getCompanyId(), this.contextUser.getUserId(), objectDefinition.getObjectDefinitionId(), predicate, false, null, -1, -1, null);
        if (ListUtil.isEmpty((List)primaryKeys)) {
            return bulkActionItemsMap;
        }
        Iterator iterator = primaryKeys.iterator();
        while (iterator.hasNext()) {
            final long primaryKey = (Long)iterator.next();
            bulkActionItemsMap.computeIfAbsent(objectDefinition.getClassName(), className -> new ArrayList()).add(new BulkActionItem(){
                {
                    this.setClassPK(() -> primaryKey);
                }
            });
        }
        return bulkActionItemsMap;
    }

    private List<BulkActionItem> _sortBulkActionItems(List<BulkActionItem> bulkActionItems, Sort sort) {
        return ListUtil.sort(bulkActionItems, (bulkActionItem1, bulkActionItem2) -> {
            if (StringUtil.equalsIgnoreCase((String)sort.getFieldName(), (String)"name")) {
                String name = bulkActionItem1.getName();
                int value = name.compareTo(bulkActionItem2.getName());
                if (!sort.isReverse()) {
                    return value;
                }
                return -value;
            }
            Map attributes1 = bulkActionItem1.getAttributes();
            Long usages = GetterUtil.getLong(attributes1.get("usages"));
            Map attributes2 = bulkActionItem2.getAttributes();
            int value = usages.compareTo(GetterUtil.getLong(attributes2.get("usages")));
            if (!sort.isReverse()) {
                return value;
            }
            return -value;
        });
    }

    private BulkActionItem _toBulkActionItem(long classPK) {
        ObjectEntry objectEntry = this._objectEntryLocalService.fetchObjectEntry(classPK);
        if (objectEntry != null) {
            return this._toBulkActionItem(objectEntry);
        }
        return this._toBulkActionItem(this._objectEntryFolderLocalService.fetchObjectEntryFolder(classPK));
    }

    private BulkActionItem _toBulkActionItem(ObjectEntry objectEntry) {
        BulkActionItem bulkActionItem = new BulkActionItem();
        bulkActionItem.setClassPK(() -> ((ObjectEntry)objectEntry).getObjectEntryId());
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(objectEntry.getObjectDefinitionId());
        bulkActionItem.setAttributes(() -> HashMapBuilder.put((Object)"deletionType", () -> this._getDeletionType(objectEntry.getGroupId())).put((Object)"mimeType", (Object)this._getMimeType(objectDefinition, objectEntry)).put((Object)"type", (Object)"ASSET").put((Object)"usages", (Object)this._getUsagesCount(objectDefinition.getClassName(), objectDefinition.getObjectDefinitionId(), objectEntry.getObjectEntryId())).build());
        bulkActionItem.setClassExternalReferenceCode(() -> ((ObjectEntry)objectEntry).getExternalReferenceCode());
        bulkActionItem.setClassName(() -> ((ObjectDefinition)objectDefinition).getClassName());
        bulkActionItem.setName(() -> objectEntry.getTitleValue(LocaleUtil.toLanguageId((Locale)this.contextUser.getLocale()), true));
        return bulkActionItem;
    }

    private BulkActionItem _toBulkActionItem(ObjectEntryFolder objectEntryFolder) {
        BulkActionItem bulkActionItem = new BulkActionItem();
        bulkActionItem.setClassPK(() -> ((ObjectEntryFolder)objectEntryFolder).getObjectEntryFolderId());
        bulkActionItem.setAttributes(() -> HashMapBuilder.put((Object)"deletionType", () -> this._getDeletionType(objectEntryFolder.getGroupId())).put((Object)"itemsCount", () -> {
            long itemsCount = this._objectEntryFolderLocalService.getObjectEntryFoldersCount(objectEntryFolder.getGroupId(), objectEntryFolder.getCompanyId(), objectEntryFolder.getObjectEntryFolderId());
            return itemsCount += (long)this._objectEntryLocalService.getObjectEntryFolderObjectEntriesCount(objectEntryFolder.getGroupId(), objectEntryFolder.getObjectEntryFolderId());
        }).put((Object)"type", (Object)"FOLDER").build());
        bulkActionItem.setClassExternalReferenceCode(() -> ((ObjectEntryFolder)objectEntryFolder).getExternalReferenceCode());
        bulkActionItem.setClassName(() -> ((ObjectEntryFolder)objectEntryFolder).getModelClassName());
        bulkActionItem.setName(() -> ((ObjectEntryFolder)objectEntryFolder).getName());
        return bulkActionItem;
    }

    private static /* synthetic */ HashMap lambda$_executeTaxonomyCategoryBulkAction$4(Long[] taxonomyCategoryIds, BulkActionItem bulkActionItem) throws RuntimeException {
        return HashMapBuilder.put((Object)"id", (Object)bulkActionItem.getClassPK()).put((Object)"taxonomyCategoryIds", (Object)taxonomyCategoryIds).build();
    }

    private static /* synthetic */ HashMap lambda$_executeKeywordBulkAction$2(String[] keywords, BulkActionItem bulkActionItem) throws RuntimeException {
        return HashMapBuilder.put((Object)"id", (Object)bulkActionItem.getClassPK()).put((Object)"keywords", (Object)keywords).build();
    }
}

