/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.cmp.internal.resource.v1_0;

import com.liferay.headless.cmp.dto.v1_0.TaskAssignee;
import com.liferay.headless.cmp.internal.resource.v1_0.BaseTaskAssigneeResourceImpl;
import com.liferay.headless.cmp.resource.v1_0.TaskAssigneeResource;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.vulcan.pagination.Page;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/task-assignee.properties"}, scope=ServiceScope.PROTOTYPE, service={TaskAssigneeResource.class})
public class TaskAssigneeResourceImpl
extends BaseTaskAssigneeResourceImpl {
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public Page<TaskAssignee> getTaskAssigneesPage(String search) throws Exception {
        SearchResponse searchResponse = this._searcher.search(this._searchRequestBuilderFactory.builder().companyId(Long.valueOf(this.contextCompany.getCompanyId())).emptySearchEnabled(true).entryClassNames(new String[]{Role.class.getName(), User.class.getName()}).query((Query)this._getBooleanQuery(search)).size(Integer.valueOf(20)).build());
        SearchHits searchHits = searchResponse.getSearchHits();
        return Page.of(this.transform(searchHits.getSearchHits(), searchHit -> this._toTaskAssignee(searchHit.getDocument())));
    }

    private String _getAssigneeName(String assigneeType, Document document) {
        if (StringUtil.equals((String)assigneeType, (String)"User")) {
            return document.getString("fullName");
        }
        return document.getString("name");
    }

    private BooleanQuery _getBooleanQuery(String search) throws Exception {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        BooleanQuery roleBooleanQuery = this._queries.booleanQuery();
        Role guestRole = this._roleLocalService.getRole(this.contextCompany.getCompanyId(), "Guest");
        roleBooleanQuery.addMustNotQueryClauses(new Query[]{this._queries.term("entryClassPK", (Object)guestRole.getRoleId())});
        if (Validator.isNull((String)search)) {
            return booleanQuery.addShouldQueryClauses(new Query[]{roleBooleanQuery});
        }
        roleBooleanQuery.addMustQueryClauses(new Query[]{this._queries.matchPhrasePrefix("name", (Object)search), this._queries.term("entryClassName", (Object)Role.class.getName())});
        BooleanQuery userBooleanQuery = this._queries.booleanQuery();
        userBooleanQuery.addMustQueryClauses(new Query[]{this._queries.matchPhrasePrefix("fullName", (Object)search), this._queries.term("entryClassName", (Object)User.class.getName())});
        return booleanQuery.addShouldQueryClauses(new Query[]{roleBooleanQuery, userBooleanQuery});
    }

    private TaskAssignee _toTaskAssignee(final Document document) {
        final String assigneeType = StringUtil.extractLast((String)document.getString("entryClassName"), (String)".");
        final String assigneeName = this._getAssigneeName(assigneeType, document);
        if (Validator.isNull((String)assigneeName)) {
            return null;
        }
        return new TaskAssignee(){
            {
                this.setExternalReferenceCode(() -> document.getString("externalReferenceCode"));
                this.setImage(() -> {
                    if (!StringUtil.equals((String)assigneeType, (String)"User")) {
                        return null;
                    }
                    User user = TaskAssigneeResourceImpl.this._userLocalService.fetchUser(document.getLong("entryClassPK").longValue());
                    if (user == null || user.getPortraitId() == 0L) {
                        return null;
                    }
                    return user.getPortraitURL(new ThemeDisplay(){
                        {
                            this.setPathImage(TaskAssigneeResourceImpl.this._portal.getPathImage());
                        }
                    });
                });
                this.setName(() -> assigneeName);
                this.setType(() -> assigneeType);
            }
        };
    }
}

