/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.cmp.internal.resource.v1_0;

import com.liferay.depot.model.DepotEntryModel;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.headless.cmp.dto.v1_0.TaskStatistics;
import com.liferay.headless.cmp.internal.resource.v1_0.BaseTaskStatisticsResourceImpl;
import com.liferay.headless.cmp.resource.v1_0.TaskStatisticsResource;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.rest.filter.factory.FilterFactory;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/task-statistics.properties"}, scope=ServiceScope.PROTOTYPE, service={TaskStatisticsResource.class})
public class TaskStatisticsResourceImpl
extends BaseTaskStatisticsResourceImpl {
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference(target="(filter.factory.key=default)")
    private FilterFactory<Predicate> _filterFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private Queries _queries;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;

    @Override
    public TaskStatistics getProjectTaskStatistics(Long projectId, Filter filter) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-58677")) {
            throw new UnsupportedOperationException();
        }
        return this._toTaskStatistics(this._objectEntryLocalService.getObjectEntry(GetterUtil.getLong((Object)projectId)), this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_CMP_TASK", this.contextCompany.getCompanyId()));
    }

    @Override
    public TaskStatistics getTaskStatistics(Filter filter) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-58677")) {
            throw new UnsupportedOperationException();
        }
        return this._toTaskStatistics(null, this._objectDefinitionLocalService.getObjectDefinitionByExternalReferenceCode("L_CMP_TASK", this.contextCompany.getCompanyId()));
    }

    private long _getCount(String filterString, ObjectEntry projectObjectEntry, ObjectDefinition taskObjectDefinition) throws Exception {
        List<Long> groupIds = new ArrayList<Long>();
        if (projectObjectEntry == null) {
            groupIds = this.transform(this._depotEntryLocalService.getDepotEntries(this.contextCompany.getCompanyId(), 2), DepotEntryModel::getGroupId);
        } else {
            groupIds.add(projectObjectEntry.getGroupId());
        }
        return this._objectEntryLocalService.getValuesListCount(groupIds.toArray(new Long[0]), 0L, 0L, taskObjectDefinition.getObjectDefinitionId(), (Predicate)this._filterFactory.create(filterString, taskObjectDefinition), true, null);
    }

    private TaskStatistics _toTaskStatistics(final ObjectEntry projectObjectEntry, final ObjectDefinition taskObjectDefinition) {
        return new TaskStatistics(){
            {
                this.setBlockedCount(() -> TaskStatisticsResourceImpl.this._getCount("state eq 'blocked'", projectObjectEntry, taskObjectDefinition));
                this.setInProgressCount(() -> TaskStatisticsResourceImpl.this._getCount("state eq 'inProgress'", projectObjectEntry, taskObjectDefinition));
                this.setOverdueCount(() -> TaskStatisticsResourceImpl.this._getCount("dueDate lt " + String.valueOf(LocalDate.now()) + " and state ne 'done'", projectObjectEntry, taskObjectDefinition));
                this.setTotalCount(() -> {
                    long tasksTotalCount = TaskStatisticsResourceImpl.this._getCount("", projectObjectEntry, taskObjectDefinition);
                    if (projectObjectEntry != null) {
                        return tasksTotalCount;
                    }
                    SearchResponse searchResponse = TaskStatisticsResourceImpl.this._searcher.search(TaskStatisticsResourceImpl.this._searchRequestBuilderFactory.builder().companyId(Long.valueOf(TaskStatisticsResourceImpl.this.contextCompany.getCompanyId())).emptySearchEnabled(true).entryClassNames(new String[]{KaleoTaskInstanceToken.class.getName()}).query((Query)TaskStatisticsResourceImpl.this._queries.wildcard("assetTagNames.lowercase", "L_CMP_TASK*")).build());
                    return tasksTotalCount + (long)searchResponse.getTotalHits();
                });
            }
        };
    }
}

