/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.resource.v1_0.AssetLibraryResource;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseAssetLibraryResourceImpl
implements AssetLibraryResource {
    protected AcceptLanguage contextAcceptLanguage;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    private static final Log _log = LogFactoryUtil.getLog(BaseAssetLibraryResourceImpl.class);

    @Operation(description="Adds a new asset library")
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary postAssetLibrary(AssetLibrary assetLibrary) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Deletes the asset library by the site Id, and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/by-site-id/{siteId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryBySite(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId) throws Exception {
    }

    @Operation(description="Retrieves the asset library by the site Id.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/by-site-id/{siteId}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary getAssetLibraryBySite(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Updates the asset library using only the fields received in the request body. Any other fields are left untouched. Returns the updated asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/asset-libraries/by-site-id/{siteId}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary patchAssetLibraryBySite(@Parameter(hidden=true) @NotNull @PathParam(value="siteId") Long siteId, AssetLibrary assetLibrary) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Deletes the asset library and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId) throws Exception {
    }

    @Operation(description="Retrieves the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary getAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Updates the asset library using only the fields received in the request body. Any other fields are left untouched. Returns the updated asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/asset-libraries/{assetLibraryId}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary patchAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, AssetLibrary assetLibrary) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Removes an asset library link with the received asset library and site ids. Returns the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="toSiteId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryId}/links/{toSiteId}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary deleteAssetLibraryLinkToSite(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="toSiteId") Long toSiteId) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Adds an asset library link with the received asset library and site ids. Returns the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.PATH, name="toSiteId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Path(value="/asset-libraries/{assetLibraryId}/links/{toSiteId}")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary postAssetLibraryLinkToSite(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, @Parameter(hidden=true) @NotNull @PathParam(value="toSiteId") Long toSiteId) throws Exception {
        return new AssetLibrary();
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        if (contextHttpServletRequest != null && contextHttpServletRequest.getAttribute("CTX") == null) {
            contextHttpServletRequest.setAttribute("CTX", (Object)ServletContextPool.get((String)""));
        }
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        try {
            return this.unsafeTransformToLongArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return (long[])this._unsafeTransformToPrimitiveArray(collection, unsafeFunction, long[].class);
    }

    private <T, R, E extends Throwable> Object _unsafeTransformToPrimitiveArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        List<R> list = this.unsafeTransform(collection, unsafeFunction);
        Object array = clazz.cast(Array.newInstance(clazz.getComponentType(), list.size()));
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }
}

