/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.depot.model.DepotAppCustomization;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotAppCustomizationLocalService;
import com.liferay.depot.service.DepotEntryGroupRelService;
import com.liferay.depot.service.DepotEntryService;
import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseAssetLibraryResourceImpl;
import com.liferay.headless.asset.library.resource.v1_0.AssetLibraryResource;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/asset-library.properties"}, scope=ServiceScope.PROTOTYPE, service={AssetLibraryResource.class})
public class AssetLibraryResourceImpl
extends BaseAssetLibraryResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.asset.library.internal.dto.v1_0.converter.AssetLibraryDTOConverter)")
    private DTOConverter<DepotEntry, AssetLibrary> _assetLibraryDTOConverter;
    @Reference
    private DepotAppCustomizationLocalService _depotAppCustomizationLocalService;
    @Reference
    private DepotEntryGroupRelService _depotEntryGroupRelService;
    @Reference
    private DepotEntryService _depotEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;

    @Override
    public void deleteAssetLibrary(Long assetLibraryId) throws Exception {
        this.deleteAssetLibraryBySite(assetLibraryId);
    }

    @Override
    public void deleteAssetLibraryBySite(Long siteId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-32649")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(siteId.longValue());
        this._depotEntryService.deleteDepotEntry(depotEntry.getDepotEntryId());
    }

    @Override
    public AssetLibrary deleteAssetLibraryLinkToSite(Long assetLibraryId, Long toSiteId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-32649")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        DepotEntryGroupRel depotEntryGroupRel = this._depotEntryGroupRelService.getDepotEntryGroupRelByDepotEntryIdToGroupId(depotEntry.getDepotEntryId(), toSiteId.longValue());
        this._depotEntryGroupRelService.deleteDepotEntryGroupRel(depotEntryGroupRel.getDepotEntryGroupRelId());
        return this.getAssetLibrary(assetLibraryId);
    }

    @Override
    public AssetLibrary getAssetLibrary(Long assetLibraryId) throws Exception {
        return this.getAssetLibraryBySite(assetLibraryId);
    }

    @Override
    public AssetLibrary getAssetLibraryBySite(Long siteId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-32649")) {
            throw new UnsupportedOperationException();
        }
        return this._toAssetLibrary(this._depotEntryService.getGroupDepotEntry(siteId.longValue()));
    }

    @Override
    public AssetLibrary patchAssetLibrary(Long assetLibraryId, AssetLibrary assetLibrary) throws Exception {
        return this.patchAssetLibraryBySite(assetLibraryId, assetLibrary);
    }

    @Override
    public AssetLibrary patchAssetLibraryBySite(Long siteId, AssetLibrary assetLibrary) throws Exception {
        Map descriptionMap;
        String description;
        Map nameMap;
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-32649")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(siteId.longValue());
        String name = assetLibrary.getName();
        Group group = depotEntry.getGroup();
        if (name == null) {
            name = group.getName(this.contextAcceptLanguage.getPreferredLocale());
        }
        if ((nameMap = assetLibrary.getName_i18n()) == null) {
            nameMap = LocalizedMapUtil.getI18nMap((Map)group.getNameMap());
        }
        if ((description = assetLibrary.getDescription()) == null) {
            description = group.getDescription(this.contextAcceptLanguage.getPreferredLocale());
        }
        if ((descriptionMap = assetLibrary.getDescription_i18n()) == null) {
            descriptionMap = LocalizedMapUtil.getI18nMap((Map)group.getDescriptionMap());
        }
        HashMap<String, Boolean> depotAppCustomizationMap = new HashMap<String, Boolean>();
        for (DepotAppCustomization depotAppCustomization : this._depotAppCustomizationLocalService.getDepotAppCustomizations(depotEntry.getDepotEntryId())) {
            depotAppCustomizationMap.put(depotAppCustomization.getPortletId(), depotAppCustomization.isEnabled());
        }
        return this._toAssetLibrary(this._depotEntryService.updateDepotEntry(depotEntry.getDepotEntryId(), LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)name, (Map)nameMap), LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)description, (Map)descriptionMap), depotAppCustomizationMap, group.getTypeSettingsProperties(), this._getServiceContext()));
    }

    @Override
    public AssetLibrary postAssetLibrary(AssetLibrary assetLibrary) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-32649")) {
            throw new UnsupportedOperationException();
        }
        return this._toAssetLibrary(this._depotEntryService.addDepotEntry(LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)assetLibrary.getName(), (Map)assetLibrary.getName_i18n()), LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)assetLibrary.getDescription(), (Map)assetLibrary.getDescription_i18n()), this._getServiceContext()));
    }

    @Override
    public AssetLibrary postAssetLibraryLinkToSite(Long assetLibraryId, Long toSiteId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-32649")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        this._depotEntryGroupRelService.addDepotEntryGroupRel(depotEntry.getDepotEntryId(), toSiteId.longValue());
        return this.getAssetLibrary(assetLibraryId);
    }

    private ServiceContext _getServiceContext() throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DepotEntry.class.getName(), (HttpServletRequest)this.contextHttpServletRequest);
        serviceContext.setModifiedDate(new Date());
        return serviceContext;
    }

    private AssetLibrary _toAssetLibrary(DepotEntry depotEntry) throws Exception {
        return (AssetLibrary)this._assetLibraryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_DEPOT_ENTRY", (GroupedModel)depotEntry, "postAssetLibrary")).put((Object)"delete", this.addAction("DELETE", (GroupedModel)depotEntry, "deleteAssetLibrary")).put((Object)"delete-by-site", this.addAction("DELETE", (GroupedModel)depotEntry, "deleteAssetLibraryBySite")).put((Object)"get", this.addAction("VIEW", (GroupedModel)depotEntry, "getAssetLibrary")).put((Object)"get-by-site", this.addAction("VIEW", (GroupedModel)depotEntry, "getAssetLibraryBySite")).put((Object)"update", this.addAction("UPDATE", (GroupedModel)depotEntry, "patchAssetLibrary")).put((Object)"update-by-site", this.addAction("UPDATE", (GroupedModel)depotEntry, "patchAssetLibraryBySite")).build(), this._dtoConverterRegistry, (Object)depotEntry.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }
}

