/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.jasper.jspc.CompileJSPTask;
import com.liferay.gradle.plugins.jasper.jspc.JspCPlugin;
import com.liferay.gradle.plugins.util.BndUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.util.PatternFilterable;

public class JspCDefaultsPlugin
extends BaseDefaultsPlugin<JspCPlugin> {
    public static final String COMPILE_JSP_INCLUDE_PROPERTY_NAME = "compile.jsp.include";
    public static final Plugin<Project> INSTANCE = new JspCDefaultsPlugin();
    public static final String JSP_PRECOMPILE_POOLING_ENABLED_PROPERTY_NAME = "jsp.precompile.pooling.enabled.modules";

    @Override
    protected void applyPluginDefaults(Project project, JspCPlugin jspCPlugin) {
        ExtensionContainer extensionContainer = project.getExtensions();
        final BundleExtension bundleExtension = BndUtil.getBundleExtension(extensionContainer);
        Convention convention = project.getConvention();
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)convention.getPlugin(JavaPluginConvention.class);
        SourceSetContainer javaSourceSetContainer = javaPluginConvention.getSourceSets();
        SourceSet javaMainSourceSet = (SourceSet)javaSourceSetContainer.getByName("main");
        final TaskProvider compileJSPTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"compileJSP", JavaCompile.class);
        final TaskProvider generateJSPJavaTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"generateJSPJava", CompileJSPTask.class);
        TaskProvider jarTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"jar", Jar.class);
        TaskProvider processResourcesTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"processResources", Copy.class);
        this._configureTaskGenerateJSPJavaProvider(javaMainSourceSet, (TaskProvider<CompileJSPTask>)generateJSPJavaTaskProvider, (TaskProvider<Copy>)processResourcesTaskProvider);
        this._configureTaskJarProvider(project, (TaskProvider<JavaCompile>)compileJSPTaskProvider, (TaskProvider<Jar>)jarTaskProvider);
        this._configureTaskProcessResourcesProvider(javaMainSourceSet, (TaskProvider<Copy>)processResourcesTaskProvider);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JspCDefaultsPlugin.this._configureExtensionBundleAfterEvaluate(bundleExtension, (TaskProvider<JavaCompile>)compileJSPTaskProvider, (TaskProvider<CompileJSPTask>)generateJSPJavaTaskProvider);
            }
        });
    }

    @Override
    protected Class<JspCPlugin> getPluginClass() {
        return JspCPlugin.class;
    }

    private JspCDefaultsPlugin() {
    }

    private void _configureExtensionBundleAfterEvaluate(BundleExtension bundleExtension, TaskProvider<JavaCompile> compileJSPTaskProvider, TaskProvider<CompileJSPTask> generateJSPJavaTaskProvider) {
        StringBuilder sb = new StringBuilder();
        JavaCompile compileJSPJavaCompile = (JavaCompile)compileJSPTaskProvider.get();
        DirectoryProperty directoryProperty = compileJSPJavaCompile.getDestinationDirectory();
        Provider provider = directoryProperty.getAsFile();
        File file = (File)provider.getOrNull();
        if (file != null) {
            sb.append(FileUtil.getAbsolutePath((File)file));
            sb.append(',');
        }
        CompileJSPTask generateJSPJavaCompileJSPTask = (CompileJSPTask)generateJSPJavaTaskProvider.get();
        sb.append(FileUtil.getAbsolutePath((File)generateJSPJavaCompileJSPTask.getDestinationDir()));
        bundleExtension.instruction("-add-resource", sb.toString());
    }

    private void _configureTaskGenerateJSPJavaProvider(final SourceSet javaMainSourceSet, TaskProvider<CompileJSPTask> generateJSPJavaTaskProvider, final TaskProvider<Copy> processResourcesTaskProvider) {
        generateJSPJavaTaskProvider.configure((Action)new Action<CompileJSPTask>(){

            public void execute(CompileJSPTask generateJSPJavaCompileJSPTask) {
                generateJSPJavaCompileJSPTask.dependsOn(new Object[]{processResourcesTaskProvider});
                generateJSPJavaCompileJSPTask.setPoolingEnabled(GradleUtil.getProperty((ExtensionAware)generateJSPJavaCompileJSPTask, (String)JspCDefaultsPlugin.JSP_PRECOMPILE_POOLING_ENABLED_PROPERTY_NAME, (boolean)false));
                generateJSPJavaCompileJSPTask.setWebAppDir((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        SourceSetOutput sourceSetOutput = javaMainSourceSet.getOutput();
                        return new File(sourceSetOutput.getResourcesDir(), "META-INF/resources");
                    }
                });
            }
        });
    }

    private void _configureTaskJarProvider(final Project project, final TaskProvider<JavaCompile> compileJSPTaskProvider, TaskProvider<Jar> jarTaskProvider) {
        jarTaskProvider.configure((Action)new Action<Jar>(){

            public void execute(Jar jar) {
                boolean compileJspInclude = GradleUtil.getProperty((ExtensionAware)project, (String)JspCDefaultsPlugin.COMPILE_JSP_INCLUDE_PROPERTY_NAME, (boolean)false);
                if (compileJspInclude) {
                    jar.dependsOn(new Object[]{compileJSPTaskProvider});
                }
            }
        });
    }

    private void _configureTaskProcessResourcesProvider(final SourceSet javaMainSourceSet, TaskProvider<Copy> processResourcesTaskProvider) {
        processResourcesTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy processResourcesCopy) {
                File tagsDir;
                processResourcesCopy.setDuplicatesStrategy(DuplicatesStrategy.INCLUDE);
                SourceDirectorySet sourceDirectorySet = javaMainSourceSet.getResources();
                FileTree fileTree = sourceDirectorySet.getAsFileTree();
                fileTree = fileTree.matching((Action)new Action<PatternFilterable>(){

                    public void execute(PatternFilterable patternFilterable) {
                        patternFilterable.include(new String[]{"**/*.tld"});
                    }
                });
                processResourcesCopy.from((Object)fileTree.getFiles(), (Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.into((Object)"META-INF/resources/WEB-INF");
                    }
                });
                Set srcDirs = sourceDirectorySet.getSrcDirs();
                Iterator iterator = srcDirs.iterator();
                if (iterator.hasNext() && (tagsDir = new File((File)iterator.next(), "META-INF/tags")).exists()) {
                    processResourcesCopy.from((Object)tagsDir, (Action)new Action<CopySpec>(){

                        public void execute(CopySpec copySpec) {
                            copySpec.into((Object)"META-INF/resources/META-INF/tags");
                        }
                    });
                }
            }
        });
    }
}

