/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import aQute.bnd.version.Version;
import com.google.gson.annotations.SerializedName;
import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.ResourceUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;

public class LiferayWorkspaceNodePlugin
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new LiferayWorkspaceNodePlugin();
    public static final String NODE_LTS_PROPERTY_NAME = "liferay.workspace.node.lts.codename";
    private static final String _DEFAULT_NODE_CACHE_DIR_NAME = ".liferay/node";
    private static final File _NODE_CACHE_DIR = new File(System.getProperty("user.home"), ".liferay/node");
    private static final String _PRODUCT_NODE_URL = "https://nodejs.org/dist/index.json";
    private final NodeInfos _nodeInfos = ResourceUtil.readJson(NodeInfos.class, ResourceUtil.getURLResolver(_NODE_CACHE_DIR, "https://nodejs.org/dist/index.json"), ResourceUtil.getClassLoaderResolver("/.node_info.json"));

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        this._configureLTS(project);
    }

    private LiferayWorkspaceNodePlugin() {
    }

    private void _configureLTS(Project project) {
        this._getLTSNodeInfoOptional(project).ifPresent(nodeInfo -> {
            NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)project, NodeExtension.class);
            String nodeVersion = nodeInfo.getNodeVersion();
            String npmVersion = nodeInfo.getNpmVersion();
            Logger logger = project.getLogger();
            if (logger.isInfoEnabled()) {
                String lts = nodeInfo.getLts();
                logger.info("Using {} LTS Node version: {}", (Object)StringUtil.quote(lts), (Object)nodeVersion);
                logger.info("Using {} LTS NPM version: {}", (Object)StringUtil.quote(lts), (Object)npmVersion);
            }
            nodeExtension.setNodeVersion((Object)nodeVersion);
            nodeExtension.setNpmVersion((Object)npmVersion);
        });
    }

    private String _getLts(Project project) {
        return GradleUtil.getProperty((ExtensionAware)project, (String)NODE_LTS_PROPERTY_NAME, (String)null);
    }

    private Optional<NodeInfo> _getLTSNodeInfoOptional(Project project) {
        Logger logger;
        String lts = this._getLts(project);
        if (Validator.isNull((String)lts)) {
            return Optional.empty();
        }
        Optional<NodeInfo> nodeInfoOptional = this._nodeInfos.stream().filter(nodeInfo -> Objects.equals(nodeInfo.getLts(), lts)).max((first, second) -> {
            Version firstVersion = Version.parseVersion((String)first.getNodeVersion());
            Version secondVersion = Version.parseVersion((String)second.getNodeVersion());
            return firstVersion.compareTo(secondVersion);
        });
        if (!nodeInfoOptional.isPresent() && (logger = project.getLogger()).isErrorEnabled()) {
            logger.error("Property {} must be one of: {}", (Object)StringUtil.quote(NODE_LTS_PROPERTY_NAME), (Object)this._nodeInfos.stream().map(NodeInfo::getLts).distinct().filter(nodeInfoLts -> !Objects.equals(nodeInfoLts, "false")).sorted().collect(Collectors.joining(", ")));
        }
        return nodeInfoOptional;
    }

    private static class NodeInfos
    extends ArrayList<NodeInfo> {
        private NodeInfos() {
        }
    }

    private static class NodeInfo {
        @SerializedName(value="lts")
        private String _lts;
        @SerializedName(value="version")
        private String _nodeVersion;
        @SerializedName(value="npm")
        private String _npmVersion;

        private NodeInfo() {
        }

        public String getLts() {
            return this._lts;
        }

        public String getNodeVersion() {
            return this._nodeVersion.substring(1);
        }

        public String getNpmVersion() {
            return this._npmVersion;
        }
    }
}

