/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.util;

import com.google.gson.Gson;
import com.liferay.portal.tools.bundle.support.commands.DownloadCommand;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.gradle.api.GradleException;

public class ResourceUtil {
    private static final Gson _gson = new Gson();

    public static Resolver getClassLoaderResolver(String resourcePath) {
        return () -> Objects.requireNonNull(ResourceUtil.class.getResourceAsStream(resourcePath), "Could not get resource from classpath: " + resourcePath);
    }

    public static Resolver getURLResolver(File cacheDir, String url) {
        return () -> {
            try {
                DownloadCommand downloadCommand = new DownloadCommand();
                downloadCommand.setCacheDir(cacheDir);
                downloadCommand.setConnectionTimeout(5000);
                downloadCommand.setPassword(null);
                downloadCommand.setQuiet(true);
                downloadCommand.setToken(false);
                downloadCommand.setUrl(new URL(url));
                downloadCommand.setUserName(null);
                downloadCommand.execute();
                return Files.newInputStream(downloadCommand.getDownloadPath(), new OpenOption[0]);
            }
            catch (Exception exception) {
                throw new Exception(String.format("Unable to get resource from URL %s: %s", url, exception.getMessage()), exception);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readJson(Class<T> clazz, Resolver ... resolvers) {
        Resolver[] resolverArray = resolvers;
        int n = resolverArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resolver resolver = resolverArray[n2];
            try (InputStream inputStream = resolver.resolve();){
                if (inputStream != null) {
                    Object object = _gson.fromJson((Reader)new InputStreamReader(inputStream), clazz);
                    return (T)object;
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            ++n2;
        }
        throw new GradleException("Unable to get resource");
    }

    @FunctionalInterface
    public static interface Resolver {
        public InputStream resolve() throws Exception;
    }
}

