/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Sets;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import com.liferay.petra.string.StringBundler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class CreateClientExtensionConfigTask
extends DefaultTask {
    private static final String _CLIENT_EXTENSION_CONFIG_FILE_NAME = ".client-extension-config.json";
    private static final String _PLUGIN_PACKAGE_PROPERTIES_PATH = "WEB-INF/liferay-plugin-package.properties";
    private static final String _SITE_INITIALIZER_JSON_PATH = "site-initializer/site-initializer.json";
    private static final Set<String> _groupBatch = Sets.newHashSet((Object[])new String[]{"batch", "configuration"});
    private static final Set<String> _groupConfiguration = Sets.newHashSet((Object[])new String[]{"configuration"});
    private static final Set<String> _groupFrontend = Sets.newHashSet((Object[])new String[]{"configuration", "frontend"});
    private static final Set<String> _groupMicroservice = Sets.newHashSet((Object[])new String[]{"configuration", "microservice"});
    private static final Map<String, String> _typeSettingsToSiteInitializerJsonKeyMap = new HashMap<String, String>(){
        {
            this.put("builtInTemplateKey", "templateKey");
            this.put("builtInTemplateType", "templateType");
            this.put("membershipType", "membershipType");
            this.put("parentSiteKey", "parentSiteKey");
            this.put("siteExternalReferenceCode", "externalReferenceCode");
            this.put("siteName", "name");
        }
    };
    private final Object _clientExtensionConfigFile;
    private Properties _clientExtensionProperties;
    private final Set<ClientExtension> _clientExtensions = new HashSet<ClientExtension>();
    private Object _dockerFile;
    private Object _lcpJsonFile;
    private final ObjectMapper _objectMapper = new ObjectMapper();
    private final Object _pluginPackagePropertiesFile;
    private final Project _project = this.getProject();
    private final Object _siteInitializerJsonFile;
    private String _type = "frontend";

    public CreateClientExtensionConfigTask() {
        this._clientExtensionConfigFile = this._addTaskOutputFile(this._project.getName() + _CLIENT_EXTENSION_CONFIG_FILE_NAME);
        this._dockerFile = this._addTaskOutputFile("Dockerfile");
        this._lcpJsonFile = this._addTaskOutputFile("LCP.json");
        this._pluginPackagePropertiesFile = this._addTaskOutputFile(_PLUGIN_PACKAGE_PROPERTIES_PATH);
        this._siteInitializerJsonFile = this._addTaskOutputFile(_SITE_INITIALIZER_JSON_PATH);
    }

    public void addClientExtension(ClientExtension clientExtension) {
        this._clientExtensions.add(clientExtension);
    }

    public void addClientExtensionProperties(Properties clientExtensionProperties) {
        this._clientExtensionProperties = clientExtensionProperties;
    }

    @TaskAction
    public void createClientExtensionConfig() {
        Properties pluginPackageProperties = this._getPluginPackageProperties();
        String classificationGrouping = this._validateAndGetClassificationGrouping(this._clientExtensions);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        String batchType = null;
        for (ClientExtension clientExtension : this._clientExtensions) {
            if (clientExtension.type.equals("batch")) {
                pluginPackageProperties.put("Liferay-Client-Extension-Batch", "batch/");
                batchType = "batch";
            }
            if (clientExtension.type.equals("siteInitializer")) {
                pluginPackageProperties.put("Liferay-Client-Extension-Site-Initializer", "site-initializer/");
                batchType = StringUtil.getDockerSafeName(clientExtension.type);
                this._createSiteInitializerJsonFile(clientExtension);
            }
            if (Objects.equals(clientExtension.classification, "frontend")) {
                this._expandWildcards(clientExtension.typeSettings);
                pluginPackageProperties.put("Liferay-Client-Extension-Frontend", "static/");
            }
            String pid = this._clientExtensionProperties.getProperty(clientExtension.type + ".pid");
            if (Objects.equals(clientExtension.type, "instanceSettings")) {
                pid = clientExtension.typeSettings.remove("pid") + ".scoped";
            }
            if (pid == null) continue;
            jsonMap.putAll(clientExtension.toJSONMap(pid));
        }
        HashMap<String, String> substitutionMap = new HashMap<String, String>();
        for (ClientExtension clientExtension : this._clientExtensions) {
            for (Map.Entry<String, Object> entry : clientExtension.typeSettings.entrySet()) {
                String newKey = String.format("__%s.%s__", this._getIdOrBatchType(clientExtension), entry.getKey());
                substitutionMap.put(newKey, String.valueOf(entry.getValue()));
            }
        }
        if (batchType != null) {
            substitutionMap.put("__BATCH_TYPE__", batchType);
        }
        String string = StringUtil.toAlphaNumericLowerCase(this._project.getName());
        substitutionMap.put("__PROJECT_ID__", string);
        pluginPackageProperties.put("Bundle-SymbolicName", string);
        if (!pluginPackageProperties.containsKey("module-group-id")) {
            pluginPackageProperties.put("module-group-id", "liferay");
        }
        pluginPackageProperties.put("name", this._project.getName());
        this._writeToOutputFile(classificationGrouping, this.getInputDockerfileFile(), this.getDockerFile(), substitutionMap);
        this._writeToOutputFile(classificationGrouping, this.getInputLcpJsonFile(), this.getLcpJsonFile(), substitutionMap);
        this._addRequiredDeploymentContexts(pluginPackageProperties, this.getLcpJsonFile());
        this._storePluginPackageProperties(pluginPackageProperties);
        this._createClientExtensionConfigFile(jsonMap);
    }

    @OutputFile
    public File getClientExtensionConfigFile() {
        return GradleUtil.toFile(this._project, this._clientExtensionConfigFile);
    }

    @OutputFile
    public File getDockerFile() {
        return GradleUtil.toFile(this._project, this._dockerFile);
    }

    @InputFiles
    public File getInputDockerfileFile() {
        return GradleUtil.toFile(this._project, "Dockerfile");
    }

    @InputFiles
    public File getInputLcpJsonFile() {
        return GradleUtil.toFile(this._project, "LCP.json");
    }

    @InputFiles
    public File getInputPluginPackagePropertiesFile() {
        return GradleUtil.toFile(this._project, "liferay-plugin-package.properties");
    }

    @OutputFile
    public File getLcpJsonFile() {
        return GradleUtil.toFile(this._project, this._lcpJsonFile);
    }

    @OutputFile
    public File getPluginPackagePropertiesFile() {
        return GradleUtil.toFile(this._project, this._pluginPackagePropertiesFile);
    }

    @OutputFile
    public File getSiteInitializerJsonFile() {
        return GradleUtil.toFile(this._project, this._siteInitializerJsonFile);
    }

    @Input
    public String getType() {
        return this._type;
    }

    public void setDockerFile(Object dockerFile) {
        this._dockerFile = dockerFile;
    }

    public void setLcpJsonFile(Object lcpJsonFile) {
        this._lcpJsonFile = lcpJsonFile;
    }

    public void setType(String type) {
        this._type = type;
    }

    private void _addRequiredDeploymentContexts(Properties pluginPackageProperties, File lcpJsonFile) {
        try {
            JsonNode jsonNode = this._objectMapper.readTree(lcpJsonFile);
            if (jsonNode.has("dependencies")) {
                ArrayList<String> dependencies = new ArrayList<String>();
                for (JsonNode dependency : jsonNode.get("dependencies")) {
                    dependencies.add(dependency.textValue());
                }
                pluginPackageProperties.put("required-deployment-contexts", com.liferay.petra.string.StringUtil.merge(dependencies, (String)","));
            }
        }
        catch (IOException ioException) {
            throw new GradleException("Unable to parse " + lcpJsonFile.getName(), (Throwable)ioException);
        }
    }

    private Provider<RegularFile> _addTaskOutputFile(String path) {
        ProjectLayout projectLayout = this._project.getLayout();
        DirectoryProperty buildDirectoryProperty = projectLayout.getBuildDirectory();
        Path buildFilePath = Paths.get("liferay-client-extension-build", path);
        Provider buildFileProvider = buildDirectoryProperty.file(buildFilePath.toString());
        TaskOutputsInternal taskOutputs = this.getOutputs();
        taskOutputs.files(new Object[]{buildFileProvider});
        return buildFileProvider;
    }

    private void _createClientExtensionConfigFile(Map<String, Object> jsonMap) {
        File clientExtensionConfigFile = this.getClientExtensionConfigFile();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
            ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
            String json = objectWriter.writeValueAsString(jsonMap);
            Files.write(clientExtensionConfigFile.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    private void _createSiteInitializerJsonFile(ClientExtension clientExtension) {
        Map<String, Object> typeSettings = clientExtension.typeSettings;
        File siteInitializerJsonFile = this.getSiteInitializerJsonFile();
        try {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : typeSettings.entrySet()) {
                String jsonMapKey = _typeSettingsToSiteInitializerJsonKeyMap.get(entry.getKey());
                if (jsonMapKey == null) continue;
                jsonMap.put(jsonMapKey, entry.getValue());
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
            ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
            String json = objectWriter.writeValueAsString(jsonMap);
            Files.write(siteInitializerJsonFile.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    private void _expandWildcards(Map<String, Object> typeSettings) {
        File clientExtensionBuildDir = new File(this._project.getBuildDir(), "liferay-client-extension-build");
        File staticDir = new File(clientExtensionBuildDir, "static");
        if (!staticDir.exists()) {
            return;
        }
        Path staticDirPath = staticDir.toPath();
        for (Map.Entry<String, Object> entry : typeSettings.entrySet()) {
            Object currentValue = entry.getValue();
            if (currentValue instanceof String && this._isWildcardValue((String)currentValue)) {
                entry.setValue(this._getMatchingPaths(staticDirPath, (String)currentValue));
            }
            if (!(currentValue instanceof List)) continue;
            ArrayList<String> values = new ArrayList<String>();
            for (String value : (List)currentValue) {
                if (this._isWildcardValue(value)) {
                    values.addAll(this._getMatchingPaths(staticDirPath, value));
                    continue;
                }
                values.add(value);
            }
            entry.setValue(values);
        }
    }

    private String _getFileContent(File file) {
        if (file.exists()) {
            try {
                return new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException ioException) {
                throw new GradleException(ioException.getMessage(), (Throwable)ioException);
            }
        }
        return null;
    }

    private String _getIdOrBatchType(ClientExtension clientExtension) {
        String id = clientExtension.id;
        if (Objects.equals(clientExtension.classification, "batch")) {
            id = "batch";
        }
        return id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> _getMatchingPaths(Path basePath, String glob) {
        FileSystem fileSystem = basePath.getFileSystem();
        PathMatcher pathMatcher = fileSystem.getPathMatcher("glob:" + glob);
        try (Stream<Path> files = Files.walk(basePath, new FileVisitOption[0]);){
            List<String> matchingPaths = files.map(basePath::relativize).filter(pathMatcher::matches).map(String::valueOf).collect(Collectors.toList());
            if (matchingPaths.isEmpty()) {
                throw new GradleException("No paths matched the glob pattern \"" + glob + "\"");
            }
            Collections.sort(matchingPaths);
            List<String> list = matchingPaths;
            return list;
        }
        catch (IOException ioException) {
            throw new GradleException("Unable to expand wildcard paths", (Throwable)ioException);
        }
    }

    private Properties _getPluginPackageProperties() {
        Properties pluginPackageProperties = new Properties();
        try {
            String pluginPackagePropertiesFileContent = this._getFileContent(this.getInputPluginPackagePropertiesFile());
            if (pluginPackagePropertiesFileContent != null) {
                pluginPackageProperties.load(new StringReader(pluginPackagePropertiesFileContent));
            }
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
        return pluginPackageProperties;
    }

    private boolean _isWildcardValue(String value) {
        return value.contains("*");
    }

    private void _storePluginPackageProperties(Properties pluginPackageProperties) {
        File pluginPackagePropertiesFile = this.getPluginPackagePropertiesFile();
        try {
            File parentFile = pluginPackagePropertiesFile.getParentFile();
            parentFile.mkdirs();
            BufferedWriter bufferedWriter = Files.newBufferedWriter(pluginPackagePropertiesFile.toPath(), StandardOpenOption.CREATE);
            pluginPackageProperties.store(bufferedWriter, null);
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
    }

    private String _validateAndGetClassificationGrouping(Set<ClientExtension> clientExtensions) {
        HashSet classifications = new HashSet();
        clientExtensions.forEach(clientExtension -> classifications.add(clientExtension.classification));
        if (_groupConfiguration.containsAll(classifications)) {
            return "configuration";
        }
        if (_groupBatch.containsAll(classifications)) {
            long siteInitializerTypeCount;
            Stream stream = clientExtensions.stream();
            Map<String, Long> typeCountMap = stream.collect(Collectors.groupingBy(clientExtension -> clientExtension.type, Collectors.counting()));
            long batchTypeCount = typeCountMap.getOrDefault("batch", 0L);
            if (batchTypeCount + (siteInitializerTypeCount = typeCountMap.getOrDefault("siteInitializer", 0L).longValue()) > 1L) {
                throw new GradleException("A client extension project must not contain more than one batch or siteInitializer type client extension");
            }
            Long oAuthApplicationHeadlessServerTypeCount = typeCountMap.getOrDefault("oAuthApplicationHeadlessServer", 0L);
            if (oAuthApplicationHeadlessServerTypeCount != 1L) {
                throw new GradleException("A batch or siteInitializer type client extension requires exactly one oAuthApplicationHeadlessServer type client extension");
            }
            return "batch";
        }
        if (_groupFrontend.containsAll(classifications)) {
            return "frontend";
        }
        if (_groupMicroservice.containsAll(classifications)) {
            return "microservice";
        }
        if (!classifications.isEmpty()) {
            throw new GradleException(StringBundler.concat((Object[])new Object[]{"The combination of client extensions in ", classifications, " cannot be grouped in a single project. The following ", "groupings are allowed: ", _groupBatch, _groupFrontend, _groupMicroservice}));
        }
        return "frontend";
    }

    private void _writeToOutputFile(String classificationGrouping, File inputFile, File outputFile, Map<String, String> substitutionMap) {
        String templatePath = String.format("dependencies/templates/%s/%s.tpl", classificationGrouping, inputFile.getName());
        try {
            InputStream inputStream1 = null;
            inputStream1 = inputFile.exists() ? new FileInputStream(inputFile) : CreateClientExtensionConfigTask.class.getResourceAsStream(templatePath);
            try (InputStream inputStream2 = inputStream1;){
                String fileContent = StringUtil.read(inputStream2);
                for (Map.Entry<String, String> entry : substitutionMap.entrySet()) {
                    fileContent = fileContent.replace(entry.getKey(), entry.getValue());
                }
                Files.write(outputFile.toPath(), fileContent.getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException ioException) {
            throw new GradleException(inputFile.getName() + " not specified");
        }
    }
}

