/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import de.undercouch.gradle.tasks.download.Verify;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class VerifyBundleTask
extends Verify {
    @TaskAction
    public void verify() throws IOException, NoSuchAlgorithmException {
        if (this.getSrc() == null) {
            throw new IllegalArgumentException("Please provide a file to verify");
        }
        if (this.getAlgorithm() == null) {
            throw new IllegalArgumentException("Please provide the algorithm to use to calculate the checksum");
        }
        if (this.getChecksum() == null) {
            throw new IllegalArgumentException("Please provide a checksum to verify against");
        }
        String calculatedChecksum = null;
        MessageDigest messageDigest = MessageDigest.getInstance(this.getAlgorithm());
        try (FileInputStream fileInputStream = new FileInputStream(this.getSrc());){
            byte[] bytes = new byte[1024];
            int read = 0;
            while ((read = fileInputStream.read(bytes)) != -1) {
                messageDigest.update(bytes, 0, read);
            }
            calculatedChecksum = this._toHex(messageDigest.digest());
        }
        if (!calculatedChecksum.equalsIgnoreCase(this.getChecksum())) {
            File srcFile = this.getSrc();
            throw new GradleException("Invalid checksum for " + srcFile.getName() + ". Expected " + this.getChecksum().toLowerCase() + ", but got " + calculatedChecksum.toLowerCase() + ". Please remove " + srcFile.getAbsolutePath() + " and try again.");
        }
    }

    private String _toHex(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : bytes) {
            stringBuilder.append(String.format("%02X", b));
        }
        return stringBuilder.toString();
    }
}

