/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.osgi.framework.Version;

public class FrontendPlugin
implements Plugin<Project> {
    private static final Version _MINIMUM_NODE_VERSION = Version.parseVersion((String)"10.15.3");
    private static final Version _MINIMUM_NPM_VERSION = Version.parseVersion((String)"6.4.1");

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        Map<String, Object> packageJsonMap = this._getPackageJsonMap(project);
        this._configureArchivesBaseName(project, packageJsonMap);
        this._configureVersion(project, packageJsonMap);
        this._configureArtifacts(project);
        this._configureConfigurationDefault(project);
        this._configureNodeAndNpmVersion(project);
        this._configureTaskClean(project);
        this._configureTaskDeploy(project);
    }

    private void _configureArchivesBaseName(Project project, Map<String, Object> packageJsonMap) {
        String name = null;
        if (packageJsonMap != null) {
            name = (String)packageJsonMap.get("name");
        }
        if (Validator.isNull(name)) {
            return;
        }
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        basePluginConvention.setArchivesBaseName(name);
    }

    private void _configureArtifacts(final Project project) {
        ArtifactHandler artifacts = project.getArtifacts();
        artifacts.add("archives", (Object)this._getJarFile(project), (Closure)new Closure<Void>((Object)project){

            public void doCall(ConfigurablePublishArtifact configurablePublishArtifact) {
                Task buildTask = GradleUtil.getTask((Project)project, (String)"build");
                if (GradleUtil.hasTask(project, "packageRunBuild")) {
                    buildTask.finalizedBy(new Object[]{"packageRunBuild"});
                }
            }
        });
    }

    private void _configureConfigurationDefault(Project project) {
        Configuration defaultConfiguration = GradleUtil.getConfiguration((Project)project, (String)"default");
        Configuration archivesConfiguration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        defaultConfiguration.extendsFrom(new Configuration[]{archivesConfiguration});
    }

    private void _configureNodeAndNpmVersion(Project project) {
        NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)project, NodeExtension.class);
        String nodeVersion = nodeExtension.getNodeVersion();
        try {
            Version version = Version.parseVersion((String)nodeVersion);
            if (version.compareTo(_MINIMUM_NODE_VERSION) < 0) {
                nodeVersion = _MINIMUM_NODE_VERSION.toString();
                nodeExtension.setNodeVersion((Object)nodeVersion);
            }
        }
        catch (Exception exception) {
            throw new GradleException("Unable to parse node version", (Throwable)exception);
        }
        String npmVersion = nodeExtension.getNpmVersion();
        try {
            Version version = Version.parseVersion((String)nodeVersion);
            if (version.compareTo(_MINIMUM_NPM_VERSION) < 0) {
                npmVersion = _MINIMUM_NPM_VERSION.toString();
                nodeExtension.setNpmVersion((Object)npmVersion);
            }
        }
        catch (Exception exception) {
            throw new GradleException("Unable to parse npm version", (Throwable)exception);
        }
    }

    private void _configureTaskClean(Project project) {
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        delete.delete(new Object[]{"build", "dist"});
    }

    private void _configureTaskDeploy(Project project) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"deploy");
        copy.dependsOn(new Object[]{"build"});
        copy.from(new Object[]{this._getJarFile(project)});
    }

    private void _configureVersion(Project project, Map<String, Object> packageJsonMap) {
        String version = (String)packageJsonMap.get("version");
        if (Validator.isNotNull((String)version)) {
            project.setVersion((Object)version);
        }
    }

    private File _getJarFile(Project project) {
        return project.file((Object)("dist/" + GradleUtil.getArchivesBaseName(project) + "-" + project.getVersion() + ".jar"));
    }

    private Map<String, Object> _getPackageJsonMap(Project project) {
        File file = project.file((Object)"package.json");
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        return (Map)jsonSlurper.parse(file);
    }
}

