/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.CSSBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.EclipseDefaultsPlugin;
import com.liferay.gradle.plugins.IdeaDefaultsPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.WatchOSGiPlugin;
import com.liferay.gradle.plugins.css.builder.CSSBuilderPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileTree;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.ManifestMergeDetails;
import org.gradle.api.java.archives.ManifestMergeSpec;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.util.VersionNumber;

public class LiferayOSGiExtPlugin
implements Plugin<Project> {
    public static final String ORIGINAL_MODULE_CONFIGURATION_NAME = "originalModule";
    public static final String UNZIP_ORIGINAL_MODULE_TASK_NAME = "unzipOriginalModule";
    private static final String _VERSION_SUFFIX = "ext";

    public void apply(Project project) {
        this._applyPlugins(project);
        ExtensionContainer extensionContainer = project.getExtensions();
        LiferayExtension liferayExtension = (LiferayExtension)extensionContainer.getByType(LiferayExtension.class);
        this._configureExtensionLiferay(liferayExtension);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        final Configuration originalModuleConfiguration = (Configuration)configurationContainer.create(ORIGINAL_MODULE_CONFIGURATION_NAME);
        Configuration compileOnlyConfiguration = configurationContainer.getByName("compileOnly");
        this._configureConfigurationCompileOnly(compileOnlyConfiguration, originalModuleConfiguration);
        this._configureConfigurationOriginalModule(originalModuleConfiguration);
        Convention convention = project.getConvention();
        final BasePluginConvention basePluginConvention = (BasePluginConvention)convention.getPlugin(BasePluginConvention.class);
        TaskProvider unzipOriginalModuleTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)UNZIP_ORIGINAL_MODULE_TASK_NAME, Sync.class);
        TaskProvider deployTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"deploy", Copy.class);
        TaskProvider jarTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"jar", Jar.class);
        this._configureTaskDeployProvider(project, liferayExtension, (TaskProvider<Copy>)deployTaskProvider, (TaskProvider<Jar>)jarTaskProvider);
        this._configureTaskJarProvider((TaskProvider<Jar>)jarTaskProvider, (TaskProvider<Sync>)unzipOriginalModuleTaskProvider);
        this._configureTaskUnzipOriginalModuleProvider(project, originalModuleConfiguration, (TaskProvider<Sync>)unzipOriginalModuleTaskProvider);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                try (JarFile jarFile = new JarFile(originalModuleConfiguration.getSingleFile());){
                    java.util.jar.Manifest manifest = jarFile.getManifest();
                    Attributes attributes = manifest.getMainAttributes();
                    LiferayOSGiExtPlugin.this._configureConventionBasePluginAfterEvaluate(basePluginConvention, attributes);
                    LiferayOSGiExtPlugin.this._configureProjectAfterEvaluate(project, attributes);
                }
                catch (IOException ioException) {
                    throw new UncheckedIOException((Throwable)ioException);
                }
            }
        });
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, CSSBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, IdeaPlugin.class);
        GradleUtil.applyPlugin((Project)project, JavaLibraryPlugin.class);
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        CSSBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        EclipseDefaultsPlugin.INSTANCE.apply((Object)project);
        IdeaDefaultsPlugin.INSTANCE.apply((Object)project);
        WatchOSGiPlugin.INSTANCE.apply((Object)project);
    }

    private void _configureConfigurationCompileOnly(Configuration compileOnlyConfiguration, Configuration originalModuleConfiguration) {
        compileOnlyConfiguration.extendsFrom(new Configuration[]{originalModuleConfiguration});
    }

    private void _configureConfigurationOriginalModule(Configuration originalModuleConfiguration) {
        originalModuleConfiguration.setDescription("Configures the original module to extend.");
        originalModuleConfiguration.setTransitive(false);
        originalModuleConfiguration.setVisible(false);
    }

    private void _configureConventionBasePluginAfterEvaluate(BasePluginConvention basePluginConvention, Attributes attributes) {
        basePluginConvention.setArchivesBaseName(attributes.getValue("Bundle-SymbolicName"));
    }

    private void _configureExtensionLiferay(final LiferayExtension liferayExtension) {
        liferayExtension.setDeployDir((Object)new Callable<File>(){

            @Override
            public File call() {
                return new File(liferayExtension.getAppServerParentDir(), "osgi/marketplace/override");
            }
        });
    }

    private void _configureProjectAfterEvaluate(Project project, Attributes attributes) {
        String version = attributes.getValue("Bundle-Version");
        VersionNumber versionNumber = VersionNumber.parse((String)version);
        version = Validator.isNull((String)versionNumber.getQualifier()) ? version + ".ext" : version + "-ext";
        project.setVersion((Object)version);
    }

    private void _configureTaskDeployProvider(final Project project, final LiferayExtension liferayExtension, TaskProvider<Copy> deployTaskProvider, final TaskProvider<Jar> jarTaskProvider) {
        deployTaskProvider.configure((Action)new Action<Copy>(){

            public void execute(Copy deployCopy) {
                deployCopy.from((Object)jarTaskProvider, (Closure)new Closure<Void>((Object)project){

                    public void doCall(CopySpec copySpec) {
                        copySpec.rename((Closure)new Closure<String>((Object)project){

                            public String doCall(String fileName) {
                                Closure closure = liferayExtension.getDeployedFileNameClosure();
                                return (String)closure.call(jarTaskProvider.get());
                            }
                        });
                    }
                });
            }
        });
    }

    private void _configureTaskJarProvider(TaskProvider<Jar> jarTaskProvider, final TaskProvider<Sync> unzipOriginalModuleTaskProvider) {
        jarTaskProvider.configure((Action)new Action<Jar>(){

            public void execute(final Jar jar) {
                final Sync unzipOriginalModuleSync = (Sync)unzipOriginalModuleTaskProvider.get();
                jar.dependsOn(new Object[]{unzipOriginalModuleSync});
                jar.from(new Object[]{new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return unzipOriginalModuleSync.getDestinationDir();
                    }
                }});
                jar.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
                Manifest manifest = jar.getManifest();
                manifest.attributes(Collections.singletonMap("Bundle-Version", new Object(){

                    public String toString() {
                        return jar.getVersion();
                    }
                }));
                manifest.from((Object)new Callable<File>(){

                    @Override
                    public File call() {
                        return new File(unzipOriginalModuleSync.getDestinationDir(), "META-INF/MANIFEST.MF");
                    }
                }, (Closure)new Closure<Void>((Object)jar){

                    public void doCall(ManifestMergeSpec manifestMergeSpec) {
                        manifestMergeSpec.eachEntry((Action)new Action<ManifestMergeDetails>(){

                            public void execute(ManifestMergeDetails manifestMergeDetails) {
                                if (Objects.equals(manifestMergeDetails.getKey(), "Bundle-Version")) {
                                    manifestMergeDetails.setValue(manifestMergeDetails.getBaseValue());
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private void _configureTaskUnzipOriginalModuleProvider(final Project project, final Configuration originalModuleConfiguration, TaskProvider<Sync> unzipOriginalModuleTaskProvider) {
        unzipOriginalModuleTaskProvider.configure((Action)new Action<Sync>(){

            public void execute(Sync unzipOriginalModuleSync) {
                unzipOriginalModuleSync.from(new Object[]{new Callable<FileTree>(){

                    @Override
                    public FileTree call() {
                        File file = originalModuleConfiguration.getSingleFile();
                        return project.zipTree((Object)file);
                    }
                }});
                unzipOriginalModuleSync.into((Object)new Callable<File>(){

                    @Override
                    public File call() {
                        return new File(project.getBuildDir(), "original-module");
                    }
                });
                unzipOriginalModuleSync.setDescription("Unzips the original module into a temporary directory.");
            }
        });
    }
}

