/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.portal.tools.bundle.support.commands.InitBundleCommand;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class InitBundleTask
extends DefaultTask {
    private Object _configEnvironment = "local";
    private Object _configsDir;
    private Object _destinationDir;
    private Object _file;
    private FileCollection _providedModules;
    private Object _stripComponents = 1;

    @Input
    public String getConfigEnvironment() {
        return GradleUtil.toString((Object)this._configEnvironment);
    }

    @Optional
    public File getConfigsDir() {
        return GradleUtil.toFile(this.getProject(), this._configsDir);
    }

    @OutputDirectory
    public File getDestinationDir() {
        return GradleUtil.toFile(this.getProject(), this._destinationDir);
    }

    @InputFile
    public File getFile() {
        return GradleUtil.toFile(this.getProject(), this._file);
    }

    @Input
    @Optional
    public FileCollection getProvidedModules() {
        return this._providedModules;
    }

    @Input
    @Optional
    public int getStripComponents() {
        return GradleUtil.toInteger((Object)this._stripComponents);
    }

    @TaskAction
    public void initBundle() {
        InitBundleCommand initBundleCommand = new InitBundleCommand();
        File configsDir = this.getConfigsDir();
        if (configsDir != null) {
            initBundleCommand.setConfigsDir(configsDir);
        }
        initBundleCommand.setEnvironment(this.getConfigEnvironment());
        initBundleCommand.setLiferayHomeDir(this.getDestinationDir());
        FileCollection providedModules = this.getProvidedModules();
        if (!providedModules.isEmpty()) {
            initBundleCommand.setProvidedModules(new ArrayList(providedModules.getFiles()));
        }
        initBundleCommand.setStripComponents(this.getStripComponents());
        try {
            File file = this.getFile();
            URI uri = file.toURI();
            initBundleCommand.setUrl(uri.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            Logger logger = this.getLogger();
            logger.error("Unable to construct URL for {}", (Object)this.getFile());
        }
        try {
            initBundleCommand.execute();
        }
        catch (Exception exception) {
            throw new GradleException("Unable to initialize bundle base on " + this.getFile() + ". Please remove this file and try again.", (Throwable)exception);
        }
    }

    public void setConfigEnvironment(Object configEnvironment) {
        this._configEnvironment = configEnvironment;
    }

    public void setConfigsDir(Object configsDir) {
        this._configsDir = configsDir;
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setFile(Object file) {
        this._file = file;
    }

    public void setProvidedModules(FileCollection providedModules) {
        this._providedModules = providedModules;
    }

    public void setStripComponents(Object stripComponents) {
        this._stripComponents = stripComponents;
    }
}

