/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.workspace.docker;

import com.bmuschko.gradle.docker.tasks.image.DockerExistingImage;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.PruneCmd;
import com.github.dockerjava.api.model.PruneType;

import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;

/**
 * @author Seiphon Wang
 */
public class DockerPruneImage extends DockerExistingImage {

	@Override
	public void runRemoteCommand() {
		Logger logger = getLogger();

		if (logger.isQuietEnabled()) {
			Property<String> imageIdProperty = getImageId();

			logger.quiet(
				"Pruning image with ID \'" + imageIdProperty.get() + "\'.");
		}

		DockerClient dockerClient = getDockerClient();

		PruneCmd pruneCmd = dockerClient.pruneCmd(PruneType.IMAGES);

		pruneCmd = pruneCmd.withDangling(true);

		pruneCmd.exec();
	}

}