/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Sets;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import com.liferay.petra.string.StringBundler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;

public class CreateClientExtensionConfigTask
extends DefaultTask {
    private static final String _CLIENT_EXTENSION_CONFIG_FILE_NAME = ".client-extension-config.json";
    private static final String _PLUGIN_PACKAGE_PROPERTIES_PATH = "WEB-INF/liferay-plugin-package.properties";
    private static final Set<String> _groupBatch = Sets.newHashSet((Object[])new String[]{"batch", "configuration"});
    private static final Set<String> _groupConfiguration = Sets.newHashSet((Object[])new String[]{"configuration"});
    private static final Set<String> _groupFrontend = Sets.newHashSet((Object[])new String[]{"configuration", "frontend"});
    private static final Set<String> _groupMicroservice = Sets.newHashSet((Object[])new String[]{"configuration", "microservice"});
    private final Object _clientExtensionConfigFile;
    private Properties _clientExtensionProperties;
    private final Set<ClientExtension> _clientExtensions = new HashSet<ClientExtension>();
    private Object _dockerFile;
    private Object _lcpJsonFile;
    private final Object _pluginPackagePropertiesFile;
    private final Project _project = this.getProject();
    private String _type = "frontend";

    public CreateClientExtensionConfigTask() {
        this._clientExtensionConfigFile = this._addTaskOutputFile(this._project.getName() + _CLIENT_EXTENSION_CONFIG_FILE_NAME);
        this._dockerFile = this._addTaskOutputFile("Dockerfile");
        this._lcpJsonFile = this._addTaskOutputFile("LCP.json");
        this._pluginPackagePropertiesFile = this._addTaskOutputFile(_PLUGIN_PACKAGE_PROPERTIES_PATH);
    }

    public void addClientExtension(ClientExtension clientExtension) {
        this._clientExtensions.add(clientExtension);
    }

    public void addClientExtensionProperties(Properties clientExtensionProperties) {
        this._clientExtensionProperties = clientExtensionProperties;
    }

    @TaskAction
    public void createClientExtensionConfig() {
        Properties pluginPackageProperties = this._getPluginPackageProperties();
        String classificationGrouping = this._validateAndGetClassificationGrouping(this._clientExtensions);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put(":configurator:policy", "force");
        for (ClientExtension clientExtension2 : this._clientExtensions) {
            if (Objects.equals(clientExtension2.classification, "batch")) {
                pluginPackageProperties.put("Liferay-Client-Extension-Batch", "batch/");
            }
            if (Objects.equals(clientExtension2.classification, "frontend")) {
                this._expandWildcards(clientExtension2.typeSettings);
                pluginPackageProperties.put("Liferay-Client-Extension-Frontend", "static/");
            }
            String pid = this._clientExtensionProperties.getProperty(clientExtension2.type + ".pid");
            if (Objects.equals(clientExtension2.type, "instanceSettings")) {
                pid = clientExtension2.typeSettings.remove("pid") + ".scoped";
            }
            if (pid == null) continue;
            jsonMap.putAll(clientExtension2.toJSONMap(pid));
        }
        this._storePluginPackageProperties(pluginPackageProperties);
        Stream stream = this._clientExtensions.stream();
        Map<String, String> substitutionMap = stream.flatMap(clientExtension -> {
            Set<Map.Entry<String, Object>> entrySet = clientExtension.typeSettings.entrySet();
            Stream entrySetStream = entrySet.stream();
            return entrySetStream.map(entry -> new AbstractMap.SimpleEntry<String, String>(StringBundler.concat((String[])new String[]{"__", this._getIdOrBatch((ClientExtension)clientExtension), ".", (String)entry.getKey(), "__"}), String.valueOf(entry.getValue())));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        substitutionMap.put("__CLIENT_EXTENSION_ID__", StringUtil.toAlphaNumericLowerCase(this._project.getName()));
        this._writeToOutputFile(classificationGrouping, this.getInputDockerfileFile(), this.getDockerFile(), substitutionMap);
        this._writeToOutputFile(classificationGrouping, this.getInputLcpJsonFile(), this.getLcpJsonFile(), substitutionMap);
        this._createClientExtensionConfigFile(jsonMap);
    }

    public File getClientExtensionConfigFile() {
        return GradleUtil.toFile(this._project, this._clientExtensionConfigFile);
    }

    public File getDockerFile() {
        return GradleUtil.toFile(this._project, this._dockerFile);
    }

    @InputFiles
    public File getInputDockerfileFile() {
        return GradleUtil.toFile(this._project, "Dockerfile");
    }

    @InputFiles
    public File getInputLcpJsonFile() {
        return GradleUtil.toFile(this._project, "LCP.json");
    }

    @InputFiles
    public File getInputPluginPackagePropertiesFile() {
        return GradleUtil.toFile(this._project, "liferay-plugin-package.properties");
    }

    public File getLcpJsonFile() {
        return GradleUtil.toFile(this._project, this._lcpJsonFile);
    }

    public File getPluginPackagePropertiesFile() {
        return GradleUtil.toFile(this._project, this._pluginPackagePropertiesFile);
    }

    @Input
    public String getType() {
        return this._type;
    }

    public void setDockerFile(Object dockerFile) {
        this._dockerFile = dockerFile;
    }

    public void setLcpJsonFile(Object lcpJsonFile) {
        this._lcpJsonFile = lcpJsonFile;
    }

    public void setType(String type) {
        this._type = type;
    }

    private Provider<RegularFile> _addTaskOutputFile(String path) {
        ProjectLayout projectLayout = this._project.getLayout();
        DirectoryProperty buildDirectoryProperty = projectLayout.getBuildDirectory();
        Path buildFilePath = Paths.get("liferay-client-extension-build", path);
        Provider buildFileProvider = buildDirectoryProperty.file(buildFilePath.toString());
        TaskOutputsInternal taskOutputs = this.getOutputs();
        taskOutputs.files(new Object[]{buildFileProvider});
        return buildFileProvider;
    }

    private void _createClientExtensionConfigFile(Map<String, Object> jsonMap) {
        File clientExtensionConfigFile = this.getClientExtensionConfigFile();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
            ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
            String json = objectWriter.writeValueAsString(jsonMap);
            Files.write(clientExtensionConfigFile.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    private void _expandWildcards(Map<String, Object> typeSettings) {
        File clientExtensionBuildDir = new File(this._project.getBuildDir(), "liferay-client-extension-build");
        File staticDir = new File(clientExtensionBuildDir, "static");
        if (!staticDir.exists()) {
            return;
        }
        Path staticDirPath = staticDir.toPath();
        for (Map.Entry<String, Object> entry : typeSettings.entrySet()) {
            Object currentValue = entry.getValue();
            if (currentValue instanceof String && this._isWildcardValue((String)currentValue)) {
                entry.setValue(this._getMatchingPaths(staticDirPath, (String)currentValue));
            }
            if (!(currentValue instanceof List)) continue;
            ArrayList<String> values = new ArrayList<String>();
            for (String value : (List)currentValue) {
                if (this._isWildcardValue(value)) {
                    values.addAll(this._getMatchingPaths(staticDirPath, value));
                    continue;
                }
                values.add(value);
            }
            entry.setValue(values);
        }
    }

    private String _getFileContent(File file) {
        if (file.exists()) {
            try {
                return new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException ioException) {
                throw new GradleException(ioException.getMessage(), (Throwable)ioException);
            }
        }
        return null;
    }

    private String _getIdOrBatch(ClientExtension clientExtension) {
        String id = clientExtension.id;
        if (Objects.equals(clientExtension.type, "batch")) {
            id = "batch";
        }
        return id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> _getMatchingPaths(Path basePath, String glob) {
        FileSystem fileSystem = basePath.getFileSystem();
        PathMatcher pathMatcher = fileSystem.getPathMatcher("glob:" + glob);
        try (Stream<Path> files = Files.walk(basePath, new FileVisitOption[0]);){
            List<String> matchingPaths = files.map(basePath::relativize).filter(pathMatcher::matches).map(String::valueOf).collect(Collectors.toList());
            if (matchingPaths.isEmpty()) {
                throw new GradleException("No paths matched the glob pattern \"" + glob + "\"");
            }
            Collections.sort(matchingPaths);
            List<String> list = matchingPaths;
            return list;
        }
        catch (IOException ioException) {
            throw new GradleException("Unable to expand wildcard paths", (Throwable)ioException);
        }
    }

    private Properties _getPluginPackageProperties() {
        Properties pluginPackageProperties = new Properties();
        try {
            String pluginPackagePropertiesFileContent = this._getFileContent(this.getInputPluginPackagePropertiesFile());
            if (pluginPackagePropertiesFileContent != null) {
                pluginPackageProperties.load(new StringReader(pluginPackagePropertiesFileContent));
            }
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
        return pluginPackageProperties;
    }

    private boolean _isWildcardValue(String value) {
        return value.contains("*");
    }

    private void _storePluginPackageProperties(Properties pluginPackageProperties) {
        File pluginPackagePropertiesFile = this.getPluginPackagePropertiesFile();
        try {
            File parentFile = pluginPackagePropertiesFile.getParentFile();
            parentFile.mkdirs();
            BufferedWriter bufferedWriter = Files.newBufferedWriter(pluginPackagePropertiesFile.toPath(), StandardOpenOption.CREATE);
            pluginPackageProperties.store(bufferedWriter, null);
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
    }

    private String _validateAndGetClassificationGrouping(Set<ClientExtension> clientExtensions) {
        HashSet classifications = new HashSet();
        clientExtensions.forEach(clientExtension -> classifications.add(clientExtension.classification));
        if (_groupConfiguration.containsAll(classifications)) {
            return "configuration";
        }
        if (_groupBatch.containsAll(classifications)) {
            Stream stream = clientExtensions.stream();
            List batches = stream.filter(clientExtension -> Objects.equals(clientExtension.type, "batch")).collect(Collectors.toList());
            if (batches.size() > 1) {
                throw new GradleException("A client extension project must not contain more than one batch type client extension");
            }
            return "batch";
        }
        if (_groupFrontend.containsAll(classifications)) {
            return "frontend";
        }
        if (_groupMicroservice.containsAll(classifications)) {
            return "microservice";
        }
        if (!classifications.isEmpty()) {
            throw new GradleException(StringBundler.concat((Object[])new Object[]{"The combination of client extensions in ", classifications, " cannot be grouped in a single project. The following ", "groupings are allowed: ", _groupBatch, _groupFrontend, _groupMicroservice}));
        }
        return "frontend";
    }

    private void _writeToOutputFile(String classificationGrouping, File inputFile, File outputFile, Map<String, String> substitutionMap) {
        if (inputFile.exists()) {
            this._project.copy(copy -> {
                copy.from(new Object[]{inputFile});
                copy.into((Object)outputFile.getParentFile());
            });
            return;
        }
        String templatePath = String.format("dependencies/templates/%s/%s.tpl", classificationGrouping, inputFile.getName());
        try (InputStream inputStream = CreateClientExtensionConfigTask.class.getResourceAsStream(templatePath);){
            String fileContent = StringUtil.read(inputStream);
            for (Map.Entry<String, String> entry : substitutionMap.entrySet()) {
                fileContent = fileContent.replace(entry.getKey(), entry.getValue());
            }
            Files.write(outputFile.toPath(), fileContent.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new GradleException(inputFile.getName() + " not specified");
        }
    }
}

