/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtensionConfigurer;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.osgi.framework.Version;

public class NodeBuildConfigurer
implements ClientExtensionConfigurer {
    private static final Version _MINIMUM_NODE_VERSION = Version.parseVersion((String)"10.15.3");
    private static final Version _MINIMUM_NPM_VERSION = Version.parseVersion((String)"6.4.1");

    @Override
    public void apply(Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider) {
        if (!this._hasFrontendScript(project)) {
            return;
        }
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)project, NodeExtension.class);
        this._configureExtensionNode(nodeExtension);
        assembleClientExtensionTaskProvider.configure(assembleClientExtensionTask -> {
            TaskContainer tasks = project.getTasks();
            Task task = (Task)tasks.findByName("packageRunBuild");
            if (task != null) {
                assembleClientExtensionTask.dependsOn(new Object[]{task});
            }
        });
    }

    private void _configureExtensionNode(NodeExtension nodeExtension) {
        String nodeVersion = nodeExtension.getNodeVersion();
        try {
            Version version = Version.parseVersion((String)nodeVersion);
            if (version.compareTo(_MINIMUM_NODE_VERSION) < 0) {
                nodeVersion = _MINIMUM_NODE_VERSION.toString();
                nodeExtension.setNodeVersion((Object)nodeVersion);
            }
        }
        catch (Exception exception) {
            throw new GradleException("Unable to parse Node version", (Throwable)exception);
        }
        String npmVersion = nodeExtension.getNpmVersion();
        try {
            Version version = Version.parseVersion((String)nodeVersion);
            if (version.compareTo(_MINIMUM_NPM_VERSION) < 0) {
                npmVersion = _MINIMUM_NPM_VERSION.toString();
                nodeExtension.setNpmVersion((Object)npmVersion);
            }
        }
        catch (Exception exception) {
            throw new GradleException("Unable to parse NPM version", (Throwable)exception);
        }
    }

    private boolean _hasFrontendScript(Project project) {
        File packageJsonFile = project.file((Object)"package.json");
        if (!packageJsonFile.exists()) {
            return false;
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
        Map liferayThemeMap = (Map)packageJsonMap.get("liferayTheme");
        Map scriptsMap = (Map)packageJsonMap.get("scripts");
        return liferayThemeMap == null && scriptsMap != null;
    }
}

