/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurator;

import com.bmuschko.gradle.docker.DockerRemoteApiPlugin;
import com.bmuschko.gradle.docker.tasks.image.DockerBuildImage;
import com.bmuschko.gradle.docker.tasks.image.DockerRemoveImage;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurator.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.client.extension.NodeBuildConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ThemeCSSTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import com.liferay.gradle.plugins.workspace.task.CreateClientExtensionConfigTask;
import com.liferay.gradle.util.Validator;
import com.liferay.petra.string.StringBundler;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;

public class ClientExtensionProjectConfigurator
extends BaseProjectConfigurator {
    public static final String ASSEMBLE_CLIENT_EXTENSION_TASK_NAME = "assembleClientExtension";
    public static final String BUILD_CLIENT_EXTENSION_ZIP_TASK_NAME = "buildClientExtensionZip";
    public static final String CLIENT_EXTENSION_BUILD_DIR = "liferay-client-extension-build";
    public static final String CREATE_CLIENT_EXTENSION_CONFIG_TASK_NAME = "createClientExtensionConfig";
    protected static final String NAME = "client.extension";
    private static final String _CLIENT_EXTENSION_YAML = "client-extension.yaml";
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private static final Pattern _overrideClientExtensionYamlPattern = Pattern.compile("client-extension\\.([a-z]+)\\.yaml");
    private Properties _clientExtensionProperties;
    private final boolean _defaultRepositoryEnabled;
    private final NodeBuildConfigurer _nodeBuildConfigurer = new NodeBuildConfigurer();
    private final ThemeCSSTypeConfigurer _themeCSSTypeConfigurer = new ThemeCSSTypeConfigurer();
    private final ObjectMapper _yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public ClientExtensionProjectConfigurator(Settings settings) {
        super(settings);
        this._defaultRepositoryEnabled = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.client.extension.default.repository.enabled", (boolean)true);
    }

    public void apply(Project project) {
        TaskProvider createClientExtensionConfigTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)CREATE_CLIENT_EXTENSION_CONFIG_TASK_NAME, CreateClientExtensionConfigTask.class);
        TaskProvider assembleClientExtensionTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)ASSEMBLE_CLIENT_EXTENSION_TASK_NAME, Copy.class);
        TaskProvider buildClientExtensionZipTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)BUILD_CLIENT_EXTENSION_ZIP_TASK_NAME, Zip.class);
        this._baseConfigureClientExtensionProject(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider, (TaskProvider<Zip>)buildClientExtensionZipTaskProvider, (TaskProvider<CreateClientExtensionConfigTask>)createClientExtensionConfigTaskProvider);
        Map<String, JsonNode> profileJsonNodes = this._configureClientExtensionJsonNodes(project);
        for (Map.Entry<String, JsonNode> profileJsonNodeEntry : profileJsonNodes.entrySet()) {
            String profileName = profileJsonNodeEntry.getKey();
            JsonNode jsonNode = profileJsonNodeEntry.getValue();
            Iterator iterator = jsonNode.fields();
            iterator.forEachRemaining(entry -> {
                String id = (String)entry.getKey();
                if (Objects.equals(id, "runtime")) {
                    return;
                }
                if (Objects.equals(id, "assemble")) {
                    JsonNode assembleJsonNode = (JsonNode)entry.getValue();
                    this._configureAssembleClientExtensionTask(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider, assembleJsonNode, profileName);
                    return;
                }
                JsonNode clientExtensionJsonNode = (JsonNode)entry.getValue();
                try {
                    ClientExtension clientExtension = (ClientExtension)this._yamlObjectMapper.treeToValue((TreeNode)clientExtensionJsonNode, ClientExtension.class);
                    clientExtension.id = id;
                    if (Validator.isNull((String)clientExtension.type)) {
                        clientExtension.type = id;
                    }
                    clientExtension.classification = this._getClassification(clientExtension.id, clientExtension.type);
                    clientExtension.projectName = project.getName();
                    this._validateClientExtension(clientExtension);
                    createClientExtensionConfigTaskProvider.configure(createClientExtensionConfigTask -> createClientExtensionConfigTask.addClientExtensionProfile(profileName, clientExtension));
                    if (clientExtension.type.equals("configuration")) {
                        assembleClientExtensionTaskProvider.configure(copy -> copy.from((Object)"src", copySpec -> copySpec.include(new String[]{"**/*"})));
                    } else if (clientExtension.type.equals("themeCSS")) {
                        this._themeCSSTypeConfigurer.apply(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider);
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    throw new GradleException("Failed to parse client-extension " + id, (Throwable)jsonProcessingException);
                }
            });
        }
        this._nodeBuildConfigurer.apply(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider);
        this._addDockerTasks(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider);
    }

    @Override
    public String getName() {
        return "client-extension";
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(final File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                String dirName = String.valueOf(dirPath.getFileName());
                if (ClientExtensionProjectConfigurator.this.isExcludedDirName(dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path clientExtensionPath = dirPath.resolve(ClientExtensionProjectConfigurator._CLIENT_EXTENSION_YAML);
                if (Files.exists(clientExtensionPath, new LinkOption[0]) && !Objects.equals(dirPath, rootDir.toPath())) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private void _addDockerTasks(final Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider) {
        DockerBuildImage dockerBuildImage = (DockerBuildImage)GradleUtil.addTask((Project)project, (String)"buildDockerImage", DockerBuildImage.class);
        dockerBuildImage.setDescription("Builds a child Docker image from the Liferay base image with all configs deployed.");
        dockerBuildImage.setGroup("docker");
        dockerBuildImage.dependsOn(new Object[]{assembleClientExtensionTaskProvider});
        DirectoryProperty inputDirectoryProperty = dockerBuildImage.getInputDir();
        assembleClientExtensionTaskProvider.configure(copy -> inputDirectoryProperty.set(copy.getDestinationDir()));
        DockerRemoveImage dockerRemoveImage = (DockerRemoveImage)GradleUtil.addTask((Project)project, (String)"cleanDockerImage", DockerRemoveImage.class);
        dockerRemoveImage.setDescription("Removes the Docker image.");
        dockerRemoveImage.setGroup("docker");
        Property forceProperty = dockerRemoveImage.getForce();
        forceProperty.set((Object)true);
        String dockerImageId = this._getDockerImageId(project);
        SetProperty setProperty = dockerBuildImage.getImages();
        setProperty.add((Object)dockerImageId);
        Property property = dockerRemoveImage.getImageId();
        property.set((Object)dockerImageId);
        dockerRemoveImage.onError((Action)new Action<Throwable>(){

            public void execute(Throwable throwable) {
                Logger logger = project.getLogger();
                if (logger.isWarnEnabled()) {
                    logger.warn("No image with ID '" + ClientExtensionProjectConfigurator.this._getDockerImageId(project) + "' found.");
                }
            }
        });
        Task cleanTask = GradleUtil.getTask((Project)project, (String)"clean");
        cleanTask.dependsOn(new Object[]{dockerRemoveImage});
    }

    private TaskProvider<Zip> _baseConfigureClientExtensionProject(Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider, TaskProvider<Zip> buildClientExtensionZipTaskProvider, TaskProvider<CreateClientExtensionConfigTask> createClientExtensionConfigTaskProvider) {
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        GradleUtil.applyPlugin((Project)project, DockerRemoteApiPlugin.class);
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        this.configureLiferay(project, workspaceExtension);
        this._configureLiferayExtension(project, liferayExtension);
        this._configureConfigurationDefault(project);
        this._configureTaskClean(project);
        this._configureTaskDeploy(project);
        this._configureClientExtensionTasks(project, assembleClientExtensionTaskProvider, buildClientExtensionZipTaskProvider, createClientExtensionConfigTaskProvider);
        this.addTaskDockerDeploy(project, buildClientExtensionZipTaskProvider, new File(workspaceExtension.getDockerDir(), "client-extensions"));
        this._configureArtifacts(project, buildClientExtensionZipTaskProvider);
        this._configureRootTaskDistBundle(project, buildClientExtensionZipTaskProvider);
        return buildClientExtensionZipTaskProvider;
    }

    private void _configureArtifacts(Project project, TaskProvider<Zip> buildClientExtensionZipTaskProvider) {
        ArtifactHandler artifacts = project.getArtifacts();
        artifacts.add("archives", buildClientExtensionZipTaskProvider);
    }

    private void _configureAssembleClientExtensionTask(Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider, JsonNode assembleJsonNode, String profileName) {
        if (assembleJsonNode.isEmpty()) {
            return;
        }
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)(ASSEMBLE_CLIENT_EXTENSION_TASK_NAME + StringUtil.capitalize(profileName)), Copy.class);
        copy.into((Object)new File(project.getBuildDir(), CLIENT_EXTENSION_BUILD_DIR));
        copy.onlyIf(task -> Objects.equals(profileName, GradleUtil.getProperty((ExtensionAware)project, (String)"profileName", (String)"default")));
        assembleJsonNode.forEach(copyJsonNode -> {
            JsonNode fromJsonNode = copyJsonNode.get("from");
            JsonNode fromTaskJsonNode = copyJsonNode.get("fromTask");
            JsonNode includeJsonNode = copyJsonNode.get("include");
            JsonNode intoJsonNode = copyJsonNode.get("into");
            Object fromPath = null;
            if (fromTaskJsonNode != null) {
                TaskContainer taskContainer = project.getTasks();
                fromPath = taskContainer.findByName(fromTaskJsonNode.asText());
            }
            if (fromPath == null && fromJsonNode != null) {
                fromPath = fromJsonNode.asText();
            }
            copy.from(fromPath != null ? fromPath : ".", copySpec -> {
                if (includeJsonNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)includeJsonNode;
                    arrayNode.forEach(include -> copySpec.include(new String[]{include.asText()}));
                } else if (includeJsonNode != null) {
                    copySpec.include(new String[]{includeJsonNode.asText()});
                } else {
                    copySpec.include(new String[]{"**/*"});
                }
                copySpec.exclude(new String[]{"**/liferay-client-extension-build"});
                if (intoJsonNode != null) {
                    copySpec.into((Object)intoJsonNode.asText());
                }
                copySpec.setIncludeEmptyDirs(false);
            });
        });
        assembleClientExtensionTaskProvider.configure(assembleClientExtensionTask -> assembleClientExtensionTask.finalizedBy(new Object[]{copy}));
    }

    private Map<String, JsonNode> _configureClientExtensionJsonNodes(Project project) {
        HashMap<String, JsonNode> profileJsonNodes = new HashMap<String, JsonNode>();
        File clientExtensionYamlFile = project.file((Object)_CLIENT_EXTENSION_YAML);
        JsonNode rootJsonNode = this._getJsonNode(clientExtensionYamlFile);
        profileJsonNodes.put("default", rootJsonNode);
        File parentFile = clientExtensionYamlFile.getParentFile();
        for (File file : Objects.requireNonNull(parentFile.listFiles())) {
            Matcher matcher = _overrideClientExtensionYamlPattern.matcher(file.getName());
            if (!matcher.find()) continue;
            String profileName = matcher.group(1);
            this._configureDeployProfileTask(project, clientExtensionYamlFile, file, profileName);
            JsonNode jsonNode = rootJsonNode.deepCopy();
            this._overrideJsonNodeValues(jsonNode, this._getJsonNode(file));
            profileJsonNodes.put(profileName, jsonNode);
        }
        return profileJsonNodes;
    }

    private void _configureClientExtensionTasks(final Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider, TaskProvider<Zip> buildClientExtensionZipTaskProvider, TaskProvider<CreateClientExtensionConfigTask> createClientExtensionConfigTaskProvider) {
        createClientExtensionConfigTaskProvider.configure(createClientExtensionConfigTask -> {
            createClientExtensionConfigTask.dependsOn(new Object[]{ASSEMBLE_CLIENT_EXTENSION_TASK_NAME});
            TaskInputsInternal taskInputs = createClientExtensionConfigTask.getInputs();
            taskInputs.file((Object)project.file((Object)_CLIENT_EXTENSION_YAML));
            createClientExtensionConfigTask.addClientExtensionProperties(this._getClientExtensionProperties());
        });
        File clientExtensionBuildDir = new File(project.getBuildDir(), CLIENT_EXTENSION_BUILD_DIR);
        assembleClientExtensionTaskProvider.configure(copy -> copy.into((Object)clientExtensionBuildDir));
        buildClientExtensionZipTaskProvider.configure(zip -> {
            zip.dependsOn(new Object[]{CREATE_CLIENT_EXTENSION_CONFIG_TASK_NAME});
            DirectoryProperty destinationDirectoryProperty = zip.getDestinationDirectory();
            destinationDirectoryProperty.set(new File(project.getProjectDir(), "dist"));
            Property archiveBaseNameProperty = zip.getArchiveBaseName();
            archiveBaseNameProperty.set(project.provider((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return project.getName();
                }
            }));
            zip.from(new Object[]{clientExtensionBuildDir});
            zip.include(new String[]{"**/*"});
        });
    }

    private void _configureConfigurationDefault(Project project) {
        Configuration defaultConfiguration = GradleUtil.getConfiguration((Project)project, (String)"default");
        Configuration archivesConfiguration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        defaultConfiguration.extendsFrom(new Configuration[]{archivesConfiguration});
    }

    private void _configureDeployProfileTask(Project project, File clientExtensionYamlFile, File overrideClientExtensionYamlFile, String profileName) {
        String taskName = "deploy" + StringUtil.capitalize(profileName);
        Task deployProfileTask = GradleUtil.addTask((Project)project, (String)taskName, Task.class);
        deployProfileTask.doFirst(task -> GradleUtil.setProperty((ExtensionAware)project, (String)"profileName", (Object)profileName));
        deployProfileTask.finalizedBy(new Object[]{"deploy"});
        deployProfileTask.setDescription("Assembles the project and deploys it to Liferay with the \"" + profileName + "\" client extension profile.");
        deployProfileTask.setGroup("build");
        TaskInputs inputs = deployProfileTask.getInputs();
        inputs.files(new Object[]{clientExtensionYamlFile, overrideClientExtensionYamlFile});
    }

    private void _configureLiferayExtension(final Project project, final LiferayExtension liferayExtension) {
        liferayExtension.setDeployDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = new File(liferayExtension.getAppServerParentDir(), "osgi/client-extensions");
                dir.mkdirs();
                return GradleUtil.getProperty((Project)project, (String)"auto.deploy.dir", (File)dir);
            }
        });
    }

    private void _configureRootTaskDistBundle(Project project, final TaskProvider<Zip> buildClientExtensionZipTaskProvider) {
        final Task assembleTask = GradleUtil.getTask((Project)project, (String)"assemble");
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.dependsOn(new Object[]{assembleTask});
        copy.into((Object)"osgi/client-extensions", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                Project project = assembleTask.getProject();
                ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{buildClientExtensionZipTaskProvider});
                configurableFileCollection.builtBy(new Object[]{assembleTask});
                copySpec.from(new Object[]{buildClientExtensionZipTaskProvider});
            }
        });
    }

    private void _configureTaskClean(Project project) {
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        delete.delete(new Object[]{"build", "dist"});
    }

    private void _configureTaskDeploy(Project project) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"deploy");
        copy.dependsOn(new Object[]{"assemble"});
        copy.from(new Object[]{this._getZipFile(project)});
    }

    private String _getClassification(String id, String type) {
        Properties clientExtensionProperties = this._getClientExtensionProperties();
        String classification = clientExtensionProperties.getProperty(type + ".classification");
        if (classification != null) {
            return classification;
        }
        throw new GradleException(StringBundler.concat((String[])new String[]{"Client extension ", id, " with type ", type, " is of unkown classification"}));
    }

    private Properties _getClientExtensionProperties() {
        if (this._clientExtensionProperties == null) {
            try {
                Properties properties = new Properties();
                properties.load(ClientExtension.class.getResourceAsStream("client-extension.properties"));
                this._clientExtensionProperties = properties;
                return this._clientExtensionProperties;
            }
            catch (Exception exception) {
                throw new GradleException("Unable to parse client-extension.properties file", (Throwable)exception);
            }
        }
        return this._clientExtensionProperties;
    }

    private String _getDockerImageId(Project project) {
        String propertyName = "imageId";
        if (project.hasProperty(propertyName)) {
            Object property = project.property(propertyName);
            return property.toString();
        }
        return project.getName() + ":latest";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonNode _getJsonNode(File file) {
        if (!file.exists()) {
            return this._yamlObjectMapper.createObjectNode();
        }
        try (FileReader fileReader = new FileReader(file);){
            JsonNode jsonNode = this._yamlObjectMapper.readTree(file);
            return jsonNode;
        }
        catch (IOException ioException) {
            throw new GradleException(StringBundler.concat((String[])new String[]{"Unable to parse ", file.getName(), "."}), (Throwable)ioException);
        }
    }

    private File _getZipFile(Project project) {
        return project.file((Object)("dist/" + GradleUtil.getArchivesBaseName(project) + ".zip"));
    }

    private void _overrideJsonNodeValues(JsonNode baseJsonNode, JsonNode overrideJsonNode) {
        if (overrideJsonNode.isEmpty()) {
            return;
        }
        Iterator iterator = overrideJsonNode.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            JsonNode fieldNameBaseJsonNode = baseJsonNode.path(fieldName);
            JsonNode fieldNameOverrideJsonNode = overrideJsonNode.path(fieldName);
            if (fieldNameOverrideJsonNode.isMissingNode()) continue;
            if (fieldNameBaseJsonNode.isObject()) {
                this._overrideJsonNodeValues(fieldNameBaseJsonNode, fieldNameOverrideJsonNode);
                continue;
            }
            ObjectNode baseObjectNode = (ObjectNode)baseJsonNode;
            if (fieldNameBaseJsonNode.isMissingNode()) {
                baseObjectNode.set(fieldName, fieldNameOverrideJsonNode);
                continue;
            }
            baseObjectNode.replace(fieldName, fieldNameOverrideJsonNode);
        }
    }

    private void _validateClientExtension(ClientExtension clientExtension) {
        if (Objects.equals(clientExtension.type, "batch")) {
            if (!clientExtension.typeSettings.containsKey("oAuthApplicationHeadlessServer")) {
                throw new GradleException(StringBundler.concat((String[])new String[]{"Client extension ", clientExtension.id, " with type ", clientExtension.type, " must define the property ", "\"oAuthApplicationHeadlessServer\""}));
            }
        } else if (Objects.equals(clientExtension.type, "instanceSettings") && !clientExtension.typeSettings.containsKey("pid")) {
            throw new GradleException(StringBundler.concat((String[])new String[]{"Client extension ", clientExtension.id, " with type ", clientExtension.type, " must define the property \"pid\""}));
        }
    }
}

