/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Sets;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import com.liferay.petra.string.StringBundler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class CreateClientExtensionConfigTask
extends DefaultTask {
    private static final String _CLIENT_EXTENSION_CONFIG_FILE_NAME = ".client-extension-config.json";
    private static final String _PLUGIN_PACKAGE_PROPERTIES_PATH = "WEB-INF/liferay-plugin-package.properties";
    private static final Set<String> _groupBatch = Sets.newHashSet((Object[])new String[]{"batch", "configuration"});
    private static final Set<String> _groupConfiguration = Sets.newHashSet((Object[])new String[]{"configuration"});
    private static final Set<String> _groupFrontend = Sets.newHashSet((Object[])new String[]{"configuration", "frontend"});
    private static final Set<String> _groupMicroservice = Sets.newHashSet((Object[])new String[]{"configuration", "microservice"});
    private final Object _clientExtensionConfigFile;
    private Properties _clientExtensionProperties;
    private final Set<ClientExtension> _clientExtensions = new LinkedHashSet<ClientExtension>();
    private Object _dockerFile;
    private Object _lcpJsonFile;
    private final Object _pluginPackagePropertiesFile;
    private String _type = "frontend";

    public CreateClientExtensionConfigTask() {
        Project project = this.getProject();
        this._clientExtensionConfigFile = this._addTaskOutputFile(project.getName() + _CLIENT_EXTENSION_CONFIG_FILE_NAME);
        this._dockerFile = this._addTaskOutputFile("Dockerfile");
        this._lcpJsonFile = this._addTaskOutputFile("LCP.json");
        this._pluginPackagePropertiesFile = this._addTaskOutputFile(_PLUGIN_PACKAGE_PROPERTIES_PATH);
    }

    public void addClientExtension(ClientExtension clientExtension) {
        this._clientExtensions.add(clientExtension);
    }

    public void addClientExtensionProperties(Properties clientExtensionProperties) {
        this._clientExtensionProperties = clientExtensionProperties;
    }

    @TaskAction
    public void createClientExtensionConfig() {
        Properties pluginPackageProperties = this._getPluginPackageProperties();
        String classificationGrouping = this._validateAndGetClassificationGrouping(this._clientExtensions);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put(":configurator:policy", "force");
        this._clientExtensions.forEach(clientExtension -> {
            String pid = this._clientExtensionProperties.getProperty(clientExtension.type + ".pid");
            if (Objects.equals(clientExtension.type, "instanceSettings")) {
                pid = clientExtension.typeSettings.remove("pid") + ".scoped";
            }
            if (pid != null) {
                jsonMap.putAll(clientExtension.toJSONMap(pid));
            }
            if (Objects.equals(clientExtension.classification, "batch")) {
                pluginPackageProperties.put("Liferay-Client-Extension-Batch", "batch/");
            }
            if (Objects.equals(clientExtension.classification, "frontend")) {
                pluginPackageProperties.put("Liferay-Client-Extension-Frontend", "static/");
            }
        });
        this._storePluginPackageProperties(pluginPackageProperties);
        Project project = this.getProject();
        Stream stream = this._clientExtensions.stream();
        Map<String, String> substitutionMap = stream.flatMap(clientExtension -> {
            Set<Map.Entry<String, Object>> entrySet = clientExtension.typeSettings.entrySet();
            Stream entrySetStream = entrySet.stream();
            return entrySetStream.map(entry -> new AbstractMap.SimpleEntry<String, String>(StringBundler.concat((String[])new String[]{"__", this._getIdOrBatch((ClientExtension)clientExtension), ".", (String)entry.getKey(), "__"}), String.valueOf(entry.getValue())));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        substitutionMap.put("__CLIENT_EXTENSION_ID__", StringUtil.toAlphaNumericLowerCase(project.getName()));
        this._createDockerConfig(project, classificationGrouping, substitutionMap);
        this._createLCPJSONConfig(project, classificationGrouping, substitutionMap);
        this._createClientExtensionConfigFile(jsonMap);
    }

    public File getClientExtensionConfigFile() {
        return GradleUtil.toFile(this.getProject(), this._clientExtensionConfigFile);
    }

    public Set<ClientExtension> getClientExtensions() {
        return this._clientExtensions;
    }

    public File getDockerFile() {
        return GradleUtil.toFile(this.getProject(), this._dockerFile);
    }

    public File getLcpJsonFile() {
        return GradleUtil.toFile(this.getProject(), this._lcpJsonFile);
    }

    public File getPluginPackagePropertiesFile() {
        return GradleUtil.toFile(this.getProject(), this._pluginPackagePropertiesFile);
    }

    @Input
    public String getType() {
        return this._type;
    }

    public void setDockerFile(Object dockerFile) {
        this._dockerFile = dockerFile;
    }

    public void setLcpJsonFile(Object lcpJsonFile) {
        this._lcpJsonFile = lcpJsonFile;
    }

    public void setType(String type) {
        this._type = type;
    }

    private Provider<RegularFile> _addTaskOutputFile(String path) {
        Project project = this.getProject();
        ProjectLayout projectLayout = project.getLayout();
        DirectoryProperty buildDirectoryProperty = projectLayout.getBuildDirectory();
        Path buildFilePath = Paths.get("liferay-client-extension-build", path);
        Provider buildFileProvider = buildDirectoryProperty.file(buildFilePath.toString());
        TaskOutputsInternal taskOutputs = this.getOutputs();
        taskOutputs.files(new Object[]{buildFileProvider});
        return buildFileProvider;
    }

    private void _createClientExtensionConfigFile(Map<String, Object> jsonMap) {
        File clientExtensionConfigFile = this.getClientExtensionConfigFile();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
            ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
            String json = objectWriter.writeValueAsString(jsonMap);
            Files.write(clientExtensionConfigFile.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    private void _createDockerConfig(Project project, String classificationGrouping, Map<String, String> substitutionMap) {
        File outputDockerFile = this.getDockerFile();
        try {
            String dockerFileContent = this._getFileContentFromProject(project, "Dockerfile");
            if (dockerFileContent == null) {
                dockerFileContent = this._loadTemplate("templates/" + classificationGrouping + "/Dockerfile.tpl", substitutionMap);
            }
            if (dockerFileContent == null) {
                throw new GradleException("Dockerfile not specified");
            }
            Files.write(outputDockerFile.toPath(), dockerFileContent.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
    }

    private void _createLCPJSONConfig(Project project, String classificationGrouping, Map<String, String> substitutionMap) {
        File outputLcpJsonFile = this.getLcpJsonFile();
        try {
            String lcpJsonContent = this._getFileContentFromProject(project, "LCP.json");
            if (lcpJsonContent == null) {
                lcpJsonContent = this._loadTemplate("templates/" + classificationGrouping + "/LCP.json.tpl", substitutionMap);
            }
            if (lcpJsonContent == null) {
                throw new GradleException("LCP.json not specified");
            }
            Files.write(outputLcpJsonFile.toPath(), lcpJsonContent.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
    }

    private String _getFileContentFromProject(Project project, String path) {
        File file = project.file((Object)path);
        if (file.exists()) {
            try {
                return new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException ioException) {
                throw new GradleException(ioException.getMessage(), (Throwable)ioException);
            }
        }
        return null;
    }

    private String _getIdOrBatch(ClientExtension clientExtension) {
        String id = clientExtension.id;
        if (Objects.equals(clientExtension.type, "batch")) {
            id = "batch";
        }
        return id;
    }

    private Properties _getPluginPackageProperties() {
        Properties pluginPackageProperties = new Properties();
        try {
            String pluginPackagePropertiesFileContent = this._getFileContentFromProject(this.getProject(), "liferay-plugin-package.properties");
            if (pluginPackagePropertiesFileContent != null) {
                pluginPackageProperties.load(new StringReader(pluginPackagePropertiesFileContent));
            }
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
        return pluginPackageProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _loadTemplate(String name, Map<String, String> substitutionMap) {
        try (InputStream inputStream = CreateClientExtensionConfigTask.class.getResourceAsStream("dependencies/" + name);){
            Set<Map.Entry<String, String>> entrySet = substitutionMap.entrySet();
            Stream substitutions = entrySet.stream();
            String string = (String)substitutions.map(entry -> s -> s.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue())).reduce(Function::andThen).orElse(Function.identity()).apply(StringUtil.read(inputStream));
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void _storePluginPackageProperties(Properties pluginPackageProperties) {
        File pluginPackagePropertiesFile = this.getPluginPackagePropertiesFile();
        try {
            File parentFile = pluginPackagePropertiesFile.getParentFile();
            parentFile.mkdirs();
            BufferedWriter bufferedWriter = Files.newBufferedWriter(pluginPackagePropertiesFile.toPath(), StandardOpenOption.CREATE);
            pluginPackageProperties.store(bufferedWriter, null);
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
    }

    private String _validateAndGetClassificationGrouping(Set<ClientExtension> clientExtensions) {
        HashSet classifications = new HashSet();
        clientExtensions.forEach(clientExtension -> classifications.add(clientExtension.classification));
        if (_groupConfiguration.containsAll(classifications)) {
            return "configuration";
        }
        if (_groupBatch.containsAll(classifications)) {
            Stream stream = clientExtensions.stream();
            List batches = stream.filter(clientExtension -> Objects.equals(clientExtension.type, "batch")).collect(Collectors.toList());
            if (batches.size() > 1) {
                throw new GradleException("A client extension project must not contain more than one batch type client extension");
            }
            return "batch";
        }
        if (_groupFrontend.containsAll(classifications)) {
            return "frontend";
        }
        if (_groupMicroservice.containsAll(classifications)) {
            return "microservice";
        }
        if (!classifications.isEmpty()) {
            throw new GradleException(StringBundler.concat((Object[])new Object[]{"The combination of client extensions in ", classifications, " cannot be grouped in a single project. The following ", "groupings are allowed: ", _groupBatch, _groupFrontend, _groupMicroservice}));
        }
        return "frontend";
    }
}

