/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClientExtension {
    public String classification = "static";
    public String description = "";
    public String id;
    public String name = "";
    public String projectName;
    public Map<String, Object> properties = Collections.emptyMap();
    public String sourceCodeURL = "";
    public String type;
    @JsonIgnore
    public Map<String, Object> typeSettings = new HashMap<String, Object>();
    @JsonProperty(value="dxp.lxc.liferay.com.virtualInstanceId")
    public String virtualInstanceId = "default";

    @JsonAnySetter
    public void ignored(String name, Object value) {
        this.typeSettings.put(name, value);
    }

    public Map<String, Object> toJSONMap(String pid) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("baseURL", this.typeSettings.getOrDefault("baseURL", "${portalURL}/o/" + this.projectName));
        configMap.put("description", this.description);
        configMap.put("dxp.lxc.liferay.com.virtualInstanceId", this.virtualInstanceId);
        configMap.put("name", this.name);
        configMap.put("projectName", this.projectName);
        configMap.put("properties", this._encode(this.properties));
        configMap.put("sourceCodeURL", this.sourceCodeURL);
        configMap.put("type", this.type);
        configMap.put("webContextPath", this.typeSettings.getOrDefault("webContextPath", "/" + this.projectName));
        Set<Map.Entry<String, Object>> set = this.typeSettings.entrySet();
        set.forEach(entry -> {
            if (!pid.contains("CETConfiguration")) {
                configMap.put((String)entry.getKey(), entry.getValue());
            }
        });
        if (this.type.equals("oAuthApplicationHeadlessServer") || this.type.equals("oAuthApplicationUserAgent")) {
            configMap.put("homePageURL", this.typeSettings.getOrDefault("homePageURL", "$[conf:.serviceScheme]://$[conf:.serviceAddress]"));
        }
        configMap.put("typeSettings", this._encode(this.typeSettings));
        jsonMap.put(pid + "~" + this.id, configMap);
        return jsonMap;
    }

    private List<String> _encode(Map<String, Object> map) {
        Set<Map.Entry<String, Object>> set = map.entrySet();
        Stream stream = set.stream();
        return stream.map(entry -> {
            Object value = entry.getValue();
            if (value instanceof List) {
                value = StringUtil.merge((Collection)((List)value), (String)",");
            }
            return StringBundler.concat((Object[])new Object[]{entry.getKey(), "=", value});
        }).collect(Collectors.toList());
    }
}

