/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.GUtil;
import groovy.json.JsonOutput;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public class SetUpYarnTask
extends DefaultTask {
    private final List<Object> _excludes = Arrays.asList(".gradle", "build", "build_gradle", "dist", "gradle", "node_modules", "node_modules_cache", "src");

    public SetUpYarnTask excludes(Iterable<Object> excludes) {
        GUtil.addToCollection(this._excludes, excludes);
        return this;
    }

    public SetUpYarnTask excludes(Object ... excludes) {
        return this.excludes(Arrays.asList(excludes));
    }

    @Input
    public List<String> getExcludes() {
        return GradleUtil.toStringList(this._excludes);
    }

    @OutputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getPackageJsonFile() {
        Project project = this.getProject();
        return project.file((Object)"package.json");
    }

    @Input
    public List<String> getYarnWorkspaces() throws IOException {
        Project project = this.getProject();
        File rootDir = project.getRootDir();
        Path rootPath = rootDir.toPath();
        return FileUtil.getRelativePaths(rootPath, "package.json", this.getExcludes(), true);
    }

    public void setExcludes(Iterable<Object> excludes) {
        this._excludes.clear();
        this.excludes(excludes);
    }

    public void setExcludes(Object ... excludes) {
        this.setExcludes(Arrays.asList(excludes));
    }

    @TaskAction
    public void setUpYarn() throws IOException {
        this._defineWorkspaces();
    }

    private void _defineWorkspaces() throws IOException {
        JsonSlurper jsonSlurper;
        Map packageJsonMap;
        HashMap<String, List<String>> workspaces;
        File file = this.getPackageJsonFile();
        Path path = file.toPath();
        if (!file.exists()) {
            Files.write(path, "{}".getBytes(), new OpenOption[0]);
        }
        if ((workspaces = (HashMap<String, List<String>>)(packageJsonMap = (Map)(jsonSlurper = new JsonSlurper()).parse(file)).get("workspaces")) == null) {
            packageJsonMap.put("private", true);
            workspaces = new HashMap<String, List<String>>();
            packageJsonMap.put("workspaces", workspaces);
        }
        List<String> packages = this.getYarnWorkspaces();
        workspaces.put("packages", packages);
        String packageJSON = JsonOutput.prettyPrint((String)JsonOutput.toJson((Map)packageJsonMap));
        Files.write(path, packageJSON.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

