/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.soy.task;

import com.liferay.portal.tools.soy.builder.commands.ReplaceSoyTranslationCommand;

import groovy.lang.Closure;

import java.io.File;
import java.io.IOException;

import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;

/**
 * @author     Andrea Di Giorgi
 * @deprecated As of Judson (7.1.x), with no direct replacement
 */
@CacheableTask
@Deprecated
public class ReplaceSoyTranslationTask extends SourceTask {

	@Input
	@Optional
	public Closure<String> getReplacementClosure() {
		return _replacementClosure;
	}

	@TaskAction
	public void replaceSoyTranslation() throws IOException {
		for (File file : getSource()) {
			_replaceSoyTranslationCommand.execute(file.toPath());
		}
	}

	public void setReplacementClosure(Closure<String> replacementClosure) {
		_replacementClosure = replacementClosure;
	}

	private Closure<String> _replacementClosure;

	private final ReplaceSoyTranslationCommand _replaceSoyTranslationCommand =
		new ReplaceSoyTranslationCommand() {

			@Override
			protected String getReplacement(
				String variableName, String languageKey,
				String argumentsObject) {

				Closure<String> closure = getReplacementClosure();

				if (closure != null) {
					return closure.call(
						variableName, languageKey, argumentsObject);
				}

				return super.getReplacement(
					variableName, languageKey, argumentsObject);
			}

		};

}