/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtensionConfigurer;
import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.task.CreateClientExtensionConfigTask;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskProvider;
import org.osgi.framework.Version;

public class NodeBuildConfigurer
implements ClientExtensionConfigurer {
    private static final String _CLIENT_EXTENSION_YAML = "client-extension.yaml";
    private static final Version _MINIMUM_NODE_VERSION = Version.parseVersion((String)"10.15.3");
    private static final Version _MINIMUM_NPM_VERSION = Version.parseVersion((String)"6.4.1");

    @Override
    public void apply(Project project, Optional<ClientExtension> clientExtensionOptional, TaskProvider<Copy> assembleClientExtensionTaskProvider) {
        if (!this._hasFrontendBuildScript(project)) {
            return;
        }
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)project, NodeExtension.class);
        this._configureExtensionNode(nodeExtension);
        TaskProvider createClientExtensionConfigTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"createClientExtensionConfig", CreateClientExtensionConfigTask.class);
        createClientExtensionConfigTaskProvider.configure(createClientExtensionConfigTask -> {
            createClientExtensionConfigTask.dependsOn(new Object[]{"packageRunBuild"});
            createClientExtensionConfigTask.doLast(task -> this._processAssembleIntructions(project));
        });
    }

    private void _configureExtensionNode(NodeExtension nodeExtension) {
        String nodeVersion = nodeExtension.getNodeVersion();
        try {
            Version version = Version.parseVersion((String)nodeVersion);
            if (version.compareTo(_MINIMUM_NODE_VERSION) < 0) {
                nodeVersion = _MINIMUM_NODE_VERSION.toString();
                nodeExtension.setNodeVersion((Object)nodeVersion);
            }
        }
        catch (Exception exception) {
            throw new GradleException("Unable to parse Node version", (Throwable)exception);
        }
        String npmVersion = nodeExtension.getNpmVersion();
        try {
            Version version = Version.parseVersion((String)nodeVersion);
            if (version.compareTo(_MINIMUM_NPM_VERSION) < 0) {
                npmVersion = _MINIMUM_NPM_VERSION.toString();
                nodeExtension.setNpmVersion((Object)npmVersion);
            }
        }
        catch (Exception exception) {
            throw new GradleException("Unable to parse NPM version", (Throwable)exception);
        }
    }

    private void _expandClientExtensionConfigURLs(File clientExtensionConfigFile, File buildDir) {
        String originalConfigFileContent = FileUtil.read(clientExtensionConfigFile);
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map clientExtensionConfigMap = (Map)jsonSlurper.parse(originalConfigFileContent.getBytes());
        AtomicReference<String> configData = new AtomicReference<String>(originalConfigFileContent);
        Set keySet = clientExtensionConfigMap.keySet();
        keySet.forEach(key -> {
            Map configMap = (Map)clientExtensionConfigMap.get(key);
            List typeSettings = (List)configMap.get("typeSettings");
            Stream settingsStream = typeSettings.stream();
            List globs = settingsStream.flatMap(setting -> {
                Stream<String> stream = null;
                String[] split = setting.split("=");
                if (split.length == 2) {
                    String value = split[1];
                    String[] encodedValues = value.split("\n");
                    stream = encodedValues.length == 1 ? Stream.of(value) : Arrays.stream(encodedValues);
                }
                return stream;
            }).filter(Objects::nonNull).filter(value -> value.contains("*")).map(Pattern::compile).collect(Collectors.toList());
            Path buildPath = buildDir.toPath();
            try (Stream<Path> files = Files.walk(buildPath, new FileVisitOption[0]);){
                files.map(buildPath::relativize).forEach(buildFile -> {
                    Stream stream = globs.stream();
                    stream.filter(glob -> {
                        Matcher matcher = glob.matcher(buildFile.toString());
                        return matcher.matches();
                    }).forEach(glob -> {
                        String currentValue = (String)configData.get();
                        configData.set(currentValue.replace(glob.pattern(), buildFile.toString()));
                    });
                });
            }
            catch (IOException ioException) {
                throw new GradleException("Unable to expand wildcard in config file", (Throwable)ioException);
            }
        });
        String updatedConfigFileContent = configData.get();
        if (!originalConfigFileContent.equals(updatedConfigFileContent)) {
            try {
                Files.write(clientExtensionConfigFile.toPath(), updatedConfigFileContent.getBytes(), new OpenOption[0]);
            }
            catch (IOException ioException) {
                throw new GradleException("Unable to expand wildcard in config file", (Throwable)ioException);
            }
        }
    }

    private boolean _hasFrontendBuildScript(Project project) {
        File packageJsonFile = project.file((Object)"package.json");
        if (!packageJsonFile.exists()) {
            return false;
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
        Map liferayThemeMap = (Map)packageJsonMap.get("liferayTheme");
        Map scriptsMap = (Map)packageJsonMap.get("scripts");
        return liferayThemeMap == null && scriptsMap != null && scriptsMap.get("build") != null;
    }

    private boolean _isExcludedDirName(String dirName) {
        if (dirName == null) {
            return false;
        }
        return dirName.equals(".gradle") || dirName.equals("dist") || dirName.equals("gradle") || dirName.equals("node_modules") || dirName.equals("node_modules_cache");
    }

    private void _processAssembleIntructions(Project project) {
        File clientExtensionFile = project.file((Object)_CLIENT_EXTENSION_YAML);
        try (FileReader fileReader = new FileReader(clientExtensionFile);){
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            JsonNode rootJsonNode = objectMapper.readTree(clientExtensionFile);
            JsonNode assembleJsonNode = rootJsonNode.get("assemble");
            if (assembleJsonNode != null) {
                assembleJsonNode.forEach(jsonNode -> {
                    JsonNode fromJsonNode = jsonNode.get("from");
                    if (fromJsonNode != null) {
                        this._updateConfigFiles(project.getBuildDir(), project.file((Object)fromJsonNode.asText()));
                    }
                });
            }
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage());
        }
    }

    private void _updateConfigFiles(File buildDir, final File fromDir) {
        try {
            Files.walkFileTree(buildDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                    File[] configFiles;
                    String dirName = String.valueOf(dirPath.getFileName());
                    if (NodeBuildConfigurer.this._isExcludedDirName(dirName)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    File dir = dirPath.toFile();
                    for (File configFile : configFiles = dir.listFiles((d, name) -> name.endsWith(".client-extension-config.json"))) {
                        NodeBuildConfigurer.this._expandClientExtensionConfigURLs(configFile, fromDir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ioException) {
            throw new GradleException("Error updating config files", (Throwable)ioException);
        }
    }
}

