/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.gulp;

import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.util.GradleUtil;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;

/**
 * @author     David Truong
 * @author     Andrea Di Giorgi
 * @deprecated As of Judson (7.1.x), with no direct replacement
 */
@Deprecated
public class GulpPlugin implements Plugin<Project> {

	public static final String EXTENSION_NAME = "gulp";

	@Override
	public void apply(Project project) {
		GradleUtil.applyPlugin(project, NodePlugin.class);

		Task npmInstallTask = GradleUtil.getTask(
			project, NodePlugin.NPM_INSTALL_TASK_NAME);

		_addTaskRuleGulp(project, npmInstallTask);
	}

	private ExecuteGulpTask _addTaskExecuteGulp(
		Project project, String taskName, Task npmInstallTask) {

		ExecuteGulpTask executeGulpTask = GradleUtil.addTask(
			project, taskName, ExecuteGulpTask.class);

		executeGulpTask.dependsOn(npmInstallTask);

		char gulpCommandFirstChar = taskName.charAt(4);

		String gulpCommand =
			Character.toLowerCase(gulpCommandFirstChar) + taskName.substring(5);

		executeGulpTask.setGulpCommand(gulpCommand);

		return executeGulpTask;
	}

	private void _addTaskRuleGulp(
		final Project project, final Task npmInstallTask) {

		TaskContainer taskContainer = project.getTasks();

		taskContainer.addRule(
			new Rule() {

				@Override
				public void apply(String taskName) {
					if (taskName.startsWith("gulp")) {
						_addTaskExecuteGulp(project, taskName, npmInstallTask);
					}
				}

				@Override
				public String getDescription() {
					return "Pattern: gulp<Task>: Executes a named Gulp task.";
				}

			});
	}

}