/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurator.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtensionTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.CustomElementTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.GlobalCSSTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.GlobalJSTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ThemeCSSTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ThemeFaviconTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ThemeJSTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.task.CreateClientExtensionConfigTask;
import com.liferay.petra.string.StringBundler;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;

public class ClientExtensionProjectConfigurator
extends BaseProjectConfigurator {
    public static final String BUILD_CLIENT_EXTENSION_TASK_NAME = "buildClientExtension";
    public static final String CREATE_CLIENT_EXTENSION_CONFIG_TASK_NAME = "createClientExtensionConfig";
    protected static final String NAME = "client.extension";
    private static final String _CLIENT_EXTENSION_YAML = "client-extension.yaml";
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private final Map<String, ClientExtensionTypeConfigurer> _clientExtensionConfigurers = new HashMap<String, ClientExtensionTypeConfigurer>();
    private final boolean _defaultRepositoryEnabled;

    public ClientExtensionProjectConfigurator(Settings settings) {
        super(settings);
        this._clientExtensionConfigurers.put("customElement", new CustomElementTypeConfigurer());
        this._clientExtensionConfigurers.put("globalCSS", new GlobalCSSTypeConfigurer());
        this._clientExtensionConfigurers.put("globalJS", new GlobalJSTypeConfigurer());
        this._clientExtensionConfigurers.put("themeCSS", new ThemeCSSTypeConfigurer());
        this._clientExtensionConfigurers.put("themeFavicon", new ThemeFaviconTypeConfigurer());
        this._clientExtensionConfigurers.put("themeJS", new ThemeJSTypeConfigurer());
        this._defaultRepositoryEnabled = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.client.extension.default.repository.enabled", (boolean)true);
    }

    public void apply(Project project) {
        TaskProvider createClientExtensionConfigTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)CREATE_CLIENT_EXTENSION_CONFIG_TASK_NAME, CreateClientExtensionConfigTask.class);
        TaskProvider zipTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)BUILD_CLIENT_EXTENSION_TASK_NAME, Zip.class);
        this._baseConfigureClientExtensionProject(project, (TaskProvider<CreateClientExtensionConfigTask>)createClientExtensionConfigTaskProvider, (TaskProvider<Zip>)zipTaskProvider);
        File clientExtensionFile = project.file((Object)_CLIENT_EXTENSION_YAML);
        try (FileReader fileReader = new FileReader(clientExtensionFile);){
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            JsonNode rootJsonNode = objectMapper.readTree(clientExtensionFile);
            Iterator nodeIterator = rootJsonNode.fields();
            nodeIterator.forEachRemaining(node -> {
                String id = (String)node.getKey();
                JsonNode clientExtensionNode = (JsonNode)node.getValue();
                try {
                    ClientExtension clientExtension = (ClientExtension)objectMapper.treeToValue((TreeNode)clientExtensionNode, ClientExtension.class);
                    clientExtension.id = id;
                    clientExtension.projectName = project.getName();
                    createClientExtensionConfigTaskProvider.configure(createClientExtensionConfigTask -> createClientExtensionConfigTask.addClientExtension(clientExtension));
                    ClientExtensionTypeConfigurer clientExtensionTypeConfigurer = this._clientExtensionConfigurers.get(clientExtension.type);
                    if (clientExtensionTypeConfigurer != null) {
                        clientExtensionTypeConfigurer.apply(project, clientExtension, (TaskProvider<Zip>)zipTaskProvider);
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    throw new GradleException("Failed to parse client-extension " + id, (Throwable)jsonProcessingException);
                }
            });
        }
        catch (IOException ioException) {
            throw new GradleException(StringBundler.concat((String[])new String[]{"Failed parsing ", _CLIENT_EXTENSION_YAML, " file."}), (Throwable)ioException);
        }
    }

    @Override
    public String getName() {
        return "client-extension";
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(final File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                String dirName = String.valueOf(dirPath.getFileName());
                if (ClientExtensionProjectConfigurator.this.isExcludedDirName(dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path clientExtensionPath = dirPath.resolve(ClientExtensionProjectConfigurator._CLIENT_EXTENSION_YAML);
                if (Files.exists(clientExtensionPath, new LinkOption[0]) && !Objects.equals(dirPath, rootDir.toPath())) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private TaskProvider<Zip> _baseConfigureClientExtensionProject(Project project, TaskProvider<CreateClientExtensionConfigTask> createClientExtensionConfigTaskProvider, TaskProvider<Zip> zipTaskProvider) {
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        this.configureLiferay(project, workspaceExtension);
        this._configureLiferayExtension(project, liferayExtension);
        this._configureConfigurationDefault(project);
        this._configureTaskClean(project);
        this._configureTaskDeploy(project);
        this._configureTaskBuildClientExtension(project, createClientExtensionConfigTaskProvider, zipTaskProvider);
        this.addTaskDockerDeploy(project, zipTaskProvider, new File(workspaceExtension.getDockerDir(), "client-extensions"));
        this._configureArtifacts(project, zipTaskProvider);
        this._configureRootTaskDistBundle(project, zipTaskProvider);
        return zipTaskProvider;
    }

    private void _configureArtifacts(Project project, TaskProvider<Zip> zipTaskProvider) {
        ArtifactHandler artifacts = project.getArtifacts();
        artifacts.add("archives", zipTaskProvider);
    }

    private void _configureConfigurationDefault(Project project) {
        Configuration defaultConfiguration = GradleUtil.getConfiguration((Project)project, (String)"default");
        Configuration archivesConfiguration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        defaultConfiguration.extendsFrom(new Configuration[]{archivesConfiguration});
    }

    private void _configureLiferayExtension(final Project project, final LiferayExtension liferayExtension) {
        liferayExtension.setDeployDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = new File(liferayExtension.getAppServerParentDir(), "osgi/client-extensions");
                dir.mkdirs();
                return GradleUtil.getProperty((Project)project, (String)"auto.deploy.dir", (File)dir);
            }
        });
    }

    private void _configureRootTaskDistBundle(Project project, final TaskProvider<Zip> zipTaskProvider) {
        final Task assembleTask = GradleUtil.getTask((Project)project, (String)"assemble");
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.dependsOn(new Object[]{assembleTask});
        copy.into((Object)"osgi/client-extensions", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                Project project = assembleTask.getProject();
                ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{zipTaskProvider});
                configurableFileCollection.builtBy(new Object[]{assembleTask});
                copySpec.from(new Object[]{zipTaskProvider});
            }
        });
    }

    private void _configureTaskBuildClientExtension(final Project project, TaskProvider<CreateClientExtensionConfigTask> createClientExtensionConfigTaskProvider, TaskProvider<Zip> zipTaskProvider) {
        createClientExtensionConfigTaskProvider.configure(createClientExtensionConfigTask -> {
            TaskInputsInternal taskInputs = createClientExtensionConfigTask.getInputs();
            taskInputs.file((Object)project.file((Object)_CLIENT_EXTENSION_YAML));
        });
        zipTaskProvider.configure(zip -> {
            DirectoryProperty destinationDirectoryProperty = zip.getDestinationDirectory();
            destinationDirectoryProperty.set(new File(project.getProjectDir(), "dist"));
            Property archiveBaseNameProperty = zip.getArchiveBaseName();
            archiveBaseNameProperty.set(project.provider((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return project.getName();
                }
            }));
            zip.from(new Object[]{createClientExtensionConfigTaskProvider});
        });
    }

    private void _configureTaskClean(Project project) {
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        delete.delete(new Object[]{"build", "dist"});
    }

    private void _configureTaskDeploy(Project project) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"deploy");
        copy.dependsOn(new Object[]{"assemble"});
        copy.from(new Object[]{this._getZipFile(project)});
    }

    private File _getZipFile(Project project) {
        return project.file((Object)("dist/" + GradleUtil.getArchivesBaseName(project) + ".zip"));
    }
}

