/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClientExtension {
    public String description = "";
    public String id;
    public String name = "";
    public String projectName;
    public String sourceCodeURL = "";
    public String type;
    private final Map<String, Object> _typeSettings = new HashMap<String, Object>();

    @JsonAnySetter
    public void ignored(String name, Object value) {
        this._typeSettings.put(name, value);
    }

    public Map<String, Object> toJSONMap() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("baseURL", "${portalURL}/o/" + this.projectName);
        config.put("description", this.description);
        config.put("dxp.lxc.liferay.com.virtualInstanceId", "default");
        config.put("name", this.name);
        config.put("sourceCodeURL", this.sourceCodeURL);
        config.put("type", this.type);
        Properties clientExtensionProperties = this._getClientExtensionProperties();
        String pid = clientExtensionProperties.getProperty(this.type);
        if (pid != null && (this.type.equals("notificationType") || this.type.equals("oAuthApplicationHeadlessServer") || this.type.equals("oAuthApplicationUserAgent") || this.type.equals("workflowAction")) && this._typeSettings.get("homePageURL") == null) {
            this._typeSettings.put("homePageURL", "https://$[conf:ext.lxc.liferay.com.mainDomain]");
        }
        Set<Map.Entry<String, Object>> set = this._typeSettings.entrySet();
        Stream stream = set.stream();
        List typeSettings = stream.peek(entry -> {
            if (!pid.contains("CETConfiguration")) {
                config.put((String)entry.getKey(), entry.getValue());
            }
        }).map(entry -> {
            Object value = entry.getValue();
            if (value instanceof List) {
                value = StringUtil.merge((Collection)((List)value), (String)"\n");
            }
            return StringBundler.concat((Object[])new Object[]{entry.getKey(), "=", value});
        }).collect(Collectors.toList());
        config.put("typeSettings", typeSettings);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put(pid + "~" + this.id, config);
        return jsonMap;
    }

    private Properties _getClientExtensionProperties() throws Exception {
        Properties properties = new Properties();
        properties.load(ClientExtension.class.getResourceAsStream("client-extension.properties"));
        return properties;
    }
}

