/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.petra.string.StringUtil;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Gregory Amerson
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ClientExtension {

	@JsonAnySetter
	public void ignored(String name, Object value) {
		_typeSettings.put(name, value);
	}

	public Map<String, Object> toJSONMap() throws Exception {
		Map<String, Object> config = new HashMap<>();

		config.put("baseURL", "${portalURL}/o/" + projectName);
		config.put("description", description);
		config.put("dxp.lxc.liferay.com.virtualInstanceId", "default");
		config.put("name", name);
		config.put("sourceCodeURL", sourceCodeURL);
		config.put("type", type);

		Properties clientExtensionProperties = _getClientExtensionProperties();

		String pid = clientExtensionProperties.getProperty(type);

		if ((pid != null) &&
			(type.equals("notificationType") ||
			 type.equals("oAuthApplicationHeadlessServer") ||
			 type.equals("oAuthApplicationUserAgent") ||
			 type.equals("workflowAction")) &&
			(_typeSettings.get("homePageURL") == null)) {

			_typeSettings.put(
				"homePageURL",
				"https://$[conf:ext.lxc.liferay.com.mainDomain]");
		}

		Set<Map.Entry<String, Object>> set = _typeSettings.entrySet();

		Stream<Map.Entry<String, Object>> stream = set.stream();

		List<String> typeSettings = stream.peek(
			entry -> {
				if (!pid.contains("CETConfiguration")) {
					config.put(entry.getKey(), entry.getValue());
				}
			}
		).map(
			entry -> {
				Object value = entry.getValue();

				if (value instanceof List) {
					value = StringUtil.merge(
						(List<?>)value, StringPool.NEW_LINE);
				}

				return StringBundler.concat(entry.getKey(), "=", value);
			}
		).collect(
			Collectors.toList()
		);

		config.put("typeSettings", typeSettings);

		Map<String, Object> jsonMap = new HashMap<>();

		jsonMap.put(pid + "~" + id, config);

		return jsonMap;
	}

	public String description = "";
	public String id;
	public String name = "";
	public String projectName;
	public String sourceCodeURL = "";
	public String type;

	private Properties _getClientExtensionProperties() throws Exception {
		Properties properties = new Properties();

		properties.load(
			ClientExtension.class.getResourceAsStream(
				"client-extension.properties"));

		return properties;
	}

	private final Map<String, Object> _typeSettings = new HashMap<>();

}