/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.configurator;

import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.target.platform.TargetPlatformIDEPlugin;
import com.liferay.gradle.plugins.target.platform.extensions.TargetPlatformExtension;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.VersionUtil;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;

public class TargetPlatformRootProjectConfigurator
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new TargetPlatformRootProjectConfigurator();
    private static final String _ARTIFACT_ID_RELEASE_DXP_BOM = "release.dxp.bom";
    private static final String _ARTIFACT_ID_RELEASE_DXP_BOM_COMPILE_ONLY = "release.dxp.bom.compile.only";
    private static final String _ARTIFACT_ID_RELEASE_DXP_BOM_THIRD_PARTY = "release.dxp.bom.third.party";
    private static final String _ARTIFACT_ID_RELEASE_DXP_DISTRO = "release.dxp.distro";
    private static final String _ARTIFACT_ID_RELEASE_PORTAL_BOM = "release.portal.bom";
    private static final String _ARTIFACT_ID_RELEASE_PORTAL_BOM_COMPILE_ONLY = "release.portal.bom.compile.only";
    private static final String _ARTIFACT_ID_RELEASE_PORTAL_BOM_THIRD_PARTY = "release.portal.bom.third.party";
    private static final String _ARTIFACT_ID_RELEASE_PORTAL_DISTRO = "release.portal.distro";
    private static final String _GROUP_ID_LIFERAY_PORTAL = "com.liferay.portal";

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        String targetPlatformVersion = workspaceExtension.getTargetPlatformVersion();
        if (Validator.isNull((String)targetPlatformVersion)) {
            return;
        }
        GradleUtil.applyPlugin((Project)project, TargetPlatformIDEPlugin.class);
        this._configureTargetPlatform(project);
        String normalizedTargetPlatformVersion = VersionUtil.normalizeTargetPlatformVersion(targetPlatformVersion);
        this._addDependenciesTargetPlatformBoms(project, normalizedTargetPlatformVersion);
        this._addDependenciesTargetPlatformDistro(project, normalizedTargetPlatformVersion);
    }

    private TargetPlatformRootProjectConfigurator() {
    }

    private void _addDependenciesTargetPlatformBoms(Project project, String targetPlatformVersion) {
        String bomArtifactId = null;
        String bomCompileOnlyArtifactId = null;
        String bomThirdPartyArtifactId = null;
        if (VersionUtil.isDXPVersion(targetPlatformVersion)) {
            bomArtifactId = _ARTIFACT_ID_RELEASE_DXP_BOM;
            bomCompileOnlyArtifactId = _ARTIFACT_ID_RELEASE_DXP_BOM_COMPILE_ONLY;
            bomThirdPartyArtifactId = _ARTIFACT_ID_RELEASE_DXP_BOM_THIRD_PARTY;
        } else {
            bomArtifactId = _ARTIFACT_ID_RELEASE_PORTAL_BOM;
            bomCompileOnlyArtifactId = _ARTIFACT_ID_RELEASE_PORTAL_BOM_COMPILE_ONLY;
            bomThirdPartyArtifactId = _ARTIFACT_ID_RELEASE_PORTAL_BOM_THIRD_PARTY;
        }
        GradleUtil.addDependency((Project)project, (String)"targetPlatformBoms", (String)_GROUP_ID_LIFERAY_PORTAL, (String)bomThirdPartyArtifactId, (String)targetPlatformVersion);
        GradleUtil.addDependency((Project)project, (String)"targetPlatformBoms", (String)_GROUP_ID_LIFERAY_PORTAL, (String)bomArtifactId, (String)targetPlatformVersion);
        GradleUtil.addDependency((Project)project, (String)"targetPlatformBoms", (String)_GROUP_ID_LIFERAY_PORTAL, (String)bomCompileOnlyArtifactId, (String)targetPlatformVersion);
    }

    private void _addDependenciesTargetPlatformDistro(final Project project, final String targetPlatformVersion) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"targetPlatformDistro");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                String artifactId = TargetPlatformRootProjectConfigurator._ARTIFACT_ID_RELEASE_PORTAL_DISTRO;
                if (VersionUtil.isDXPVersion(targetPlatformVersion)) {
                    artifactId = TargetPlatformRootProjectConfigurator._ARTIFACT_ID_RELEASE_DXP_DISTRO;
                }
                GradleUtil.addDependency((Project)project, (String)"targetPlatformDistro", (String)TargetPlatformRootProjectConfigurator._GROUP_ID_LIFERAY_PORTAL, (String)artifactId, (String)targetPlatformVersion);
            }
        });
    }

    private void _configureTargetPlatform(Project project) {
        TargetPlatformExtension targetPlatformExtension = (TargetPlatformExtension)GradleUtil.getExtension((ExtensionAware)project, TargetPlatformExtension.class);
        targetPlatformExtension.resolveOnlyIf((Spec)new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                String projectName = project.getName();
                return !projectName.endsWith("-test");
            }
        });
        targetPlatformExtension.resolveOnlyIf((Spec)new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                PluginContainer pluginContainer = project.getPlugins();
                return pluginContainer.hasPlugin(LiferayOSGiPlugin.class);
            }
        });
    }
}

