/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public class CreateClientExtensionConfigTask
extends DefaultTask {
    private static final String _CLIENT_EXTENSION_CONFIG_FILE_NAME = ".client-extension-config.json";
    private final Object _clientExtensionConfigFile;
    private final Set<ClientExtension> _clientExtensions = new LinkedHashSet<ClientExtension>();
    private Object _dockerFile;
    private Object _lcpJsonFile;
    private String _type = "static";

    public CreateClientExtensionConfigTask() {
        Project project = this.getProject();
        this._clientExtensionConfigFile = this._addTaskOutputFile(project.getName() + _CLIENT_EXTENSION_CONFIG_FILE_NAME);
        this._dockerFile = this._addTaskOutputFile("Dockerfile");
        this._lcpJsonFile = this._addTaskOutputFile("LCP.json");
    }

    public void addClientExtension(ClientExtension clientExtension) {
        this._clientExtensions.add(clientExtension);
    }

    @TaskAction
    public void createClientExtensionConfig() {
        Project project = this.getProject();
        File outputDockerFile = this.getDockerFile();
        try {
            String dockerFileContent = this._getFileContentFromProject(project, "Dockerfile");
            if (dockerFileContent == null) {
                dockerFileContent = this._loadTemplate("templates/" + this._type + "/Dockerfile.tpl", Collections.emptyMap());
            }
            if (dockerFileContent == null) {
                throw new GradleException("Dockerfile not specified");
            }
            Files.write(outputDockerFile.toPath(), dockerFileContent.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
        File outputLcpJsonFile = this.getLcpJsonFile();
        try {
            String lcpJsonContent = this._getFileContentFromProject(project, "LCP.json");
            if (lcpJsonContent == null) {
                lcpJsonContent = this._loadTemplate("templates/" + this._type + "/LCP.json.tpl", Collections.singletonMap("__CLIENT_EXTENSION_ID__", StringUtil.toAlphaNumericLowerCase(project.getName())));
            }
            if (lcpJsonContent == null) {
                throw new GradleException("LCP.json not specified");
            }
            Files.write(outputLcpJsonFile.toPath(), lcpJsonContent.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
        File clientExtensionConfigFile = this.getClientExtensionConfigFile();
        HashMap jsonMap = new HashMap();
        this._clientExtensions.forEach(clientExtension -> {
            try {
                jsonMap.putAll(clientExtension.toJSONMap());
            }
            catch (Exception exception) {
                throw new GradleException(exception.getMessage(), (Throwable)exception);
            }
        });
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
            ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
            String json = objectWriter.writeValueAsString(jsonMap);
            Files.write(clientExtensionConfigFile.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    public File getClientExtensionConfigFile() {
        return GradleUtil.toFile(this.getProject(), this._clientExtensionConfigFile);
    }

    public Set<ClientExtension> getClientExtensions() {
        return this._clientExtensions;
    }

    public File getDockerFile() {
        return GradleUtil.toFile(this.getProject(), this._dockerFile);
    }

    public File getLcpJsonFile() {
        return GradleUtil.toFile(this.getProject(), this._lcpJsonFile);
    }

    @Input
    public String getType() {
        return this._type;
    }

    public void setDockerFile(Object dockerFile) {
        this._dockerFile = dockerFile;
    }

    public void setLcpJsonFile(Object lcpJsonFile) {
        this._lcpJsonFile = lcpJsonFile;
    }

    public void setType(String type) {
        this._type = type;
    }

    private Provider<RegularFile> _addTaskOutputFile(String path) {
        Project project = this.getProject();
        ProjectLayout projectLayout = project.getLayout();
        DirectoryProperty buildDirectoryProperty = projectLayout.getBuildDirectory();
        Provider buildFileProvider = buildDirectoryProperty.file(path);
        TaskOutputsInternal taskOutputs = this.getOutputs();
        taskOutputs.files(new Object[]{buildFileProvider});
        return buildFileProvider;
    }

    private String _getFileContentFromProject(Project project, String path) {
        File file = project.file((Object)path);
        if (file.exists()) {
            try {
                return new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException ioException) {
                throw new GradleException(ioException.getMessage(), (Throwable)ioException);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _loadTemplate(String name, Map<String, String> substitutionMap) {
        try (InputStream inputStream = CreateClientExtensionConfigTask.class.getResourceAsStream("dependencies/" + name);){
            Set<Map.Entry<String, String>> entrySet = substitutionMap.entrySet();
            Stream substitutions = entrySet.stream();
            String string = (String)substitutions.map(entry -> s -> s.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue())).reduce(Function::andThen).orElse(Function.identity()).apply(StringUtil.read(inputStream));
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

