/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClientExtension {
    public String description = "";
    public String id;
    public String name = "";
    public String projectName;
    public String sourceCodeURL = "";
    public String type;
    private static final String _BASE_URL_PREFIX = "${portalURL}/o/";
    private static final String _CET_CONFIGURATION_PID = "com.liferay.client.extension.type.configuration.CETConfiguration";
    private static final String _FUNCTION_OBJECT_ACTION_PID = "com.liferay.object.internal.configuration.FunctionObjectActionExecutorImplConfiguration";
    private static final String _OAUTH_HEADLESS_SERVER_PID = "com.liferay.oauth2.provider.configuration.OAuth2ProviderApplicationHeadlessServerConfiguration";
    private static final String _OAUTH_PROVIDER_PREFIX = "com.liferay.oauth2.provider.configuration.OAuth2ProviderApplication";
    private static final String _OAUTH_USER_AGENT_PID = "com.liferay.oauth2.provider.configuration.OAuth2ProviderApplicationUserAgentConfiguration";
    private static final String _OBJECT_INTERNAL_PREFIX = "com.liferay.object.internal.configuration.";
    private static final Map<String, String> _clientExtensionFactoryPids = new HashMap<String, String>();
    private final Map<String, Object> _typeSettings;

    public ClientExtension() {
        _clientExtensionFactoryPids.put("customElement", _CET_CONFIGURATION_PID);
        _clientExtensionFactoryPids.put("globalCSS", _CET_CONFIGURATION_PID);
        _clientExtensionFactoryPids.put("globalJS", _CET_CONFIGURATION_PID);
        _clientExtensionFactoryPids.put("iframe", _CET_CONFIGURATION_PID);
        _clientExtensionFactoryPids.put("oauthApplicationHeadlessServer", _OAUTH_HEADLESS_SERVER_PID);
        _clientExtensionFactoryPids.put("oauthApplicationUserAgent", _OAUTH_USER_AGENT_PID);
        _clientExtensionFactoryPids.put("objectAction", _FUNCTION_OBJECT_ACTION_PID);
        _clientExtensionFactoryPids.put("themeCSS", _CET_CONFIGURATION_PID);
        _clientExtensionFactoryPids.put("themeFavicon", _CET_CONFIGURATION_PID);
        _clientExtensionFactoryPids.put("themeJS", _CET_CONFIGURATION_PID);
        this._typeSettings = new HashMap<String, Object>();
    }

    @JsonAnySetter
    public void ignored(String name, Object value) {
        this._typeSettings.put(name, value);
    }

    public Map<String, Object> toJSONMap() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("baseURL", _BASE_URL_PREFIX + this.projectName);
        config.put("description", this.description);
        config.put("dxp.lxc.liferay.com.virtualInstanceId", "default");
        config.put("name", this.name);
        config.put("sourceCodeURL", this.sourceCodeURL);
        config.put("type", this.type);
        String pid = _clientExtensionFactoryPids.get(this.type);
        if (pid != null && (pid.equals(_OAUTH_HEADLESS_SERVER_PID) || pid.equals(_OAUTH_USER_AGENT_PID)) && this._typeSettings.get("homePageURL") == null) {
            this._typeSettings.put("homePageURL", "https://$[conf:ext.lxc.liferay.com.mainDomain]");
        }
        Set<Map.Entry<String, Object>> set = this._typeSettings.entrySet();
        Stream stream = set.stream();
        List typeSettings = stream.peek(entry -> {
            if (!pid.equals(_CET_CONFIGURATION_PID)) {
                config.put((String)entry.getKey(), entry.getValue());
            }
        }).map(entry -> {
            Object value = entry.getValue();
            if (value instanceof List) {
                value = StringUtil.merge((Collection)((List)value), (String)"\n");
            }
            return StringBundler.concat((Object[])new Object[]{entry.getKey(), "=", value});
        }).collect(Collectors.toList());
        config.put("typeSettings", typeSettings);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put(_clientExtensionFactoryPids.get(this.type) + "~" + this.id, config);
        return jsonMap;
    }
}

