/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.petra.string.StringUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Gregory Amerson
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ClientExtension {

	@JsonAnySetter
	public void ignored(String name, Object value) {
		if (value instanceof List) {
			List<?> listValue = (List<?>)value;

			value = StringUtil.merge(listValue, StringPool.NEW_LINE);
		}

		_typeSettings.add(StringBundler.concat(name, "=", value));
	}

	public String toJSON() throws Exception {
		Map<String, Object> config = new HashMap<>();

		config.put("baseURL", _BASE_URL_PREFIX + projectName);
		config.put("description", description);
		config.put("dxp.lxc.liferay.com.virtualInstanceId", "default");
		config.put("name", name);
		config.put("sourceCodeURL", sourceCodeURL);
		config.put("type", type);
		config.put("typeSettings", _typeSettings);

		Map<String, Object> jsonMap = new HashMap<>();

		jsonMap.put(_CLIENT_EXTENSION_FACTORY_PREFIX + id, config);

		ObjectMapper objectMapper = new ObjectMapper();

		objectMapper.configure(
			SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

		ObjectWriter objectWriter =
			objectMapper.writerWithDefaultPrettyPrinter();

		return objectWriter.writeValueAsString(jsonMap);
	}

	public String description = "";
	public String id;
	public String name = "";
	public String projectName;
	public String sourceCodeURL = "";
	public String type;

	private static final String _BASE_URL_PREFIX = "${portalURL}/o/";

	private static final String _CLIENT_EXTENSION_FACTORY_PREFIX =
		"com.liferay.client.extension.type.configuration.CETConfiguration~";

	private final List<String> _typeSettings = new ArrayList<>();

}