/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.ClientExtensionProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.ExtProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.ModulesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.PluginsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.RootProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.ThemesProjectConfigurator;
import com.liferay.gradle.plugins.workspace.configurator.WarsProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.workspace.bundle.url.codec.BundleURLCodec;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;

public class WorkspaceExtension {
    private static final File _BUNDLE_CACHE_DIR = new File(System.getProperty("user.home"), ".liferay/bundles");
    private static final boolean _BUNDLE_DIST_INCLUDE_METADATA = false;
    private static final String _BUNDLE_DIST_ROOT_DIR_NAME = null;
    private static final boolean _BUNDLE_TOKEN_DOWNLOAD = false;
    private static final String _BUNDLE_TOKEN_EMAIL_ADDRESS = null;
    private static final boolean _BUNDLE_TOKEN_FORCE = false;
    private static final String _BUNDLE_TOKEN_PASSWORD = null;
    private static final String _BUNDLE_TOKEN_PASSWORD_FILE = null;
    private static final String _CDN_PRODUCT_INFO_URL = "https://releases-cdn.liferay.com/tools/workspace/.product_info.json";
    private static final String _DEFAULT_WORKSPACE_CACHE_DIR_NAME = ".liferay/workspace";
    private static final File _DOCKER_DIR = new File("build" + File.separator + "docker");
    private static final boolean _DOCKER_PULL_POLICY = true;
    private static final String _NODE_PACKAGE_MANAGER = "yarn";
    private static final String _PRODUCT_INFO_URL = "https://releases.liferay.com/tools/workspace/.product_info.json";
    private final Object _appServerTomcatVersion;
    private Object _bundleCacheDir;
    private Object _bundleChecksumMD5;
    private Object _bundleDistIncludeMetadata;
    private Object _bundleDistRootDirName;
    private Object _bundleTokenDownload;
    private Object _bundleTokenEmailAddress;
    private Object _bundleTokenForce;
    private Object _bundleTokenPassword;
    private Object _bundleTokenPasswordFile;
    private Object _bundleUrl;
    private Object _configsDir;
    private Object _dockerAccessToken;
    private Object _dockerContainerId;
    private Object _dockerDir;
    private Object _dockerImageId;
    private Object _dockerImageLiferay;
    private Object _dockerLocalRegistryAddress;
    private Object _dockerPullPolicy;
    private Object _dockerUserName;
    private Object _environment;
    private final Gradle _gradle;
    private Object _homeDir;
    private Object _nodePackageManager;
    private Object _product;
    private final Map<String, ProductInfo> _productInfos = new HashMap<String, ProductInfo>();
    private final Set<ProjectConfigurator> _projectConfigurators = new LinkedHashSet<ProjectConfigurator>();
    private final Plugin<Project> _rootProjectConfigurator;
    private Object _targetPlatformVersion;
    private final File _workspaceCacheDir = new File(System.getProperty("user.home"), ".liferay/workspace");

    public WorkspaceExtension(Settings settings) {
        this._gradle = settings.getGradle();
        this._product = this._getProperty((Object)settings, "product", (String)null);
        this._projectConfigurators.add(new ClientExtensionProjectConfigurator(settings));
        this._projectConfigurators.add(new ExtProjectConfigurator(settings));
        this._projectConfigurators.add(new ModulesProjectConfigurator(settings));
        this._projectConfigurators.add(new PluginsProjectConfigurator(settings));
        this._projectConfigurators.add(new ThemesProjectConfigurator(settings));
        this._projectConfigurators.add(new WarsProjectConfigurator(settings));
        this._appServerTomcatVersion = GradleUtil.getProperty((ExtensionAware)settings, (String)"app.server.tomcat.version", (String)this._getDefaultAppServerVersion());
        this._bundleCacheDir = this._getProperty((Object)settings, "bundle.cache.dir", _BUNDLE_CACHE_DIR);
        this._bundleChecksumMD5 = this._getProperty((Object)settings, "bundle.checksum.md5", this.getDefaultBundleChecksumMD5());
        this._bundleDistIncludeMetadata = this._getProperty((Object)settings, "bundle.dist.include.metadata", false);
        this._bundleDistRootDirName = this._getProperty((Object)settings, "bundle.dist.root.dir", _BUNDLE_DIST_ROOT_DIR_NAME);
        this._bundleTokenDownload = this._getProperty((Object)settings, "bundle.token.download", false);
        this._bundleTokenEmailAddress = this._getProperty((Object)settings, "bundle.token.email.address", _BUNDLE_TOKEN_EMAIL_ADDRESS);
        this._bundleTokenForce = this._getProperty((Object)settings, "bundle.token.force", false);
        this._bundleTokenPassword = this._getProperty((Object)settings, "bundle.token.password", _BUNDLE_TOKEN_PASSWORD);
        this._bundleTokenPasswordFile = this._getProperty((Object)settings, "bundle.token.password.file", _BUNDLE_TOKEN_PASSWORD_FILE);
        this._bundleUrl = this._getProperty((Object)settings, "bundle.url", this.getDefaultBundleUrl());
        this._configsDir = this._getProperty((Object)settings, "configs.dir", "configs");
        this._dockerAccessToken = this._getProperty(settings, "docker.access.token");
        this._dockerDir = this._getProperty((Object)settings, "docker.dir", _DOCKER_DIR);
        this._dockerImageLiferay = this._getProperty((Object)settings, "docker.image.liferay", this._getDefaultDockerImage());
        this._dockerLocalRegistryAddress = this._getProperty(settings, "docker.local.registry.address");
        this._dockerPullPolicy = this._getProperty((Object)settings, "docker.pull.policy", true);
        this._dockerUserName = this._getProperty(settings, "docker.username");
        this._environment = this._getProperty((Object)settings, "environment", "local");
        this._homeDir = this._getProperty((Object)settings, "home.dir", "bundles");
        this._nodePackageManager = this._getProperty((Object)settings, "node.package.manager", _NODE_PACKAGE_MANAGER);
        this._targetPlatformVersion = this._getProperty((Object)settings, "target.platform.version", this._getDefaultTargetplatformVersion());
        this._gradle.projectsEvaluated((Closure)new Closure<Void>((Object)this._gradle){

            public void doCall() {
                Project rootProject = WorkspaceExtension.this._gradle.getRootProject();
                Logger logger = rootProject.getLogger();
                if (!logger.isLifecycleEnabled()) {
                    return;
                }
                if (WorkspaceExtension.this._product == null) {
                    logger.lifecycle("The property `liferay.workspace.product` has not been set. It is recommended to set this property in gradle.properties in the workspace directory. See LPS-111700.");
                    return;
                }
                String overridePropertyInfo = "The %s property is currently overriding the default value managed by the liferay.workspace.product setting.";
                if (!Objects.equals(WorkspaceExtension.this.getAppServerTomcatVersion(), WorkspaceExtension.this._getDefaultAppServerVersion())) {
                    logger.lifecycle(String.format(overridePropertyInfo, "app.server.tomcat.version"));
                }
                if (!Objects.equals(WorkspaceExtension.this.getBundleChecksumMD5(), WorkspaceExtension.this.getDefaultBundleChecksumMD5())) {
                    logger.lifecycle(String.format(overridePropertyInfo, "liferay.workspace.bundle.checksum.md5"));
                }
                if (!Objects.equals(WorkspaceExtension.this.getBundleUrl(), WorkspaceExtension.this.getDefaultBundleUrl())) {
                    logger.lifecycle(String.format(overridePropertyInfo, "liferay.workspace.bundle.url"));
                }
                if (!Objects.equals(WorkspaceExtension.this.getDockerImageLiferay(), WorkspaceExtension.this._getDefaultDockerImage())) {
                    logger.lifecycle(String.format(overridePropertyInfo, "liferay.workspace.docker.image.liferay"));
                }
                if (!Objects.equals(WorkspaceExtension.this.getTargetPlatformVersion(), WorkspaceExtension.this._getDefaultTargetplatformVersion())) {
                    logger.lifecycle(String.format(overridePropertyInfo, "liferay.workspace.target.platform.version"));
                }
            }
        });
        this._rootProjectConfigurator = new RootProjectConfigurator(settings);
    }

    public String getAppServerTomcatVersion() {
        return GradleUtil.toString((Object)this._appServerTomcatVersion);
    }

    public File getBundleCacheDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._bundleCacheDir);
    }

    public String getBundleChecksumMD5() {
        return GradleUtil.toString((Object)this._bundleChecksumMD5);
    }

    public String getBundleDistRootDirName() {
        return GradleUtil.toString((Object)this._bundleDistRootDirName);
    }

    public String getBundleTokenEmailAddress() {
        return GradleUtil.toString((Object)this._bundleTokenEmailAddress);
    }

    public String getBundleTokenPassword() {
        return GradleUtil.toString((Object)this._bundleTokenPassword);
    }

    public File getBundleTokenPasswordFile() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._bundleTokenPasswordFile);
    }

    public String getBundleUrl() {
        return GradleUtil.toString((Object)this._bundleUrl);
    }

    public File getConfigsDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._configsDir);
    }

    public String getDefaultBundleChecksumMD5() {
        return Optional.ofNullable(this._getProductInfo(this.getProduct())).map(ProductInfo::getBundleChecksumMD5).orElse(null);
    }

    public String getDefaultBundleUrl() {
        return Optional.ofNullable(this._getProductInfo(this.getProduct())).map(this::_decodeBundleUrl).orElse(null);
    }

    public String getDockerAccessToken() {
        return GradleUtil.toString((Object)this._dockerAccessToken);
    }

    public String getDockerContainerId() {
        return GradleUtil.toString((Object)this._dockerContainerId);
    }

    public File getDockerDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._dockerDir);
    }

    public String getDockerImageId() {
        return GradleUtil.toString((Object)this._dockerImageId);
    }

    public String getDockerImageLiferay() {
        return GradleUtil.toString((Object)this._dockerImageLiferay);
    }

    public String getDockerLocalRegistryAddress() {
        return GradleUtil.toString((Object)this._dockerLocalRegistryAddress);
    }

    public boolean getDockerPullPolicy() {
        return GradleUtil.toBoolean(this._dockerPullPolicy);
    }

    public String getDockerUserName() {
        return GradleUtil.toString((Object)this._dockerUserName);
    }

    public String getEnvironment() {
        return GradleUtil.toString((Object)this._environment);
    }

    public File getHomeDir() {
        return GradleUtil.toFile(this._gradle.getRootProject(), this._homeDir);
    }

    public String getNodePackageManager() {
        return GradleUtil.toString((Object)this._nodePackageManager);
    }

    public String getProduct() {
        return GradleUtil.toString((Object)this._product);
    }

    public ProductInfo getProductInfo() {
        return this._getProductInfo(this.getProduct());
    }

    public Iterable<ProjectConfigurator> getProjectConfigurators() {
        return Collections.unmodifiableSet(this._projectConfigurators);
    }

    public Plugin<Project> getRootProjectConfigurator() {
        return this._rootProjectConfigurator;
    }

    public String getTargetPlatformVersion() {
        return GradleUtil.toString((Object)this._targetPlatformVersion);
    }

    public boolean isBundleDistIncludeMetadata() {
        return GradleUtil.toBoolean(this._bundleDistIncludeMetadata);
    }

    public boolean isBundleTokenDownload() {
        return GradleUtil.toBoolean(this._bundleTokenDownload);
    }

    public boolean isBundleTokenForce() {
        return GradleUtil.toBoolean(this._bundleTokenForce);
    }

    public ProjectConfigurator propertyMissing(String name) {
        for (ProjectConfigurator projectConfigurator : this._projectConfigurators) {
            if (!name.equals(projectConfigurator.getName())) continue;
            return projectConfigurator;
        }
        throw new MissingPropertyException(name, ProjectConfigurator.class);
    }

    public void setBundleCacheDir(Object bundleCacheDir) {
        this._bundleCacheDir = bundleCacheDir;
    }

    public void setBundleChecksumMD5(Object bundleChecksumMD5) {
        this._bundleChecksumMD5 = bundleChecksumMD5;
    }

    public void setBundleDistIncludeMetadata(Object bundleDistIncludeMetadata) {
        this._bundleDistIncludeMetadata = bundleDistIncludeMetadata;
    }

    public void setBundleDistRootDirName(Object bundleDistRootDirName) {
        this._bundleDistRootDirName = bundleDistRootDirName;
    }

    public void setBundleTokenDownload(Object bundleTokenDownload) {
        this._bundleTokenDownload = bundleTokenDownload;
    }

    public void setBundleTokenEmailAddress(Object bundleTokenEmailAddress) {
        this._bundleTokenEmailAddress = bundleTokenEmailAddress;
    }

    public void setBundleTokenForce(Object bundleTokenForce) {
        this._bundleTokenForce = bundleTokenForce;
    }

    public void setBundleTokenPassword(Object bundleTokenPassword) {
        this._bundleTokenPassword = bundleTokenPassword;
    }

    public void setBundleTokenPasswordFile(Object bundleTokenPasswordFile) {
        this._bundleTokenPasswordFile = bundleTokenPasswordFile;
    }

    public void setBundleUrl(Object bundleUrl) {
        this._bundleUrl = bundleUrl;
    }

    public void setConfigsDir(Object configsDir) {
        this._configsDir = configsDir;
    }

    public void setDockerAccessToken(Object dockerAccessToken) {
        this._dockerAccessToken = dockerAccessToken;
    }

    public void setDockerContainerId(Object dockerContainerId) {
        this._dockerContainerId = dockerContainerId;
    }

    public void setDockerDir(Object dockerDir) {
        this._dockerDir = dockerDir;
    }

    public void setDockerImageId(Object dockerImageId) {
        this._dockerImageId = dockerImageId;
    }

    public void setDockerImageLiferay(Object dockerImageLiferay) {
        this._dockerImageLiferay = dockerImageLiferay;
    }

    public void setDockerLocalRegistryAddress(Object dockerLocalRegistryAddress) {
        this._dockerLocalRegistryAddress = dockerLocalRegistryAddress;
    }

    public void setDockerPullPolicy(Object dockerPullPolicy) {
        this._dockerPullPolicy = dockerPullPolicy;
    }

    public void setDockerUserName(Object dockerUserName) {
        this._dockerUserName = dockerUserName;
    }

    public void setEnvironment(Object environment) {
        this._environment = environment;
    }

    public void setHomeDir(Object homeDir) {
        this._homeDir = homeDir;
    }

    public void setNodePackageManager(Object nodePackageManager) {
        this._nodePackageManager = nodePackageManager;
    }

    public void setProduct(Object product) {
        this._product = product;
    }

    public void setTargetPlatformVersion(Object targetPlatformVersion) {
        this._targetPlatformVersion = targetPlatformVersion;
    }

    private String _decodeBundleUrl(ProductInfo productInfo) {
        try {
            return BundleURLCodec.decode(productInfo.getBundleUrl(), productInfo.getReleaseDate());
        }
        catch (Exception exception) {
            throw new GradleException("Unable to determine bundle URL", (Throwable)exception);
        }
    }

    private String _getDefaultAppServerVersion() {
        return Optional.ofNullable(this._getProductInfo(this.getProduct())).map(ProductInfo::getAppServerTomcatVersion).orElse(null);
    }

    private String _getDefaultDockerImage() {
        return Optional.ofNullable(this._getProductInfo(this.getProduct())).map(ProductInfo::getLiferayDockerImage).orElse(null);
    }

    private String _getDefaultTargetplatformVersion() {
        return Optional.ofNullable(this._getProductInfo(this.getProduct())).map(ProductInfo::getTargetPlatformVersion).orElse(null);
    }

    private ProductInfo _getProductInfo(Path downloadPath, String product) throws Exception {
        try (JsonReader jsonReader = new JsonReader((Reader)Files.newBufferedReader(downloadPath));){
            Map<String, ProductInfo> productInfos = this._getProductInfos(jsonReader);
            ProductInfo productInfo = productInfos.get(product);
            return productInfo;
        }
    }

    private ProductInfo _getProductInfo(String product) {
        if (product == null) {
            return null;
        }
        return this._productInfos.computeIfAbsent(product, key -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private Map<String, ProductInfo> _getProductInfos(JsonReader jsonReader) {
        Gson gson = new Gson();
        TypeToken<Map<String, ProductInfo>> typeToken = new TypeToken<Map<String, ProductInfo>>(){};
        return (Map)gson.fromJson(jsonReader, typeToken.getType());
    }

    private Object _getProperty(Object object, String keySuffix) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix);
    }

    private boolean _getProperty(Object object, String keySuffix, boolean defaultValue) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix, defaultValue);
    }

    private Object _getProperty(Object object, String keySuffix, File defaultValue) {
        Object value = GradleUtil.getProperty(object, "liferay.workspace." + keySuffix);
        if (value instanceof String && Validator.isNull((String)((String)value))) {
            value = null;
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private String _getProperty(Object object, String keySuffix, String defaultValue) {
        return GradleUtil.getProperty(object, "liferay.workspace." + keySuffix, defaultValue);
    }

    public class ProductInfo {
        @SerializedName(value="appServerTomcatVersion")
        private String _appServerTomcatVersion;
        @SerializedName(value="bundleChecksumMD5")
        private String _bundleChecksumMD5;
        @SerializedName(value="bundleUrl")
        private String _bundleUrl;
        @SerializedName(value="liferayDockerImage")
        private String _liferayDockerImage;
        @SerializedName(value="liferayProductVersion")
        private String _liferayProductVersion;
        @SerializedName(value="releaseDate")
        private String _releaseDate;
        @SerializedName(value="targetPlatformVersion")
        private String _targetPlatformVersion;

        public String getAppServerTomcatVersion() {
            return this._appServerTomcatVersion;
        }

        public String getBundleChecksumMD5() {
            return this._bundleChecksumMD5;
        }

        public String getBundleUrl() {
            return this._bundleUrl;
        }

        public String getLiferayDockerImage() {
            return this._liferayDockerImage;
        }

        public String getLiferayProductVersion() {
            return this._liferayProductVersion;
        }

        public String getReleaseDate() {
            return this._releaseDate;
        }

        public String getTargetPlatformVersion() {
            return this._targetPlatformVersion;
        }
    }
}

