/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.FileUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;

public class InitBundleTask
extends JavaExec {
    private Object _configEnvironment = "local";
    private Object _configsDir;
    private Object _destinationDir;
    private Object _file;
    private FileCollection _providedModules;
    private Object _stripComponents = 1;

    public InitBundleTask() {
        this.setMain("com.liferay.portal.tools.bundle.support.BundleSupport");
    }

    public void exec() {
        this.setArgs(this._getCompleteArgs());
        super.exec();
    }

    @Input
    public String getConfigEnvironment() {
        return GradleUtil.toString((Object)this._configEnvironment);
    }

    @Optional
    public File getConfigsDir() {
        return GradleUtil.toFile(this.getProject(), this._configsDir);
    }

    @OutputDirectory
    public File getDestinationDir() {
        return GradleUtil.toFile(this.getProject(), this._destinationDir);
    }

    @InputFile
    public File getFile() {
        return GradleUtil.toFile(this.getProject(), this._file);
    }

    @Input
    @Optional
    public FileCollection getProvidedModules() {
        return this._providedModules;
    }

    @Input
    @Optional
    public int getStripComponents() {
        return GradleUtil.toInteger((Object)this._stripComponents);
    }

    public void setConfigEnvironment(Object configEnvironment) {
        this._configEnvironment = configEnvironment;
    }

    public void setConfigsDir(Object configsDir) {
        this._configsDir = configsDir;
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public void setFile(Object file) {
        this._file = file;
    }

    public void setProvidedModules(FileCollection providedModules) {
        this._providedModules = providedModules;
    }

    public void setStripComponents(Object stripComponents) {
        this._stripComponents = stripComponents;
    }

    private List<String> _getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("initBundle");
        File configsDir = this.getConfigsDir();
        if (configsDir != null) {
            args.add("--configs");
            args.add(FileUtil.getAbsolutePath((File)configsDir));
        }
        args.add("--environment");
        args.add(this.getConfigEnvironment());
        args.add("--liferay");
        args.add(FileUtil.getAbsolutePath((File)this.getDestinationDir()));
        FileCollection providedModules = this.getProvidedModules();
        if (!providedModules.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            Iterator iterator = providedModules.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                Path path = file.toPath();
                path = path.toAbsolutePath();
                path = path.normalize();
                sb.append(path.toString());
                if (!iterator.hasNext()) continue;
                sb.append(',');
            }
            args.add("--provided-modules");
            args.add(sb.toString());
        }
        args.add("--strip-components");
        args.add(String.valueOf(this.getStripComponents()));
        try {
            File file = this.getFile();
            URI uri = file.toURI();
            URL url = uri.toURL();
            args.add("--url");
            args.add(url.toString());
        }
        catch (MalformedURLException malformedURLException) {
            Logger logger = this.getLogger();
            logger.error("Unable to construct URL for {}", (Object)this.getFile());
        }
        return args;
    }
}

