/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.workspace.tasks;

import java.util.Objects;

import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

/**
 * @author Simon Jiang
 */
public class VerifyProductTask extends DefaultTask {

	@Input
	@Optional
	public String getBundleUrl() {
		return _bundleUrl;
	}

	@Input
	@Optional
	public String getDockerImageLiferay() {
		return _dockerImageLiferay;
	}

	@Input
	@Optional
	public String getErrorMessage() {
		return _errorMessage;
	}

	@Input
	@Optional
	public String getTargetPlatformVersion() {
		return _targetPlatformVersion;
	}

	public void setBundleUrl(String bundleUrl) {
		_bundleUrl = bundleUrl;
	}

	public void setDockerImageLiferay(String dockerImageLiferay) {
		_dockerImageLiferay = dockerImageLiferay;
	}

	public void setErrorMessage(String errorMessage) {
		_errorMessage = errorMessage;
	}

	public void setTargetPlatformVersion(String targetPlatformVersion) {
		_targetPlatformVersion = targetPlatformVersion;
	}

	@TaskAction
	public void verifyProduct() throws Exception {
		if (!_errorMessage.isEmpty()) {
			throw new GradleException(_errorMessage);
		}

		if (Objects.isNull(_bundleUrl) || _bundleUrl.isEmpty()) {
			throw new GradleException("Liferay bundle URL should not be null");
		}

		if (Objects.isNull(_dockerImageLiferay) ||
			_dockerImageLiferay.isEmpty()) {

			throw new GradleException(
				"Liferay Docker image name should not be null");
		}
	}

	private String _bundleUrl = "";
	private String _dockerImageLiferay = "";
	private String _errorMessage = "";
	private String _targetPlatformVersion = "";

}