/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal;

import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.gulp.ExecuteGulpTask;
import com.liferay.gradle.plugins.gulp.GulpPlugin;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class LiferayThemeGulpPlugin
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new LiferayThemeGulpPlugin();
    private static final String _GULP_BUILD_TASK_NAME = "gulpBuild";

    public void apply(final Project project) {
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(LiferayThemePlugin.class, (Action)new Action<LiferayThemePlugin>(){

            public void execute(LiferayThemePlugin liferayThemePlugin) {
                LiferayThemeGulpPlugin.this._applyPluginDefaults(project);
            }
        });
    }

    private LiferayThemeGulpPlugin() {
    }

    private void _applyPluginDefaults(Project project) {
        GradleUtil.applyPlugin((Project)project, GulpPlugin.class);
        final TaskProvider createLiferayThemeJsonTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"createLiferayThemeJson");
        final TaskProvider gulpBuildTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)_GULP_BUILD_TASK_NAME);
        final TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteGulpTask.class, (Action)new Action<ExecuteGulpTask>(){

            public void execute(ExecuteGulpTask executeGulpTask) {
                LiferayThemeGulpPlugin.this._configureTaskExecuteGulp((TaskProvider<Task>)createLiferayThemeJsonTaskProvider, executeGulpTask);
            }
        });
        ArtifactHandler artifacts = project.getArtifacts();
        artifacts.add("archives", (Object)this._getWarFile(project), (Closure)new Closure<Void>((Object)project){

            public void doCall(ConfigurablePublishArtifact configurablePublishArtifact) {
                Task packageRunBuildTask = (Task)taskContainer.findByName("packageRunBuild");
                if (packageRunBuildTask != null) {
                    gulpBuildTaskProvider.configure((Action)new Action<Task>(){

                        public void execute(Task gulpBuildTask) {
                            gulpBuildTask.finalizedBy(new Object[]{"packageRunBuild"});
                        }
                    });
                }
                configurablePublishArtifact.builtBy(new Object[]{gulpBuildTaskProvider.get()});
            }
        });
    }

    private void _configureTaskExecuteGulp(TaskProvider<Task> createLiferayThemeJsonTaskProvider, ExecuteGulpTask executeGulpTask) {
        executeGulpTask.dependsOn(new Object[]{createLiferayThemeJsonTaskProvider});
    }

    private File _getWarFile(Project project) {
        return project.file((Object)("dist/" + GradleUtil.getArchivesBaseName(project) + ".war"));
    }
}

