/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.TomcatAppServer;
import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;

public abstract class BaseProjectConfigurator
implements ProjectConfigurator {
    private final Set<File> _defaultRootDirs;

    public BaseProjectConfigurator(Settings settings) {
        String defaultRootDirNames = GradleUtil.getProperty((ExtensionAware)settings, (String)this.getDefaultRootDirPropertyName(), (String)null);
        File rootDir = settings.getRootDir();
        if (Validator.isNotNull((String)defaultRootDirNames)) {
            if (defaultRootDirNames.equals("*")) {
                this._defaultRootDirs = Collections.singleton(rootDir);
            } else {
                this._defaultRootDirs = new HashSet<File>();
                for (String dirName : defaultRootDirNames.split("\\s*,\\s*")) {
                    File dir = new File(rootDir, dirName);
                    this._defaultRootDirs.add(dir);
                }
            }
        } else {
            this._defaultRootDirs = Collections.singleton(rootDir);
        }
    }

    @Override
    public void configureRootProject(Project project, WorkspaceExtension workspaceExtension) {
    }

    @Override
    public Iterable<File> getDefaultRootDirs() {
        return this._defaultRootDirs;
    }

    @Override
    public Iterable<File> getProjectDirs(File rootDir) {
        try {
            if (!rootDir.exists()) {
                return Collections.emptySet();
            }
            return this.doGetProjectDirs(rootDir);
        }
        catch (Exception exception) {
            throw new GradleException("Unable to get project directories from " + rootDir, (Throwable)exception);
        }
    }

    protected Copy addTaskDockerDeploy(Project project, Object sourcePath, WorkspaceExtension workspaceExtension) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)"dockerDeploy", Copy.class);
        copy.from(new Object[]{sourcePath});
        final File dockerDir = workspaceExtension.getDockerDir();
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(dockerDir, "deploy");
            }
        });
        copy.setDescription("Assembles the project and deploys it to the Liferay Docker container.");
        copy.setGroup("docker");
        Task deployTask = GradleUtil.getTask((Project)project, (String)"deploy");
        deployTask.finalizedBy(new Object[]{copy});
        Task buildDockerImageTask = GradleUtil.getTask((Project)project.getRootProject(), (String)"buildDockerImage");
        buildDockerImageTask.dependsOn(new Object[]{deployTask});
        return copy;
    }

    protected void configureLiferay(Project project, WorkspaceExtension workspaceExtension) {
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        liferayExtension.setAppServerParentDir((Object)workspaceExtension.getHomeDir());
        String version = GradleUtil.getProperty((ExtensionAware)project, (String)"app.server.tomcat.version", (String)null);
        File dir = workspaceExtension.getHomeDir();
        if (version == null && dir.exists()) {
            for (String fileName : dir.list()) {
                if (!fileName.startsWith("tomcat-")) continue;
                version = fileName.substring(fileName.indexOf("-") + 1);
                NamedDomainObjectContainer namedDomainObjectCollection = liferayExtension.getAppServers();
                TomcatAppServer tomcatAppServer = (TomcatAppServer)namedDomainObjectCollection.getByName("tomcat");
                tomcatAppServer.setVersion((Object)version);
            }
        }
    }

    protected abstract Iterable<File> doGetProjectDirs(File var1) throws Exception;

    protected String getDefaultRootDirName() {
        return this.getName();
    }

    protected String getDefaultRootDirPropertyName() {
        return "liferay.workspace." + this.getName() + ".dir";
    }

    protected boolean isExcludedDirName(String dirName) {
        if (dirName == null) {
            return false;
        }
        return dirName.equals(".gradle") || dirName.equals("build") || dirName.equals("build_gradle") || dirName.equals("dist") || dirName.equals("gradle") || dirName.equals("node_modules") || dirName.equals("node_modules_cache") || dirName.equals("src");
    }
}

