/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.theme.builder.BuildThemeTask;
import com.liferay.gradle.plugins.theme.builder.ThemeBuilderPlugin;
import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.Copy;

public class ThemesProjectConfigurator
extends BaseProjectConfigurator {
    protected static final String NAME = "themes";
    private static final boolean _JAVA_BUILD = false;
    private boolean _javaBuild;

    public ThemesProjectConfigurator(Settings settings) {
        super(settings);
        this._javaBuild = GradleUtil.getProperty((Object)settings, "liferay.workspace.themes.java.build", false);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        if (this.isJavaBuild()) {
            ProjectConfigurator projectConfigurator = workspaceExtension.propertyMissing("wars");
            projectConfigurator.apply(project);
            GradleUtil.applyPlugin((Project)project, ThemeBuilderPlugin.class);
            this._configureTaskBuildTheme(project);
            this._configureWar(project);
        } else {
            GradleUtil.applyPlugin((Project)project, LiferayThemePlugin.class);
            this._configureLiferay(project, workspaceExtension);
            final Task assembleTask = GradleUtil.getTask((Project)project, (String)"assemble");
            this._configureRootTaskDistBundle(assembleTask);
            Callable<ConfigurableFileCollection> warSourcePath = new Callable<ConfigurableFileCollection>(){

                @Override
                public ConfigurableFileCollection call() throws Exception {
                    Project project = assembleTask.getProject();
                    ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{ThemesProjectConfigurator.this._getWarFile(project)});
                    return configurableFileCollection.builtBy(new Object[]{assembleTask});
                }
            };
            this.addTaskDockerDeploy(project, warSourcePath, workspaceExtension);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean isJavaBuild() {
        return this._javaBuild;
    }

    public void setJavaBuild(boolean javaBuild) {
        this._javaBuild = javaBuild;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path dirNamePath = dirPath.getFileName();
                String dirName = dirNamePath.toString();
                if (dirName.equals("build") || dirName.equals("build_gradle") || dirName.equals("node_modules") || dirName.equals("node_modules_cache")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (Files.exists(dirPath.resolve("package.json"), new LinkOption[0])) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private void _configureLiferay(Project project, WorkspaceExtension workspaceExtension) {
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        liferayExtension.setAppServerParentDir((Object)workspaceExtension.getHomeDir());
    }

    private void _configureRootTaskDistBundle(final Task assembleTask) {
        Project project = assembleTask.getProject();
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.dependsOn(new Object[]{assembleTask});
        copy.into((Object)"osgi/war", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                Project project = assembleTask.getProject();
                File warFile = ThemesProjectConfigurator.this._getWarFile(project);
                ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{warFile});
                configurableFileCollection.builtBy(new Object[]{assembleTask});
                copySpec.from(new Object[]{warFile});
            }
        });
    }

    private void _configureTaskBuildTheme(Project project) {
        File packageJsonFile = project.file((Object)"package.json");
        if (!packageJsonFile.exists()) {
            return;
        }
        BuildThemeTask buildThemeTask = (BuildThemeTask)GradleUtil.getTask((Project)project, (String)"buildTheme");
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map packageJsonMap = (Map)jsonSlurper.parse(packageJsonFile);
        Map liferayThemeMap = (Map)packageJsonMap.get("liferayTheme");
        String baseTheme = (String)liferayThemeMap.get("baseTheme");
        if (baseTheme.equals("styled") || baseTheme.equals("unstyled")) {
            baseTheme = "_" + baseTheme;
        }
        String templateLanguage = (String)liferayThemeMap.get("templateLanguage");
        buildThemeTask.setParentName((Object)baseTheme);
        buildThemeTask.setTemplateExtension((Object)templateLanguage);
    }

    private void _configureWar(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        warPluginConvention.setWebAppDirName("src");
    }

    private File _getWarFile(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        return project.file((Object)("dist/" + basePluginConvention.getArchivesBaseName() + ".war"));
    }
}

