/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.LiferayOSGiExtension;
import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerPlugin;
import com.liferay.gradle.plugins.service.builder.ServiceBuilderPlugin;
import com.liferay.gradle.plugins.workspace.MetatypePlugin;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySourceSpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.tasks.Jar;

public class ModulesProjectConfigurator
extends BaseProjectConfigurator {
    protected static final String NAME = "modules";
    private static final boolean _DEFAULT_JSP_PRECOMPILE_ENABLED = false;
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private boolean _defaultRepositoryEnabled;
    private boolean _jspPrecompileEnabled;

    public ModulesProjectConfigurator(Settings settings) {
        super(settings);
        this._defaultRepositoryEnabled = GradleUtil.getProperty((Object)settings, "liferay.workspace.modules.default.repository.enabled", true);
        this._jspPrecompileEnabled = GradleUtil.getProperty((Object)settings, "liferay.workspace.modules.jsp.precompile.enabled", false);
    }

    public void apply(Project project) {
        final WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        this._applyPlugins(project);
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        this._configureLiferay(project, workspaceExtension);
        this._configureLiferayOSGi(project);
        this._configureTaskRunPoshi(project);
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        final JavaCompile compileJSPTask = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJSP");
        this._configureRootTaskDistBundle(jar, compileJSPTask);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                ModulesProjectConfigurator.this._configureTaskCompileJSP(compileJSPTask, workspaceExtension);
            }
        });
        this.addTaskDockerDeploy(project, jar, workspaceExtension);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    public boolean isJspPrecompileEnabled() {
        return this._jspPrecompileEnabled;
    }

    public void setDefaultRepositoryEnabled(boolean defaultRepositoryEnabled) {
        this._defaultRepositoryEnabled = defaultRepositoryEnabled;
    }

    public void setJspPrecompileEnabled(boolean jspPrecompileEnabled) {
        this._jspPrecompileEnabled = jspPrecompileEnabled;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                if (Files.exists(dirPath.resolve("bnd.bnd"), new LinkOption[0])) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayOSGiPlugin.class);
        GradleUtil.applyPlugin((Project)project, PoshiRunnerPlugin.class);
        if (FileUtil.exists((Project)project, (String)"service.xml")) {
            GradleUtil.applyPlugin((Project)project, ServiceBuilderPlugin.class);
        }
    }

    private void _configureLiferay(Project project, WorkspaceExtension workspaceExtension) {
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        liferayExtension.setAppServerParentDir((Object)workspaceExtension.getHomeDir());
    }

    private void _configureLiferayOSGi(Project project) {
        LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
        HashMap<String, String> bundleDefaultInstructions = new HashMap<String, String>();
        bundleDefaultInstructions.put("-plugin.metatype", MetatypePlugin.class.getName());
        liferayOSGiExtension.bundleDefaultInstructions(bundleDefaultInstructions);
    }

    private void _configureRootTaskDistBundle(final Jar jar, final JavaCompile compileJSPTask) {
        final Project project = jar.getProject();
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.into((Object)"osgi/modules", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySourceSpec copySourceSpec) {
                copySourceSpec.from(new Object[]{jar});
            }
        });
        if (this.isJspPrecompileEnabled()) {
            copy.into((Object)new Closure<String>((Object)project){

                public String doCall() {
                    return ModulesProjectConfigurator.this._getCompileJSPDestinationDirName(project);
                }
            }, (Closure)new Closure<Void>((Object)project){

                public void doCall(CopySourceSpec copySourceSpec) {
                    copySourceSpec.from(new Object[]{compileJSPTask});
                }
            });
        }
    }

    private void _configureTaskCompileJSP(JavaCompile compileJSPTask, WorkspaceExtension workspaceExtension) {
        if (!this.isJspPrecompileEnabled()) {
            return;
        }
        File dir = new File(workspaceExtension.getHomeDir(), this._getCompileJSPDestinationDirName(compileJSPTask.getProject()));
        compileJSPTask.setDestinationDir(dir);
    }

    private void _configureTaskRunPoshi(Project project) {
        Task task = GradleUtil.getTask((Project)project, (String)"runPoshi");
        task.dependsOn(new Object[]{"deploy"});
    }

    private String _getCompileJSPDestinationDirName(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        return "work/" + basePluginConvention.getArchivesBaseName() + "-" + project.getVersion();
    }
}

