/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import com.liferay.release.util.ResourceUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClientExtension {
    public String description = "";
    public String id;
    public String name = "";
    public String projectId;
    public String projectName;
    public Map<String, Object> properties = Collections.emptyMap();
    public String sourceCodeURL = "";
    public String type;
    @JsonIgnore
    public Map<String, Object> typeSettings = new HashMap<String, Object>();
    public String virtualInstanceId = "default";
    private static final Properties _clientExtensionProperties = Objects.requireNonNull(ResourceUtil.readProperties((ResourceUtil.Resolver[])new ResourceUtil.Resolver[]{ResourceUtil.getClassLoaderResolver(ClientExtension.class, (String)"client-extension.properties")}), "Unable to read client-extension.properties file from class path");
    private final Logger _logger = Logging.getLogger(ClientExtension.class);

    public String getClassification() {
        String classification = _clientExtensionProperties.getProperty(this.type + ".classification");
        if (classification != null) {
            return classification;
        }
        throw new GradleException(String.format("Client extension %s with type %s is of unknown classification", this.id, this.type));
    }

    @JsonAnySetter
    public void ignored(String name, Object value) {
        this.typeSettings.put(name, value);
    }

    @JsonProperty(value="dxp.lxc.liferay.com.virtualInstanceId")
    public void setVirtualInstanceId(String virtualInstanceId) {
        this.virtualInstanceId = virtualInstanceId;
        if (this._logger.isWarnEnabled()) {
            this._logger.warn(StringUtil.concat("The deprecated property ", "\"dxp.lxc.liferay.com.virtualInstanceId\" is set in ", "client-extension.yaml. Set the Gradle property ", "\"liferay.virtual.instance.id\" instead."));
        }
    }

    public Map<String, Object> toJSONMap(String virtualInstanceId) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        HashMap<String, Object> typeSettings = new HashMap<String, Object>(this.typeSettings);
        Object pid = _clientExtensionProperties.getProperty(this.type + ".pid");
        if (Objects.equals(this.type, "instanceSettings")) {
            pid = typeSettings.remove("pid") + ".scoped";
        }
        if (pid == null) {
            return jsonMap;
        }
        if (!StringUtil.isBlank(virtualInstanceId)) {
            if (!StringUtil.isBlank(this.virtualInstanceId) && !Objects.equals(this.virtualInstanceId, virtualInstanceId) && this._logger.isWarnEnabled()) {
                String message = String.format(StringUtil.concat("The client extension property value ", "\"dxp.lxc.liferay.com.virtualInstanceId\" ", "%s differs from the Gradle property ", "\"liferay.virtual.instance.id\" value %s. The ", "Gradle property will be used."), StringUtil.quote(this.virtualInstanceId), StringUtil.quote(virtualInstanceId));
                this._logger.warn(message);
            }
            this.virtualInstanceId = virtualInstanceId;
        }
        if (StringUtil.isBlank(this.virtualInstanceId)) {
            this.virtualInstanceId = "default";
        }
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put(":configurator:policy", "force");
        String pathSuffix = StringUtil.suffixIfNotBlank(this.projectName, virtualInstanceId);
        configMap.put("baseURL", typeSettings.getOrDefault("baseURL", "${portalURL}/o/" + pathSuffix));
        configMap.put("buildTimestamp", System.currentTimeMillis());
        configMap.put("description", this.description);
        configMap.put("dxp.lxc.liferay.com.virtualInstanceId", this.virtualInstanceId);
        configMap.put("name", this.name);
        configMap.put("projectId", this.projectId);
        configMap.put("projectName", this.projectName);
        configMap.put("properties", this._encode(this.properties));
        configMap.put("sourceCodeURL", this.sourceCodeURL);
        configMap.put("type", this.type);
        configMap.put("webContextPath", typeSettings.getOrDefault("webContextPath", "/" + pathSuffix));
        if (!((String)pid).contains("CETConfiguration")) {
            configMap.putAll(typeSettings);
        }
        if (this.type.equals("oAuthApplicationHeadlessServer") || this.type.equals("oAuthApplicationUserAgent")) {
            configMap.put("homePageURL", typeSettings.getOrDefault("homePageURL", "$[conf:.serviceScheme]://$[conf:.serviceAddress]"));
        }
        configMap.put("typeSettings", this._encode(typeSettings));
        String pidSuffix = StringUtil.suffixIfNotBlank(this.id, "/", virtualInstanceId);
        jsonMap.put((String)pid + "~" + pidSuffix, configMap);
        return jsonMap;
    }

    private List<String> _encode(Map<String, Object> map) {
        Set<Map.Entry<String, Object>> set = map.entrySet();
        Stream stream = set.stream();
        return stream.map(entry -> {
            Object value = entry.getValue();
            if (value instanceof List) {
                value = StringUtil.join("\n", (List)value);
            }
            return StringUtil.concat(entry.getKey(), "=", value);
        }).collect(Collectors.toList());
    }
}

