/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurator;

import com.bmuschko.gradle.docker.DockerRegistryCredentials;
import com.bmuschko.gradle.docker.DockerRemoteApiPlugin;
import com.bmuschko.gradle.docker.tasks.image.DockerBuildImage;
import com.bmuschko.gradle.docker.tasks.image.DockerRemoveImage;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.node.task.ExecuteNodeTask;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurator.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.client.extension.NodeBuildConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ThemeCSSTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.JsonNodeUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import com.liferay.gradle.plugins.workspace.internal.util.copy.HashifyAction;
import com.liferay.gradle.plugins.workspace.task.CreateClientExtensionConfigTask;
import com.liferay.gradle.util.ArrayUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.TaskState;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.process.ProcessForkOptions;

public class ClientExtensionProjectConfigurator
extends BaseProjectConfigurator {
    public static final String ASSEMBLE_CLIENT_EXTENSION_TASK_NAME = "assembleClientExtension";
    public static final String BUILD_CLIENT_EXTENSION_ZIP_TASK_NAME = "buildClientExtensionZip";
    public static final String BUILD_SITE_INITIALIZER_ZIP_TASK_NAME = "buildSiteInitializerZip";
    public static final String CREATE_CLIENT_EXTENSION_CONFIG_TASK_NAME = "createClientExtensionConfig";
    public static final String VALIDATE_CLIENT_EXTENSION_IDS_TASK_NAME = "validateClientExtensionIds";
    public static final String VALIDATE_CLIENT_EXTENSIONS_TASK_NAME = "validateClientExtensions";
    protected static final String NAME = "client.extension";
    private static final String _CLIENT_EXTENSION_YAML = "client-extension.yaml";
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private static final String _ENV_LIFERAY_ROUTES_CLIENT_EXTENSION = "LIFERAY_ROUTES_CLIENT_EXTENSION";
    private static final String _ENV_LIFERAY_ROUTES_DXP = "LIFERAY_ROUTES_DXP";
    private static final Pattern _overrideClientExtensionYamlPattern = Pattern.compile("^client-extension\\.([a-z]+)\\.yaml$");
    private final Map<String, Set<Project>> _clientExtensionIds = new HashMap<String, Set<Project>>();
    private final boolean _defaultRepositoryEnabled;
    private final NodeBuildConfigurer _nodeBuildConfigurer = new NodeBuildConfigurer();
    private final ThemeCSSTypeConfigurer _themeCSSTypeConfigurer = new ThemeCSSTypeConfigurer();
    private final ObjectMapper _yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public static String getClientExtensionBuildDir(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)project.getGradle(), WorkspaceExtension.class);
        return StringUtil.suffixIfNotBlank("liferay-client-extension-build", workspaceExtension.getVirtualInstanceId());
    }

    public ClientExtensionProjectConfigurator(Settings settings) {
        super(settings);
        this._defaultRepositoryEnabled = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.client.extension.default.repository.enabled", (boolean)true);
    }

    public void apply(final Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)project.getGradle(), WorkspaceExtension.class);
        TaskProvider createClientExtensionConfigTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)CREATE_CLIENT_EXTENSION_CONFIG_TASK_NAME, CreateClientExtensionConfigTask.class);
        TaskProvider assembleClientExtensionTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)ASSEMBLE_CLIENT_EXTENSION_TASK_NAME, Copy.class);
        TaskProvider buildClientExtensionZipTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)BUILD_CLIENT_EXTENSION_ZIP_TASK_NAME, Zip.class);
        TaskProvider buildSiteInitializerZipTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)BUILD_SITE_INITIALIZER_ZIP_TASK_NAME, Zip.class);
        TaskProvider validateClientExtensionIdsTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)VALIDATE_CLIENT_EXTENSION_IDS_TASK_NAME, Task.class);
        TaskProvider validateClientExtensionTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)VALIDATE_CLIENT_EXTENSIONS_TASK_NAME, Task.class);
        this._baseConfigureClientExtensionProject(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider, (TaskProvider<Zip>)buildClientExtensionZipTaskProvider, (TaskProvider<Zip>)buildSiteInitializerZipTaskProvider, (TaskProvider<CreateClientExtensionConfigTask>)createClientExtensionConfigTaskProvider, (TaskProvider<Task>)validateClientExtensionIdsTaskProvider, (TaskProvider<Task>)validateClientExtensionTaskProvider, workspaceExtension);
        AtomicBoolean hasThemeCSSClientExtension = new AtomicBoolean(false);
        Map<String, JsonNode> profileJsonNodes = this._configureClientExtensionJsonNodes(project, assembleClientExtensionTaskProvider, createClientExtensionConfigTaskProvider, validateClientExtensionIdsTaskProvider, validateClientExtensionTaskProvider);
        for (Map.Entry<String, JsonNode> profileJsonNodeEntry : profileJsonNodes.entrySet()) {
            String profileName = profileJsonNodeEntry.getKey();
            JsonNode jsonNode = profileJsonNodeEntry.getValue();
            Iterator iterator = jsonNode.fields();
            iterator.forEachRemaining(entry -> {
                String fieldName = (String)entry.getKey();
                if (Objects.equals(fieldName, "runtime")) {
                    return;
                }
                JsonNode fieldJsonNode = (JsonNode)entry.getValue();
                if (Objects.equals(fieldName, "assemble")) {
                    this._configureAssembleClientExtensionTask(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider, fieldJsonNode, profileName);
                    return;
                }
                try {
                    final ClientExtension clientExtension = (ClientExtension)this._yamlObjectMapper.treeToValue((TreeNode)((ObjectNode)fieldJsonNode), ClientExtension.class);
                    clientExtension.id = fieldName;
                    if (Validator.isNull((String)clientExtension.type)) {
                        clientExtension.type = fieldName;
                    }
                    clientExtension.projectId = StringUtil.toAlphaNumericLowerCase(project.getName());
                    clientExtension.projectName = project.getName();
                    validateClientExtensionTaskProvider.configure(task -> task.doLast((Action)new Action<Task>(){

                        public void execute(Task task1) {
                            ClientExtensionProjectConfigurator.this._validateClientExtension(clientExtension, project);
                        }
                    }));
                    this._clientExtensionIds.compute(clientExtension.id, (key, value) -> {
                        if (value == null) {
                            value = new HashSet<Project>();
                        }
                        value.add(project);
                        return value;
                    });
                    createClientExtensionConfigTaskProvider.configure(createClientExtensionConfigTask -> {
                        if (!this._isActiveProfile(project, profileName)) {
                            return;
                        }
                        createClientExtensionConfigTask.setVirtualInstanceId(workspaceExtension.getVirtualInstanceId());
                        createClientExtensionConfigTask.addClientExtension(clientExtension);
                    });
                    if (clientExtension.type.equals("configuration")) {
                        assembleClientExtensionTaskProvider.configure(copy -> {
                            if (!this._isActiveProfile(project, profileName)) {
                                return;
                            }
                            copy.from((Object)"src", copySpec -> copySpec.include(new String[]{"**/*"}));
                        });
                    } else if (clientExtension.type.equals("themeCSS")) {
                        hasThemeCSSClientExtension.set(true);
                    }
                    if (clientExtension.type.equals("siteInitializer")) {
                        buildSiteInitializerZipTaskProvider.configure(zip -> {
                            zip.from(new Object[]{project.file((Object)"site-initializer")});
                            zip.into((Object)"site-initializer");
                        });
                        createClientExtensionConfigTaskProvider.configure(task -> task.dependsOn(new Object[]{BUILD_SITE_INITIALIZER_ZIP_TASK_NAME}));
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    throw new GradleException("Unable to parse client extension " + fieldName, (Throwable)jsonProcessingException);
                }
            });
        }
        if (hasThemeCSSClientExtension.get()) {
            this._themeCSSTypeConfigurer.apply(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider);
        }
        this._nodeBuildConfigurer.apply(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider);
        this._addDockerTasks(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider, (TaskProvider<CreateClientExtensionConfigTask>)createClientExtensionConfigTaskProvider, workspaceExtension);
        this._configureLiferayRoutes(project, workspaceExtension);
    }

    @Override
    public String getName() {
        return "client-extension";
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(final File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                String dirName = String.valueOf(dirPath.getFileName());
                if (ClientExtensionProjectConfigurator.this.isExcludedDirName(dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path clientExtensionPath = dirPath.resolve(ClientExtensionProjectConfigurator._CLIENT_EXTENSION_YAML);
                if (Files.exists(clientExtensionPath, new LinkOption[0]) && !Objects.equals(dirPath, rootDir.toPath())) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private void _addDockerTasks(final Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider, TaskProvider<CreateClientExtensionConfigTask> createClientExtensionConfigTaskProvider, WorkspaceExtension workspaceExtension) {
        DockerBuildImage dockerBuildImage = (DockerBuildImage)GradleUtil.addTask((Project)project, (String)"buildDockerImage", DockerBuildImage.class);
        dockerBuildImage.setDescription("Builds a child Docker image from the Liferay base image with all configs deployed.");
        dockerBuildImage.setGroup("docker");
        dockerBuildImage.dependsOn(new Object[]{createClientExtensionConfigTaskProvider});
        DirectoryProperty inputDirectoryProperty = dockerBuildImage.getInputDir();
        assembleClientExtensionTaskProvider.configure(copy -> inputDirectoryProperty.set(copy.getDestinationDir()));
        Property pullProperty = dockerBuildImage.getPull();
        pullProperty.set((Object)workspaceExtension.getDockerPullPolicy());
        if (Objects.nonNull(workspaceExtension.getDockerLocalRegistryAddress())) {
            String dockerUserName;
            DockerRegistryCredentials dockerRegistryCredentials = dockerBuildImage.getRegistryCredentials();
            String dockerUserAccessToken = workspaceExtension.getDockerUserAccessToken();
            if (Objects.nonNull(dockerUserAccessToken)) {
                Property passwordProperty = dockerRegistryCredentials.getPassword();
                passwordProperty.set((Object)dockerUserAccessToken);
            }
            if (Objects.nonNull(dockerUserName = workspaceExtension.getDockerUserName())) {
                Property userNameProperty = dockerRegistryCredentials.getUsername();
                userNameProperty.set((Object)dockerUserName);
            }
        }
        DockerRemoveImage dockerRemoveImage = (DockerRemoveImage)GradleUtil.addTask((Project)project, (String)"cleanDockerImage", DockerRemoveImage.class);
        dockerRemoveImage.setDescription("Removes the Docker image.");
        dockerRemoveImage.setGroup("docker");
        Property forceProperty = dockerRemoveImage.getForce();
        forceProperty.set((Object)true);
        String dockerImageId = this._getDockerImageId(project);
        SetProperty setProperty = dockerBuildImage.getImages();
        setProperty.add((Object)dockerImageId);
        Property property = dockerRemoveImage.getImageId();
        property.set((Object)dockerImageId);
        dockerRemoveImage.onError((Action)new Action<Throwable>(){

            public void execute(Throwable throwable) {
                Logger logger = project.getLogger();
                if (logger.isWarnEnabled()) {
                    logger.warn("No image with ID '" + ClientExtensionProjectConfigurator.this._getDockerImageId(project) + "' found.");
                }
            }
        });
        Task cleanTask = GradleUtil.getTask((Project)project, (String)"clean");
        cleanTask.dependsOn(new Object[]{dockerRemoveImage});
    }

    private TaskProvider<Zip> _baseConfigureClientExtensionProject(Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider, TaskProvider<Zip> buildClientExtensionZipTaskProvider, TaskProvider<Zip> buildSiteInitializerZipTaskProvider, TaskProvider<CreateClientExtensionConfigTask> createClientExtensionConfigTaskProvider, TaskProvider<Task> validateClientExtensionIdsTaskProvider, TaskProvider<Task> validateClientExtensionTaskProvider, WorkspaceExtension workspaceExtension) {
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        GradleUtil.applyPlugin((Project)project, DockerRemoteApiPlugin.class);
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        this.configureLiferay(project, workspaceExtension);
        this._configureLiferayExtension(project, liferayExtension);
        this._configureConfigurationDefault(project);
        this._configureTaskCheck(project);
        this._configureTaskClean(project);
        this._configureTaskDeploy(project, buildClientExtensionZipTaskProvider);
        this._configureClientExtensionTasks(project, assembleClientExtensionTaskProvider, buildClientExtensionZipTaskProvider, buildSiteInitializerZipTaskProvider, createClientExtensionConfigTaskProvider, validateClientExtensionIdsTaskProvider, validateClientExtensionTaskProvider, workspaceExtension);
        this.addTaskDockerDeploy(project, buildClientExtensionZipTaskProvider, new File(workspaceExtension.getDockerDir(), "client-extensions"));
        this._configureArtifacts(project, buildClientExtensionZipTaskProvider);
        this._configureRootTaskDistBundle(project, buildClientExtensionZipTaskProvider);
        return buildClientExtensionZipTaskProvider;
    }

    private void _configureArtifacts(Project project, TaskProvider<Zip> buildClientExtensionZipTaskProvider) {
        ArtifactHandler artifacts = project.getArtifacts();
        artifacts.add("archives", buildClientExtensionZipTaskProvider);
    }

    private void _configureAssembleClientExtensionTask(Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider, JsonNode assembleJsonNode, String profileName) {
        if (assembleJsonNode.isNull()) {
            return;
        }
        ArrayNode assembleArrayNode = (ArrayNode)assembleJsonNode;
        if (assembleArrayNode.isEmpty()) {
            return;
        }
        assembleClientExtensionTaskProvider.configure(assembleClientExtensionCopy -> {
            if (!this._isActiveProfile(project, profileName)) {
                return;
            }
            assembleArrayNode.forEach(copyJsonNode -> {
                JsonNode fromJsonNode = copyJsonNode.get("from");
                JsonNode fromTaskJsonNode = copyJsonNode.get("fromTask");
                JsonNode hashifyJsonNode = copyJsonNode.get("hashify");
                JsonNode includeJsonNode = copyJsonNode.get("include");
                JsonNode intoJsonNode = copyJsonNode.get("into");
                Object fromPath = null;
                if (fromTaskJsonNode != null) {
                    TaskContainer taskContainer = project.getTasks();
                    fromPath = taskContainer.findByName(fromTaskJsonNode.asText());
                }
                if (fromPath == null && fromJsonNode != null) {
                    fromPath = fromJsonNode.asText();
                }
                assembleClientExtensionCopy.from(fromPath != null ? fromPath : ".", copySpec -> {
                    if (hashifyJsonNode != null) {
                        copySpec.eachFile((Action)new HashifyAction(hashifyJsonNode.asText()));
                    }
                    copySpec.exclude(new String[]{"**/" + ClientExtensionProjectConfigurator.getClientExtensionBuildDir(project)});
                    if (includeJsonNode instanceof ArrayNode) {
                        ArrayNode arrayNode = (ArrayNode)includeJsonNode;
                        arrayNode.forEach(include -> copySpec.include(new String[]{include.asText()}));
                    } else if (includeJsonNode != null) {
                        copySpec.include(new String[]{includeJsonNode.asText()});
                    } else {
                        copySpec.include(new String[]{"**/*"});
                    }
                    if (intoJsonNode != null) {
                        copySpec.into((Object)intoJsonNode.asText());
                    }
                    copySpec.setIncludeEmptyDirs(false);
                });
            });
        });
    }

    private Map<String, JsonNode> _configureClientExtensionJsonNodes(Project project, TaskProvider<?> ... taskProviders) {
        HashMap<String, JsonNode> profileJsonNodes = new HashMap<String, JsonNode>();
        File clientExtensionYamlFile = project.file((Object)_CLIENT_EXTENSION_YAML);
        JsonNode rootJsonNode = this._getJsonNode(clientExtensionYamlFile);
        profileJsonNodes.put("default", rootJsonNode);
        File parentFile = clientExtensionYamlFile.getParentFile();
        for (File file : Objects.requireNonNull(parentFile.listFiles())) {
            Matcher matcher = _overrideClientExtensionYamlPattern.matcher(file.getName());
            if (!matcher.find()) continue;
            String profileName = matcher.group(1);
            if (Objects.equals(profileName, "default")) {
                Logger logger = project.getLogger();
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Ignoring client-extension.default.yaml because \"default\" is a reserved profile name.");
                continue;
            }
            this._configureDeployProfileTask(project, clientExtensionYamlFile, file, profileName);
            JsonNode jsonNode = rootJsonNode.deepCopy();
            JsonNodeUtil.overrideJsonNodeValues(jsonNode, this._getJsonNode(file));
            profileJsonNodes.put(profileName, jsonNode);
            for (TaskProvider<?> taskProvider : taskProviders) {
                taskProvider.configure(task -> {
                    if (this._isActiveProfile(project, profileName)) {
                        TaskInputs taskInputs = task.getInputs();
                        taskInputs.file((Object)file);
                    }
                });
            }
        }
        return profileJsonNodes;
    }

    private void _configureClientExtensionTasks(final Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider, TaskProvider<Zip> buildClientExtensionZipTaskProvider, TaskProvider<Zip> buildSiteInitializerZipTaskProvider, final TaskProvider<CreateClientExtensionConfigTask> createClientExtensionConfigTaskProvider, TaskProvider<Task> validateClientExtensionIdsTaskProvider, TaskProvider<Task> validateClientExtensionTaskProvider, final WorkspaceExtension workspaceExtension) {
        File clientExtensionYamlFile = project.file((Object)_CLIENT_EXTENSION_YAML);
        createClientExtensionConfigTaskProvider.configure(createClientExtensionConfigTask -> {
            createClientExtensionConfigTask.dependsOn(new Object[]{ASSEMBLE_CLIENT_EXTENSION_TASK_NAME, VALIDATE_CLIENT_EXTENSION_IDS_TASK_NAME, VALIDATE_CLIENT_EXTENSIONS_TASK_NAME});
            TaskInputsInternal taskInputs = createClientExtensionConfigTask.getInputs();
            taskInputs.file((Object)clientExtensionYamlFile);
        });
        File clientExtensionBuildDir = new File(project.getBuildDir(), ClientExtensionProjectConfigurator.getClientExtensionBuildDir(project));
        assembleClientExtensionTaskProvider.configure(copy -> {
            TaskInputsInternal taskInputs = copy.getInputs();
            taskInputs.file((Object)clientExtensionYamlFile);
            copy.into((Object)clientExtensionBuildDir);
            copy.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    Copy copy1 = (Copy)task;
                    project.delete(new Object[]{copy1.getDestinationDir()});
                }
            });
            copy.doLast((Action)new Action<Task>(){

                public void execute(Task task) {
                    Copy copy1 = (Copy)task;
                    if (!copy1.getDidWork()) {
                        return;
                    }
                    CreateClientExtensionConfigTask createClientExtensionConfigTask = (CreateClientExtensionConfigTask)((Object)createClientExtensionConfigTaskProvider.get());
                    TaskOutputsInternal taskOutputs = createClientExtensionConfigTask.getOutputs();
                    taskOutputs.upToDateWhen(task1 -> false);
                }
            });
        });
        buildClientExtensionZipTaskProvider.configure(zip -> {
            zip.dependsOn(new Object[]{CREATE_CLIENT_EXTENSION_CONFIG_TASK_NAME});
            DirectoryProperty destinationDirectoryProperty = zip.getDestinationDirectory();
            destinationDirectoryProperty.set(new File(project.getProjectDir(), "dist"));
            Property archiveBaseNameProperty = zip.getArchiveBaseName();
            archiveBaseNameProperty.set(project.provider((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return StringUtil.suffixIfNotBlank(project.getName(), workspaceExtension.getVirtualInstanceId());
                }
            }));
            Property archiveVersion = zip.getArchiveVersion();
            archiveVersion.set((Object)"");
            zip.from(new Object[]{clientExtensionBuildDir});
            zip.include(new String[]{"**/*"});
        });
        validateClientExtensionIdsTaskProvider.configure(task -> {
            task.setDescription("Validates that this project's client extension IDs are unique among all projects.");
            task.setGroup("verification");
            TaskInputs taskInputs = task.getInputs();
            taskInputs.file((Object)clientExtensionYamlFile);
            TaskOutputs taskOutputs = task.getOutputs();
            taskOutputs.upToDateWhen(task1 -> true);
            task.doFirst((Action)new Action<Task>(){

                public void execute(Task validateClientExtensionIdsTask1) {
                    StringBuilder sb = new StringBuilder();
                    File rootDir = project.getRootDir();
                    Path rootDirPath = rootDir.toPath();
                    for (Map.Entry entry : ClientExtensionProjectConfigurator.this._clientExtensionIds.entrySet()) {
                        Set projects = (Set)entry.getValue();
                        if (projects.size() <= 1 || !projects.contains(project)) continue;
                        sb.append("Duplicate client extension ID \"");
                        sb.append((String)entry.getKey());
                        sb.append("\" found in these projects:\n");
                        for (Project curProject : projects) {
                            File projectDir = curProject.getProjectDir();
                            sb.append(rootDirPath.relativize(projectDir.toPath()));
                            sb.append(", ");
                        }
                        sb.append(", ");
                    }
                    if (sb.length() > 0) {
                        throw new GradleException(sb.toString());
                    }
                }
            });
        });
        validateClientExtensionTaskProvider.configure(task -> {
            TaskInputs taskInputs = task.getInputs();
            taskInputs.file((Object)clientExtensionYamlFile);
            TaskOutputs taskOutputs = task.getOutputs();
            taskOutputs.upToDateWhen(task1 -> true);
        });
        buildSiteInitializerZipTaskProvider.configure(zip -> {
            DirectoryProperty destinationDirectoryProperty = zip.getDestinationDirectory();
            destinationDirectoryProperty.set(new File(clientExtensionBuildDir, "site-initializer"));
            Property archiveBaseNameProperty = zip.getArchiveBaseName();
            archiveBaseNameProperty.set((Object)"site-initializer");
        });
    }

    private void _configureConfigurationDefault(Project project) {
        Configuration defaultConfiguration = GradleUtil.getConfiguration((Project)project, (String)"default");
        Configuration archivesConfiguration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        defaultConfiguration.extendsFrom(new Configuration[]{archivesConfiguration});
    }

    private void _configureDeployProfileTask(final Project project, final File clientExtensionYamlFile, final File overrideClientExtensionYamlFile, final String profileName) {
        TaskProvider deployProfileTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)("deploy" + StringUtil.capitalize(profileName)), Task.class);
        deployProfileTaskProvider.configure((Action)new Action<Task>(){

            public void execute(Task deployProfileTask) {
                GradleUtil.setProperty((ExtensionAware)project, (String)"profileName", (Object)profileName);
                deployProfileTask.finalizedBy(new Object[]{"deploy"});
                deployProfileTask.setDescription("Assembles the project and deploys it to Liferay with the \"" + profileName + "\" client extension profile.");
                deployProfileTask.setGroup("build");
                TaskInputs taskInputs = deployProfileTask.getInputs();
                taskInputs.files(new Object[]{clientExtensionYamlFile, overrideClientExtensionYamlFile});
            }
        });
    }

    private void _configureLiferayExtension(final Project project, final LiferayExtension liferayExtension) {
        liferayExtension.setDeployDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = new File(liferayExtension.getAppServerParentDir(), "osgi/client-extensions");
                dir.mkdirs();
                return GradleUtil.getProperty((Project)project, (String)"auto.deploy.dir", (File)dir);
            }
        });
    }

    private void _configureLiferayRoutes(final Project project, WorkspaceExtension workspaceExtension) {
        final HashMap<String, String> environmentVariables = new HashMap<String, String>();
        String liferayVirtualInstanceId = workspaceExtension.getVirtualInstanceId();
        if (StringUtil.isBlank(liferayVirtualInstanceId)) {
            liferayVirtualInstanceId = "default";
        }
        environmentVariables.put(_ENV_LIFERAY_ROUTES_CLIENT_EXTENSION, String.format("%s/routes/%s/%s", workspaceExtension.getHomeDir(), liferayVirtualInstanceId, project.getName()));
        environmentVariables.put(_ENV_LIFERAY_ROUTES_DXP, String.format("%s/routes/%s/dxp", workspaceExtension.getHomeDir(), liferayVirtualInstanceId));
        Gradle gradle = project.getGradle();
        TaskExecutionGraph taskGraph = gradle.getTaskGraph();
        taskGraph.addTaskExecutionListener(new TaskExecutionListener(){

            public void afterExecute(Task task, TaskState taskState) {
            }

            public void beforeExecute(Task task) {
                if (Objects.equals(project, task.getProject()) && (task instanceof ExecuteNodeTask || task instanceof ProcessForkOptions)) {
                    if (task instanceof ProcessForkOptions) {
                        ProcessForkOptions processForkOptions = (ProcessForkOptions)task;
                        processForkOptions.environment(environmentVariables);
                    } else {
                        ExecuteNodeTask executeNodeTask = (ExecuteNodeTask)task;
                        executeNodeTask.environment(environmentVariables);
                    }
                    Logger logger = task.getLogger();
                    if (logger.isInfoEnabled()) {
                        logger.info(StringUtil.concat("Injecting Liferay routes configuration ", "paths as environment variables into the ", "process invoked by the task ", task.getPath()));
                        for (Map.Entry entry : environmentVariables.entrySet()) {
                            logger.info("{}: {}", entry.getKey(), entry.getValue());
                        }
                    }
                }
            }
        });
    }

    private void _configureRootTaskDistBundle(Project project, final TaskProvider<Zip> buildClientExtensionZipTaskProvider) {
        final Task assembleTask = GradleUtil.getTask((Project)project, (String)"assemble");
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.dependsOn(new Object[]{assembleTask});
        copy.into((Object)"osgi/client-extensions", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                Project project = assembleTask.getProject();
                ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{buildClientExtensionZipTaskProvider});
                configurableFileCollection.builtBy(new Object[]{assembleTask});
                copySpec.from(new Object[]{buildClientExtensionZipTaskProvider});
            }
        });
    }

    private void _configureTaskCheck(Project project) {
        Task checkTask = GradleUtil.getTask((Project)project, (String)"check");
        checkTask.dependsOn(new Object[]{VALIDATE_CLIENT_EXTENSION_IDS_TASK_NAME});
    }

    private void _configureTaskClean(Project project) {
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        delete.delete(new Object[]{"build", "dist"});
    }

    private void _configureTaskDeploy(Project project, TaskProvider<Zip> buildClientExtensionZipTaskProvider) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"deploy");
        copy.from(new Object[]{buildClientExtensionZipTaskProvider});
    }

    private String _getDockerImageId(Project project) {
        String propertyName = "imageId";
        if (project.hasProperty(propertyName)) {
            Object property = project.property(propertyName);
            return property.toString();
        }
        return project.getName() + ":latest";
    }

    private JsonNode _getJsonNode(File file) {
        if (!file.exists()) {
            return this._yamlObjectMapper.createObjectNode();
        }
        try {
            return this._yamlObjectMapper.readTree(file);
        }
        catch (IOException ioException) {
            throw new GradleException(String.format("Unable to parse %s.", file.getName()), (Throwable)ioException);
        }
    }

    private boolean _isActiveProfile(Project project, String profileName) {
        return Objects.equals(profileName, GradleUtil.getProperty((ExtensionAware)project, (String)"profileName", (String)"default"));
    }

    private void _validateClientExtension(ClientExtension clientExtension, Project project) {
        if (Objects.equals(clientExtension.type, "batch")) {
            this._validateRequiredDirectory(clientExtension, project, "batch");
            this._validateRequiredTypeSettingsKeys(clientExtension, "oAuthApplicationHeadlessServer");
        } else if (Objects.equals(clientExtension.type, "globalJS")) {
            this._validateGlobalJSScriptElementAttributes(clientExtension);
        } else if (Objects.equals(clientExtension.type, "instanceSettings")) {
            this._validateRequiredTypeSettingsKeys(clientExtension, "pid");
        } else if (Objects.equals(clientExtension.type, "siteInitializer")) {
            this._validateRequiredDirectory(clientExtension, project, "site-initializer");
            this._validateRequiredTypeSettingsKeys(clientExtension, "oAuthApplicationHeadlessServer", "siteExternalReferenceCode", "siteName");
            this._validateTypeSettingsValues(clientExtension, "builtInTemplateType", "site-initializer", "site-template");
            this._validateTypeSettingsValues(clientExtension, "membershipType", "open", "private", "restricted");
        }
    }

    private void _validateGlobalJSScriptElementAttributes(ClientExtension clientExtension) {
        Map<String, Object> typeSettings = clientExtension.typeSettings;
        if (!typeSettings.containsKey("scriptElementAttributes")) {
            return;
        }
        Object scriptElementAttributes = typeSettings.get("scriptElementAttributes");
        if (!(scriptElementAttributes instanceof Map)) {
            throw new GradleException("The property 'scriptElementAttributes' must be an object");
        }
        Map scriptElementAttributesMap = (Map)scriptElementAttributes;
        for (Map.Entry entry : scriptElementAttributesMap.entrySet()) {
            if (Objects.equals(entry.getKey(), "src")) {
                throw new GradleException("The key 'src' is not allowed as a script element attribute");
            }
            Object value = entry.getValue();
            if (value == null) {
                throw new GradleException(String.format("The value for the script element attribute '%s' must be specified", entry.getKey()));
            }
            if (!(value instanceof List) && !(value instanceof Map)) continue;
            throw new GradleException(String.format("The value for the script element attribute '%s' must be a scalar", entry.getKey()));
        }
    }

    private void _validateRequiredDirectory(ClientExtension clientExtension, Project project, String requiredDirectoryName) throws GradleException {
        File file = project.file((Object)requiredDirectoryName);
        if (file.isDirectory()) {
            return;
        }
        throw new GradleException(String.format("A %s directory is required for client extension %s with type %s", StringUtil.quote(requiredDirectoryName), clientExtension.id, clientExtension.type));
    }

    private void _validateRequiredTypeSettingsKeys(ClientExtension clientExtension, String ... requiredTypeSettingsKeys) throws GradleException {
        for (String requiredTypeSettingsKey : requiredTypeSettingsKeys) {
            if (clientExtension.typeSettings.containsKey(requiredTypeSettingsKey)) continue;
            throw new GradleException(String.format("Client extension %s with type %s must define the property %s", clientExtension.id, clientExtension.type, StringUtil.quote(requiredTypeSettingsKey)));
        }
    }

    private void _validateTypeSettingsValues(ClientExtension clientExtension, String typeSettingsKey, String ... validValues) throws GradleException {
        Object typeSettingsValue = clientExtension.typeSettings.get(typeSettingsKey);
        if (typeSettingsValue == null || ArrayUtil.contains((Object[])validValues, (Object)typeSettingsValue)) {
            return;
        }
        throw new GradleException(String.format("Client extension %s has an invalid value %s for the property %s. Valid values are: %s.", clientExtension.id, StringUtil.quote(typeSettingsValue), StringUtil.quote(typeSettingsKey), StringUtil.join(", ", validValues)));
    }
}

