/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.gradle.plugins.workspace.internal.util.ResourceUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.gradle.api.GradleException;

public class ReleaseUtil {
    public static ReleaseUtil instance = null;
    private static final long _DEFAULT_MAX_AGE = 7L;
    private static final File _DEFAULT_WORKSPACE_CACHE_DIR = new File(System.getProperty("user.home"), ".liferay/workspace");
    private static final ReleaseProperties _EMPTY_RELEASE_PROPERTIES = new ReleaseProperties();
    private final Map<String, ReleaseEntry> _releaseEntryMap = new HashMap<String, ReleaseEntry>();
    private final Map<String, ReleaseProperties> _releasePropertiesMap = new HashMap<String, ReleaseProperties>();
    private final List<String> _releasesMirrors = new ArrayList<String>();
    private final File _workspaceCacheDir;

    public static <T> T getFromReleaseProperties(String releaseKey, Function<ReleaseProperties, T> function) {
        return function.apply(ReleaseUtil.getReleaseProperties(releaseKey));
    }

    public static ReleaseProperties getReleaseProperties(String releaseKey) {
        if (releaseKey == null) {
            return _EMPTY_RELEASE_PROPERTIES;
        }
        if (instance == null) {
            ReleaseUtil.initialize(7L);
        }
        return ReleaseUtil.instance._releasePropertiesMap.computeIfAbsent(releaseKey, instance::_createReleaseProperties);
    }

    public static void initialize(long maxAge) {
        ArrayList<String> releasesMirrors = new ArrayList<String>(StringUtil.split(System.getenv("LIFERAY_RELEASES_MIRRORS")));
        releasesMirrors.add("https://releases-cdn.liferay.com");
        ReleaseUtil.initialize(maxAge, releasesMirrors, _DEFAULT_WORKSPACE_CACHE_DIR);
    }

    public static void initialize(long maxAge, List<String> releasesMirrors, File workspaceCacheDir) {
        instance = new ReleaseUtil(maxAge, releasesMirrors, workspaceCacheDir);
    }

    private ReleaseUtil(long maxAge, List<String> releasesMirrors, File workspaceCacheDir) {
        this._workspaceCacheDir = workspaceCacheDir;
        for (String releasesMirror : releasesMirrors) {
            this._releasesMirrors.add(this._normalizeReleasesMirror(releasesMirror));
        }
        File releasesJsonFile = new File(this._workspaceCacheDir, "releases.json");
        ReleaseEntryList releaseEntries = ResourceUtil.readJson(ReleaseEntryList.class, ResourceUtil.getLocalFileResolver(releasesJsonFile, maxAge, ChronoUnit.DAYS));
        if (releaseEntries == null) {
            String releasesMirror;
            Iterator<String> iterator = this._releasesMirrors.iterator();
            while (iterator.hasNext() && (releaseEntries = ResourceUtil.readJson(ReleaseEntryList.class, ResourceUtil.getURLResolver(workspaceCacheDir, (releasesMirror = iterator.next()) + "/releases.json"))) == null) {
            }
        }
        if (releaseEntries == null && (releaseEntries = ResourceUtil.readJson(ReleaseEntryList.class, ResourceUtil.getLocalFileResolver(releasesJsonFile))) != null) {
            try {
                Files.setLastModifiedTime(releasesJsonFile.toPath(), FileTime.from(Instant.now()));
            }
            catch (IOException ioException) {
                throw new GradleException(ioException.getMessage());
            }
        }
        if (releaseEntries == null) {
            ResourceUtil.Resolver classLoaderResolver = ResourceUtil.getClassLoaderResolver("/releases.json");
            releaseEntries = ResourceUtil.readJson(ReleaseEntryList.class, classLoaderResolver);
            try (InputStream inputStream = classLoaderResolver.resolve();){
                Files.copy(inputStream, releasesJsonFile.toPath(), new CopyOption[0]);
            }
            catch (Exception exception) {
                throw new GradleException(exception.getMessage());
            }
        }
        if (releaseEntries == null) {
            throw new GradleException("Unable to read releases.json");
        }
        for (ReleaseEntry releaseEntry : releaseEntries) {
            this._releaseEntryMap.put(releaseEntry.getReleaseKey(), releaseEntry);
        }
    }

    private ReleaseProperties _createReleaseProperties(String releaseKey) {
        ReleaseEntry releaseEntry = this._releaseEntryMap.get(releaseKey);
        if (releaseEntry == null) {
            return _EMPTY_RELEASE_PROPERTIES;
        }
        String product = releaseEntry.getProduct();
        File productReleasePropertiesCacheDir = new File(new File(this._workspaceCacheDir, "releaseProperties"), String.format("%s/%s", product, releaseKey));
        Properties properties = ResourceUtil.readProperties(ResourceUtil.getLocalFileResolver(new File(productReleasePropertiesCacheDir, "release.properties")));
        if (properties == null) {
            String releasesCDNUrl = releaseEntry.getUrl() + "/release.properties";
            URI cdnURI = URI.create(releasesCDNUrl);
            String cdnURIPath = cdnURI.getPath();
            for (String releasesMirror : this._releasesMirrors) {
                String fullMirrorPath = releasesMirror + cdnURIPath;
                properties = ResourceUtil.readProperties(ResourceUtil.getURLResolver(productReleasePropertiesCacheDir, fullMirrorPath));
                if (properties == null) continue;
                break;
            }
        }
        if (properties == null) {
            throw new GradleException("No release properties found for product key " + releaseKey);
        }
        return new ReleaseProperties(properties);
    }

    private String _normalizeReleasesMirror(String releasesMirror) {
        if (releasesMirror.endsWith("/")) {
            return releasesMirror.substring(0, releasesMirror.length() - 1);
        }
        return releasesMirror;
    }

    private static class ReleaseEntryList
    extends ArrayList<ReleaseEntry> {
        private ReleaseEntryList() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ReleaseEntry {
        @JsonProperty(value="product")
        private String _product;
        @JsonProperty(value="releaseKey")
        private String _releaseKey;
        @JsonProperty(value="url")
        private String _url;

        private ReleaseEntry() {
        }

        public String getProduct() {
            return this._product;
        }

        public String getReleaseKey() {
            return this._releaseKey;
        }

        public String getUrl() {
            return this._url;
        }
    }

    public static class ReleaseProperties {
        private final String _appServerTomcatVersion;
        private final String _buildTimestamp;
        private final String _bundleChecksumSHA512;
        private final String _bundleUrl;
        private final String _gitHashLiferayDocker;
        private final String _gitHashLiferayPortalEE;
        private final String _liferayDockerImage;
        private final String _liferayDockerTags;
        private final String _liferayProductVersion;
        private final String _releaseDate;
        private final String _targetPlatformVersion;

        public String getAppServerTomcatVersion() {
            return this._appServerTomcatVersion;
        }

        public String getBuildTimestamp() {
            return this._buildTimestamp;
        }

        public String getBundleChecksumSHA512() {
            return this._bundleChecksumSHA512;
        }

        public String getBundleUrl() {
            return this._bundleUrl;
        }

        public String getGitHashLiferayDocker() {
            return this._gitHashLiferayDocker;
        }

        public String getGitHashLiferayPortalEE() {
            return this._gitHashLiferayPortalEE;
        }

        public String getLiferayDockerImage() {
            return this._liferayDockerImage;
        }

        public String getLiferayDockerTags() {
            return this._liferayDockerTags;
        }

        public String getLiferayProductVersion() {
            return this._liferayProductVersion;
        }

        public String getReleaseDate() {
            return this._releaseDate;
        }

        public String getTargetPlatformVersion() {
            return this._targetPlatformVersion;
        }

        private ReleaseProperties() {
            this(new Properties());
        }

        private ReleaseProperties(Properties properties) {
            this(properties.getProperty("app.server.tomcat.version"), properties.getProperty("build.timestamp"), properties.getProperty("bundle.checksum.sha512"), properties.getProperty("bundle.url"), properties.getProperty("git.hash.liferay-docker"), properties.getProperty("git.hash.liferay-portal-ee"), properties.getProperty("liferay.docker.image"), properties.getProperty("liferay.docker.tags"), properties.getProperty("liferay.product.version"), properties.getProperty("release.date"), properties.getProperty("target.platform.version"));
        }

        private ReleaseProperties(String appServerTomcatVersion, String buildTimestamp, String bundleChecksumSHA512, String bundleUrl, String gitHashLiferayDocker, String gitHashLiferayPortalEE, String liferayDockerImage, String liferayDockerTags, String liferayProductVersion, String releaseDate, String targetPlatformVersion) {
            this._appServerTomcatVersion = appServerTomcatVersion;
            this._buildTimestamp = buildTimestamp;
            this._bundleChecksumSHA512 = bundleChecksumSHA512;
            this._bundleUrl = bundleUrl;
            this._gitHashLiferayDocker = gitHashLiferayDocker;
            this._gitHashLiferayPortalEE = gitHashLiferayPortalEE;
            this._liferayDockerImage = liferayDockerImage;
            this._liferayDockerTags = liferayDockerTags;
            this._liferayProductVersion = liferayProductVersion;
            this._releaseDate = releaseDate;
            this._targetPlatformVersion = targetPlatformVersion;
        }
    }
}

