/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.workspace.bundle.url.codec;

import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.GregorianCalendar;

public class BundleURLCodec {
    public static String decode(String bundleUrl, String releaseDate) throws Exception {
        Base64.Decoder decoder = Base64.getUrlDecoder();
        byte[] byteArray = decoder.decode(bundleUrl);
        Date parsedReleaseDate = BundleURLCodec._parseDate(releaseDate);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(parsedReleaseDate);
        BigInteger bigInteger = new BigInteger(byteArray);
        bigInteger = bigInteger.shiftRight(calendar.get(5));
        return new String(bigInteger.toByteArray());
    }

    public static String encode(String bundleUrl, String releaseDate) throws Exception {
        String parsedBundleUrl;
        try {
            URI uri = new URI(bundleUrl);
            URL url = uri.toURL();
            parsedBundleUrl = url.toExternalForm();
        }
        catch (Exception e) {
            System.err.println("Unable to read bundle_url");
            throw e;
        }
        Date parsedReleaseDate = BundleURLCodec._parseDate(releaseDate);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(parsedReleaseDate);
        BigInteger bigInteger = new BigInteger(parsedBundleUrl.getBytes());
        bigInteger = bigInteger.shiftLeft(calendar.get(5));
        Base64.Encoder encoder = Base64.getUrlEncoder();
        return encoder.encodeToString(bigInteger.toByteArray());
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Expected two args: <bundle_url> <release_date>");
        }
        System.out.print(BundleURLCodec.encode(args[0], args[1]));
    }

    private static Date _parseDate(String releaseDate) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
        try {
            return simpleDateFormat.parse(releaseDate);
        }
        catch (ParseException e) {
            System.err.println("Unable to read release_date");
            throw e;
        }
    }
}

