/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.gradle.plugins.workspace.internal.util.ResourceUtil;
import java.io.File;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.gradle.api.GradleException;

public class ReleaseUtil {
    public static final ReleaseUtil INSTANCE = new ReleaseUtil();
    private static final ReleaseProperties _EMPTY_RELEASE_PROPERTIES = new ReleaseProperties();
    private final Map<String, ReleaseEntry> _releaseEntryMap = new HashMap<String, ReleaseEntry>();
    private final Map<String, ReleaseProperties> _releasePropertiesMap = new HashMap<String, ReleaseProperties>();
    private final File _workspaceCacheDir = new File(System.getProperty("user.home"), ".liferay/workspace");

    public static <T> T getFromReleaseProperties(String releaseKey, Function<ReleaseProperties, T> function) {
        return function.apply(ReleaseUtil.getReleaseProperties(releaseKey));
    }

    public static ReleaseProperties getReleaseProperties(String releaseKey) {
        if (releaseKey == null) {
            return _EMPTY_RELEASE_PROPERTIES;
        }
        return ReleaseUtil.INSTANCE._releasePropertiesMap.computeIfAbsent(releaseKey, INSTANCE::_createReleaseProperties);
    }

    private ReleaseUtil() {
        int maxAge = 7;
        String refreshLiferayReleases = System.getProperty("liferay.workspace.refresh.liferay.releases");
        if (refreshLiferayReleases != null) {
            maxAge = 0;
        }
        File releasesJsonFile = new File(this._workspaceCacheDir, "releases.json");
        ReleaseEntryList releaseEntries = ResourceUtil.readJson(ReleaseEntryList.class, ResourceUtil.getLocalFileResolver(releasesJsonFile, maxAge, ChronoUnit.DAYS), ResourceUtil.getURLResolver(this._workspaceCacheDir, "https://releases.liferay.com/releases.json"), ResourceUtil.getURLResolver(this._workspaceCacheDir, "https://releases-cdn.liferay.com/releases.json"), ResourceUtil.getLocalFileResolver(releasesJsonFile), ResourceUtil.getClassLoaderResolver("/releases.json"));
        if (releaseEntries == null) {
            throw new GradleException("Unable to read releases.json");
        }
        for (ReleaseEntry releaseEntry : releaseEntries) {
            this._releaseEntryMap.put(releaseEntry.getReleaseKey(), releaseEntry);
        }
    }

    private ReleaseProperties _createReleaseProperties(String releaseKey) {
        ReleaseEntry releaseEntry = this._releaseEntryMap.get(releaseKey);
        if (releaseEntry == null) {
            return _EMPTY_RELEASE_PROPERTIES;
        }
        String product = releaseEntry.getProduct();
        File productReleasePropertiesCacheDir = new File(new File(this._workspaceCacheDir, "releaseProperties"), String.format("%s/%s", product, releaseKey));
        String releasesCDNUrl = releaseEntry.getUrl() + "/release.properties";
        String releasesUrl = releasesCDNUrl.replaceFirst("releases-cdn", "releases");
        Properties properties = ResourceUtil.readProperties(ResourceUtil.getLocalFileResolver(new File(productReleasePropertiesCacheDir, "release.properties")), ResourceUtil.getURLResolver(productReleasePropertiesCacheDir, releasesCDNUrl), ResourceUtil.getURLResolver(productReleasePropertiesCacheDir, releasesUrl));
        if (properties == null) {
            throw new GradleException("No release properties found for product key " + releaseKey);
        }
        return new ReleaseProperties(properties);
    }

    private static class ReleaseEntryList
    extends ArrayList<ReleaseEntry> {
        private ReleaseEntryList() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ReleaseEntry {
        @JsonProperty(value="product")
        private String _product;
        @JsonProperty(value="releaseKey")
        private String _releaseKey;
        @JsonProperty(value="url")
        private String _url;

        private ReleaseEntry() {
        }

        public String getProduct() {
            return this._product;
        }

        public String getReleaseKey() {
            return this._releaseKey;
        }

        public String getUrl() {
            return this._url;
        }
    }

    public static class ReleaseProperties {
        private final String _appServerTomcatVersion;
        private final String _buildTimestamp;
        private final String _bundleChecksumSHA512;
        private final String _bundleUrl;
        private final String _gitHashLiferayDocker;
        private final String _gitHashLiferayPortalEE;
        private final String _liferayDockerImage;
        private final String _liferayDockerTags;
        private final String _liferayProductVersion;
        private final String _releaseDate;
        private final String _targetPlatformVersion;

        public String getAppServerTomcatVersion() {
            return this._appServerTomcatVersion;
        }

        public String getBuildTimestamp() {
            return this._buildTimestamp;
        }

        public String getBundleChecksumSHA512() {
            return this._bundleChecksumSHA512;
        }

        public String getBundleUrl() {
            return this._bundleUrl;
        }

        public String getGitHashLiferayDocker() {
            return this._gitHashLiferayDocker;
        }

        public String getGitHashLiferayPortalEE() {
            return this._gitHashLiferayPortalEE;
        }

        public String getLiferayDockerImage() {
            return this._liferayDockerImage;
        }

        public String getLiferayDockerTags() {
            return this._liferayDockerTags;
        }

        public String getLiferayProductVersion() {
            return this._liferayProductVersion;
        }

        public String getReleaseDate() {
            return this._releaseDate;
        }

        public String getTargetPlatformVersion() {
            return this._targetPlatformVersion;
        }

        private ReleaseProperties() {
            this(new Properties());
        }

        private ReleaseProperties(Properties properties) {
            this(properties.getProperty("app.server.tomcat.version"), properties.getProperty("build.timestamp"), properties.getProperty("bundle.checksum.sha512"), properties.getProperty("bundle.url"), properties.getProperty("git.hash.liferay-docker"), properties.getProperty("git.hash.liferay-portal-ee"), properties.getProperty("liferay.docker.image"), properties.getProperty("liferay.docker.tags"), properties.getProperty("liferay.product.version"), properties.getProperty("release.date"), properties.getProperty("target.platform.version"));
        }

        private ReleaseProperties(String appServerTomcatVersion, String buildTimestamp, String bundleChecksumSHA512, String bundleUrl, String gitHashLiferayDocker, String gitHashLiferayPortalEE, String liferayDockerImage, String liferayDockerTags, String liferayProductVersion, String releaseDate, String targetPlatformVersion) {
            this._appServerTomcatVersion = appServerTomcatVersion;
            this._buildTimestamp = buildTimestamp;
            this._bundleChecksumSHA512 = bundleChecksumSHA512;
            this._bundleUrl = bundleUrl;
            this._gitHashLiferayDocker = gitHashLiferayDocker;
            this._gitHashLiferayPortalEE = gitHashLiferayPortalEE;
            this._liferayDockerImage = liferayDockerImage;
            this._liferayDockerTags = liferayDockerTags;
            this._liferayProductVersion = liferayProductVersion;
            this._releaseDate = releaseDate;
            this._targetPlatformVersion = targetPlatformVersion;
        }
    }
}

