/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.saliman.gradle.plugin.properties.PropertiesPlugin;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginAware;

public class WorkspacePlugin
implements Plugin<Settings> {
    public static final String EXTENSION_NAME = "liferayWorkspace";
    public static final String PROPERTY_PREFIX = "liferay.workspace.";
    private static final Logger _logger = Logging.getLogger(WorkspacePlugin.class);
    private static final Map<String, ProjectConfigurator> _projectConfiguratorsMap = new HashMap<String, ProjectConfigurator>();

    public void apply(final Settings settings) {
        Gradle gradle = settings.getGradle();
        final File rootDir = settings.getRootDir();
        this._applyPlugins((PluginAware)settings, settings);
        final WorkspaceExtension workspaceExtension = this._addWorkspaceExtension(settings);
        final Path rootDirPath = rootDir.toPath();
        final FileSystem fileSystem = rootDirPath.getFileSystem();
        StartParameter startParameter = gradle.getStartParameter();
        final File currentDir = startParameter.getCurrentDir();
        gradle.beforeProject((Closure)new Closure<Void>((Object)settings){

            public void doCall(Project project) {
                WorkspacePlugin.this._setPortalVersion(project, workspaceExtension);
                Plugin<Project> plugin = null;
                if (project.getParent() == null) {
                    WorkspacePlugin.this._applyPlugins((PluginAware)project, settings);
                    for (ProjectConfigurator projectConfigurator : workspaceExtension.getProjectConfigurators()) {
                        projectConfigurator.configureRootProject(project, workspaceExtension);
                    }
                    plugin = workspaceExtension.getRootProjectConfigurator();
                } else {
                    plugin = (Plugin<Project>)_projectConfiguratorsMap.get(project.getPath());
                }
                if (plugin != null) {
                    plugin.apply((Object)project);
                }
            }
        });
        gradle.settingsEvaluated((Action)new Action<Settings>(){

            public void execute(Settings settings2) {
                for (ProjectConfigurator projectConfigurator : workspaceExtension.getProjectConfigurators()) {
                    for (File defaultRootDir : projectConfigurator.getDefaultRootDirs()) {
                        this._includeProjects(projectConfigurator, defaultRootDir);
                    }
                }
            }

            private void _includeProjects(ProjectConfigurator projectConfigurator, File defaultRootDir) {
                Iterable<File> projectDirs = projectConfigurator.getProjectDirs(defaultRootDir);
                Iterator<File> iterator = projectDirs.iterator();
                while (iterator.hasNext()) {
                    File projectDir = iterator.next();
                    if (Objects.equals(currentDir, projectDir)) continue;
                    for (String glob : workspaceExtension.getDirExcludesGlobs()) {
                        Path relativeProjectPath = rootDirPath.relativize(projectDir.toPath());
                        PathMatcher pathMatcher = fileSystem.getPathMatcher("glob:" + glob);
                        if (!pathMatcher.matches(relativeProjectPath)) continue;
                        if (_logger.isInfoEnabled()) {
                            _logger.info("Skipping project evaluation for {} because it matches the exclude pattern {}.", (Object)relativeProjectPath, (Object)glob);
                        }
                        iterator.remove();
                    }
                }
                for (File projectDir : projectDirs) {
                    String projectPath = GradleUtil.getProjectPath(projectDir, rootDir);
                    settings.include(new String[]{projectPath});
                    _projectConfiguratorsMap.put(projectPath, projectConfigurator);
                }
            }
        });
    }

    private WorkspaceExtension _addWorkspaceExtension(Settings settings) {
        Gradle extensionAware = settings.getGradle();
        ExtensionContainer extensionContainer = extensionAware.getExtensions();
        return (WorkspaceExtension)extensionContainer.create(EXTENSION_NAME, WorkspaceExtension.class, new Object[]{settings});
    }

    private void _applyPlugins(PluginAware pluginAware, Settings settings) {
        if (GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.feature.net.saliman.properties.plugin.enabled", (boolean)true)) {
            pluginAware.apply(Collections.singletonMap("plugin", PropertiesPlugin.class));
        }
    }

    private void _setPortalVersion(Project project, WorkspaceExtension workspaceExtension) {
        String portalVersion = GradleUtil.getProperty((ExtensionAware)project, (String)"portal.version", (String)null);
        if (Validator.isNotNull((String)portalVersion)) {
            return;
        }
        String bundleUrl = workspaceExtension.getBundleUrl();
        if (Objects.nonNull(bundleUrl) && bundleUrl.contains("7.0.")) {
            GradleUtil.setProperty((ExtensionAware)project, (String)"portal.version", (Object)"7.0.x");
        }
    }
}

