/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.task;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.internal.util.JsonNodeUtil;
import com.liferay.gradle.plugins.workspace.internal.util.ResourceUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class CreateClientExtensionConfigTask
extends DefaultTask {
    private static final Set<String> _groupBatch = Sets.newHashSet((Object[])new String[]{"batch", "configuration"});
    private static final Set<String> _groupConfiguration = Sets.newHashSet((Object[])new String[]{"configuration"});
    private static final Set<String> _groupFrontend = Sets.newHashSet((Object[])new String[]{"configuration", "frontend"});
    private static final Set<String> _groupMicroservice = Sets.newHashSet((Object[])new String[]{"configuration", "microservice"});
    private static final Map<String, String> _typeSettingsToSiteInitializerJsonKeyMap = new HashMap<String, String>(){
        {
            this.put("builtInTemplateKey", "templateKey");
            this.put("builtInTemplateType", "templateType");
            this.put("membershipType", "membershipType");
            this.put("parentSiteKey", "parentSiteKey");
            this.put("siteExternalReferenceCode", "externalReferenceCode");
            this.put("siteName", "name");
        }
    };
    private final Base64.Encoder _base64Encoder = Base64.getEncoder();
    private final Object _clientExtensionConfigFile;
    private final Set<ClientExtension> _clientExtensions = new HashSet<ClientExtension>();
    private Object _dockerFile;
    private Object _lcpJsonFile;
    private final ObjectMapper _objectMapper = new ObjectMapper();
    private final Object _pluginPackagePropertiesFile;
    private final Project _project = this.getProject();
    private Object _siteInitializerJsonFile;
    private String _type = "frontend";

    public CreateClientExtensionConfigTask() {
        this._clientExtensionConfigFile = this._addTaskOutputFile(this._project.getName() + ".client-extension-config.json");
        this._dockerFile = this._addTaskOutputFile("Dockerfile");
        this._lcpJsonFile = this._addTaskOutputFile("LCP.json");
        this._pluginPackagePropertiesFile = this._addTaskOutputFile("WEB-INF/liferay-plugin-package.properties");
    }

    public void addClientExtension(ClientExtension clientExtension) {
        this._clientExtensions.add(clientExtension);
        if (Objects.equals(clientExtension.type, "siteInitializer") && this._siteInitializerJsonFile == null) {
            this._siteInitializerJsonFile = this._addTaskOutputFile("site-initializer/site-initializer.json");
        }
        if (Objects.equals(clientExtension.type, "themeCSS") && clientExtension.typeSettings.containsKey("frontendTokenDefinitionJSON")) {
            TaskInputsInternal taskInputs = this.getInputs();
            ProviderFactory providerFactory = this._project.getProviders();
            taskInputs.file((Object)providerFactory.provider(() -> clientExtension.typeSettings.get("frontendTokenDefinitionJSON")));
        }
    }

    @TaskAction
    public void createClientExtensionConfig() {
        Properties pluginPackageProperties = this._getPluginPackageProperties();
        String classificationGrouping = this._validateAndGetClassificationGrouping(this._clientExtensions);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        String batchType = null;
        for (ClientExtension clientExtension : this._clientExtensions) {
            String type = clientExtension.type;
            if (Objects.equals(type, "batch")) {
                pluginPackageProperties.put("Liferay-Client-Extension-Batch", "batch/");
                batchType = "batch";
            } else if (Objects.equals(type, "globalJS")) {
                this._mapGlobalJSScriptElementAttributesToJSONString(clientExtension);
            } else if (Objects.equals(type, "siteInitializer")) {
                pluginPackageProperties.put("Liferay-Client-Extension-Site-Initializer", "site-initializer/");
                batchType = StringUtil.getDockerSafeName(type);
                this._createSiteInitializerJsonFile(clientExtension);
            } else if (Objects.equals(type, "themeCSS")) {
                this._inlineFrontendTokenDefinitionJSON(clientExtension);
            }
            if (Objects.equals(clientExtension.getClassification(), "frontend")) {
                this._expandWildcards(clientExtension.typeSettings);
                pluginPackageProperties.put("Liferay-Client-Extension-Frontend", "static/");
            }
            jsonMap.putAll(clientExtension.toJSONMap());
        }
        HashMap<String, String> substitutionMap = new HashMap<String, String>();
        for (ClientExtension clientExtension : this._clientExtensions) {
            for (Map.Entry<String, Object> entry : clientExtension.typeSettings.entrySet()) {
                String newKey = String.format("__%s.%s__", this._getIdOrBatchType(clientExtension), entry.getKey());
                substitutionMap.put(newKey, String.valueOf(entry.getValue()));
            }
        }
        if (batchType != null) {
            substitutionMap.put("__BATCH_TYPE__", batchType);
            if (Objects.equals(batchType, "batch")) {
                this._processBatchJSONFiles();
            }
        }
        String string = StringUtil.toAlphaNumericLowerCase(this._project.getName());
        substitutionMap.put("__PROJECT_ID__", string);
        pluginPackageProperties.put("Bundle-SymbolicName", string);
        if (!pluginPackageProperties.containsKey("module-group-id")) {
            pluginPackageProperties.put("module-group-id", "liferay");
        }
        pluginPackageProperties.put("name", this._project.getName());
        this._writeToOutputFile(ResourceUtil.readString(ResourceUtil.getLocalFileResolver(this.getInputDockerfileFile()), ResourceUtil.getClassLoaderResolver(CreateClientExtensionConfigTask.class, this._getTemplatePath(classificationGrouping, "Dockerfile"))), this.getDockerFile(), substitutionMap);
        this._writeToOutputFile(this._getLCPJsonFileContent(classificationGrouping), this.getLcpJsonFile(), substitutionMap);
        this._addRequiredDeploymentContexts(pluginPackageProperties, this.getLcpJsonFile());
        this._storePluginPackageProperties(pluginPackageProperties);
        this._createClientExtensionConfigFile(jsonMap);
    }

    @OutputFile
    public File getClientExtensionConfigFile() {
        return GradleUtil.toFile(this._project, this._clientExtensionConfigFile);
    }

    @OutputFile
    public File getDockerFile() {
        return GradleUtil.toFile(this._project, this._dockerFile);
    }

    @InputFiles
    public File getInputDockerfileFile() {
        return GradleUtil.toFile(this._project, "Dockerfile");
    }

    @InputFiles
    public File getInputLcpJsonFile() {
        return GradleUtil.toFile(this._project, "LCP.json");
    }

    @InputFiles
    public File getInputPluginPackagePropertiesFile() {
        return GradleUtil.toFile(this._project, "liferay-plugin-package.properties");
    }

    @OutputFile
    public File getLcpJsonFile() {
        return GradleUtil.toFile(this._project, this._lcpJsonFile);
    }

    @OutputFile
    public File getPluginPackagePropertiesFile() {
        return GradleUtil.toFile(this._project, this._pluginPackagePropertiesFile);
    }

    @Optional
    @OutputFile
    public File getSiteInitializerJsonFile() {
        return GradleUtil.toFile(this._project, this._siteInitializerJsonFile);
    }

    @Input
    public String getType() {
        return this._type;
    }

    public void setDockerFile(Object dockerFile) {
        this._dockerFile = dockerFile;
    }

    public void setLcpJsonFile(Object lcpJsonFile) {
        this._lcpJsonFile = lcpJsonFile;
    }

    public void setType(String type) {
        this._type = type;
    }

    private void _addRequiredDeploymentContexts(Properties pluginPackageProperties, File lcpJsonFile) {
        try {
            JsonNode jsonNode = this._objectMapper.readTree(lcpJsonFile);
            if (jsonNode.has("dependencies")) {
                ArrayList<String> dependencies = new ArrayList<String>();
                for (JsonNode dependencyJsonNode : jsonNode.get("dependencies")) {
                    dependencies.add(dependencyJsonNode.textValue());
                }
                pluginPackageProperties.put("required-deployment-contexts", StringUtil.join(",", dependencies));
            }
        }
        catch (IOException ioException) {
            throw new GradleException("Unable to parse " + lcpJsonFile.getName(), (Throwable)ioException);
        }
    }

    private Provider<RegularFile> _addTaskOutputFile(String path) {
        ProjectLayout projectLayout = this._project.getLayout();
        DirectoryProperty buildDirectoryProperty = projectLayout.getBuildDirectory();
        Path buildFilePath = Paths.get("liferay-client-extension-build", path);
        Provider buildFileProvider = buildDirectoryProperty.file(buildFilePath.toString());
        TaskOutputsInternal taskOutputs = this.getOutputs();
        taskOutputs.files(new Object[]{buildFileProvider});
        return buildFileProvider;
    }

    private void _createClientExtensionConfigFile(Map<String, Object> jsonMap) {
        File clientExtensionConfigFile = this.getClientExtensionConfigFile();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
            ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
            String json = objectWriter.writeValueAsString(jsonMap);
            Files.write(clientExtensionConfigFile.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    private void _createSiteInitializerJsonFile(ClientExtension clientExtension) {
        Map<String, Object> typeSettings = clientExtension.typeSettings;
        File siteInitializerJsonFile = this.getSiteInitializerJsonFile();
        try {
            HashMap<String, Object> jsonMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : typeSettings.entrySet()) {
                String jsonMapKey = _typeSettingsToSiteInitializerJsonKeyMap.get(entry.getKey());
                if (jsonMapKey == null) continue;
                jsonMap.put(jsonMapKey, entry.getValue());
            }
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
            ObjectWriter objectWriter = objectMapper.writerWithDefaultPrettyPrinter();
            String json = objectWriter.writeValueAsString(jsonMap);
            Files.write(siteInitializerJsonFile.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (Exception exception) {
            throw new GradleException(exception.getMessage(), (Throwable)exception);
        }
    }

    private void _expandWildcards(Map<String, Object> typeSettings) {
        File clientExtensionBuildDir = new File(this._project.getBuildDir(), "liferay-client-extension-build");
        File staticDir = new File(clientExtensionBuildDir, "static");
        if (!staticDir.exists()) {
            return;
        }
        Path staticDirPath = staticDir.toPath();
        for (Map.Entry<String, Object> entry : typeSettings.entrySet()) {
            Object currentValue = entry.getValue();
            if (currentValue instanceof String && this._isWildcardValue((String)currentValue)) {
                entry.setValue(this._getMatchingPaths(staticDirPath, (String)currentValue));
            }
            if (!(currentValue instanceof List)) continue;
            ArrayList<String> values = new ArrayList<String>();
            for (String value : (List)currentValue) {
                if (this._isWildcardValue(value)) {
                    values.addAll(this._getMatchingPaths(staticDirPath, value));
                    continue;
                }
                values.add(value);
            }
            entry.setValue(values);
        }
    }

    private String _getFileContent(File file) {
        if (file.exists()) {
            try {
                return new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException ioException) {
                throw new GradleException(ioException.getMessage(), (Throwable)ioException);
            }
        }
        return null;
    }

    private String _getIdOrBatchType(ClientExtension clientExtension) {
        String id = clientExtension.id;
        if (Objects.equals(clientExtension.getClassification(), "batch")) {
            id = "batch";
        }
        return id;
    }

    private String _getLCPJsonFileContent(String classificationGrouping) {
        String lcpJsonContent = ResourceUtil.readString(ResourceUtil.getLocalFileResolver(this.getInputLcpJsonFile()));
        String templateLCPJsonContent = ResourceUtil.readString(ResourceUtil.getClassLoaderResolver(CreateClientExtensionConfigTask.class, this._getTemplatePath(classificationGrouping, "LCP.json")));
        if (StringUtil.isBlank(lcpJsonContent) && StringUtil.isBlank(templateLCPJsonContent)) {
            return null;
        }
        if (StringUtil.isBlank(lcpJsonContent)) {
            return templateLCPJsonContent;
        }
        if (StringUtil.isBlank(templateLCPJsonContent)) {
            return lcpJsonContent;
        }
        try {
            Logger logger = this._project.getLogger();
            if (logger.isInfoEnabled()) {
                logger.info("Merging LCP.json with the default values");
            }
            JsonNode templateJsonNode = this._objectMapper.readTree(templateLCPJsonContent);
            JsonNode kindNodeJsonNode = templateJsonNode.get("kind");
            String oldKind = kindNodeJsonNode.asText();
            JsonNodeUtil.overrideJsonNodeValues(templateJsonNode, this._objectMapper.readTree(lcpJsonContent));
            kindNodeJsonNode = templateJsonNode.get("kind");
            String newKind = kindNodeJsonNode.asText();
            if (!Objects.equals(oldKind, newKind)) {
                throw new GradleException(String.format("LCP.json: %s must be %s", StringUtil.quote("kind"), StringUtil.quote(oldKind)));
            }
            ObjectWriter objectWriter = this._objectMapper.writerWithDefaultPrettyPrinter();
            String content = objectWriter.writeValueAsString((Object)templateJsonNode);
            if (logger.isInfoEnabled()) {
                File buildDir = this._project.getBuildDir();
                File projectDir = this._project.getProjectDir();
                Path projectDirPath = projectDir.toPath();
                logger.info("See {}/{}/LCP.json for the merged file", (Object)projectDirPath.relativize(buildDir.toPath()), (Object)"liferay-client-extension-build");
            }
            return content;
        }
        catch (IOException ioException) {
            throw new GradleException("LCP.json is not valid JSON");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> _getMatchingPaths(Path basePath, String glob) {
        FileSystem fileSystem = basePath.getFileSystem();
        AtomicReference<String> queryStringAtomicReference = new AtomicReference<String>("");
        int index = glob.indexOf("?");
        if (index != -1) {
            queryStringAtomicReference.set(glob.substring(index));
            glob = glob.substring(0, index);
        }
        PathMatcher pathMatcher = fileSystem.getPathMatcher("glob:" + glob);
        try (Stream<Path> files = Files.walk(basePath, new FileVisitOption[0]);){
            List<String> matchingPaths = files.map(basePath::relativize).filter(pathMatcher::matches).map(path -> path + (String)queryStringAtomicReference.get()).collect(Collectors.toList());
            if (matchingPaths.isEmpty()) {
                throw new GradleException("No paths matched the glob pattern \"" + glob + "\"");
            }
            Collections.sort(matchingPaths);
            List<String> list = matchingPaths;
            return list;
        }
        catch (IOException ioException) {
            throw new GradleException("Unable to expand wildcard paths", (Throwable)ioException);
        }
    }

    private Properties _getPluginPackageProperties() {
        Properties pluginPackageProperties = new Properties();
        try {
            String pluginPackagePropertiesFileContent = this._getFileContent(this.getInputPluginPackagePropertiesFile());
            if (pluginPackagePropertiesFileContent != null) {
                pluginPackageProperties.load(new StringReader(pluginPackagePropertiesFileContent));
            }
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
        return pluginPackageProperties;
    }

    private String _getTemplatePath(String classificationGrouping, String fileName) {
        return String.format("dependencies/templates/%s/%s.tpl", classificationGrouping, fileName);
    }

    private void _inlineFrontendTokenDefinitionJSON(ClientExtension clientExtension) {
        Map<String, Object> typeSettings = clientExtension.typeSettings;
        Object frontendTokenDefinitionFile = typeSettings.remove("frontendTokenDefinitionJSON");
        if (frontendTokenDefinitionFile == null) {
            return;
        }
        String json = ResourceUtil.readString(ResourceUtil.getLocalFileResolver(this._project.file(frontendTokenDefinitionFile)));
        if (StringUtil.isBlank(json)) {
            json = "{}";
        }
        try {
            typeSettings.put("frontendTokenDefinitionJSON", this._objectMapper.writeValueAsString(this._objectMapper.readValue(json, Map.class)));
        }
        catch (JsonParseException jsonParseException) {
            throw new GradleException("Unable to JSON from file " + frontendTokenDefinitionFile, (Throwable)jsonParseException);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new GradleException("Unable to write JSON", (Throwable)jsonProcessingException);
        }
    }

    private boolean _isWildcardValue(String value) {
        return value.contains("*");
    }

    private void _mapGlobalJSScriptElementAttributesToJSONString(ClientExtension clientExtension) {
        Map<String, Object> typeSettings = clientExtension.typeSettings;
        Map scriptElementAttributesMap = (Map)typeSettings.get("scriptElementAttributes");
        if (scriptElementAttributesMap == null) {
            return;
        }
        Set entrySet = scriptElementAttributesMap.entrySet();
        ObjectNode scriptElementAttributesObjectNode = this._objectMapper.createObjectNode();
        for (Map.Entry entry : entrySet) {
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                scriptElementAttributesObjectNode.put((String)entry.getKey(), (Boolean)value);
                continue;
            }
            scriptElementAttributesObjectNode.put((String)entry.getKey(), (String)value);
        }
        typeSettings.remove("scriptElementAttributes");
        typeSettings.put("scriptElementAttributesJSON", scriptElementAttributesObjectNode.toString());
    }

    private void _processBatchJSONFile(File file) throws IOException {
        JsonNode rootJsonNode = this._objectMapper.readTree(file);
        File parentFile = file.getParentFile();
        JsonNode configurationJsonNode = rootJsonNode.findValue("configuration");
        JsonNode classNameJsonNode = configurationJsonNode.findValue("className");
        if (classNameJsonNode == null || !Objects.equals(classNameJsonNode.asText(), "com.liferay.object.rest.dto.v1_0.ObjectEntry")) {
            return;
        }
        JsonNode itemsJsonNode = rootJsonNode.findValue("items");
        if (itemsJsonNode == null) {
            return;
        }
        boolean modified = false;
        for (JsonNode itemJsonNode : itemsJsonNode) {
            JsonNode externalReferenceCodeJsonNode = itemJsonNode.findValue("externalReferenceCode");
            if (externalReferenceCodeJsonNode == null) continue;
            for (JsonNode childJsonNode : itemJsonNode) {
                JsonNode fileBase64JsonNode;
                if (!childJsonNode.isObject() || (fileBase64JsonNode = childJsonNode.findValue("fileBase64")) == null || !Objects.equals(fileBase64JsonNode.asText(), "@batch_object_entry_file_base64@")) continue;
                JsonNode nameJsonNode = childJsonNode.findValue("name");
                if (nameJsonNode == null) {
                    throw new GradleException(String.format("No name field found with token %s", "@batch_object_entry_file_base64@"));
                }
                File attachmentFile = new File(parentFile, String.format("attachments/%s/%s", externalReferenceCodeJsonNode.asText(), nameJsonNode.asText()));
                if (!attachmentFile.exists()) {
                    throw new GradleException(String.format("Attachment file %s does not exist", attachmentFile));
                }
                ObjectNode objectNode = (ObjectNode)childJsonNode;
                objectNode.put("fileBase64", this._base64Encoder.encodeToString(Files.readAllBytes(attachmentFile.toPath())));
                modified = true;
            }
        }
        if (!modified) {
            return;
        }
        File projectDir = this._project.getProjectDir();
        Path projectDirPath = projectDir.toPath();
        Path relativeTargetFilePath = projectDirPath.relativize(file.toPath());
        Path cxBuildDirPath = Paths.get(String.valueOf(this._project.getBuildDir()), "liferay-client-extension-build");
        Path resolvedTargetPath = cxBuildDirPath.resolve(relativeTargetFilePath);
        ObjectWriter objectWriter = this._objectMapper.writer();
        Files.write(resolvedTargetPath, objectWriter.writeValueAsBytes((Object)rootJsonNode), new OpenOption[0]);
        Logger logger = this.getLogger();
        if (logger.isInfoEnabled()) {
            logger.info("Replaced base64 tokens in {}", (Object)file);
        }
    }

    private void _processBatchJSONFiles() {
        ConfigurableFileTree fileTree = this._project.fileTree((Object)"batch");
        fileTree.include(new String[]{"**/*.json"});
        for (File file : fileTree.getFiles()) {
            try {
                this._processBatchJSONFile(file);
            }
            catch (IOException ioException) {
                throw new GradleException(String.format("Unable to read file %s", file));
            }
        }
    }

    private void _storePluginPackageProperties(Properties pluginPackageProperties) {
        File pluginPackagePropertiesFile = this.getPluginPackagePropertiesFile();
        try {
            File parentFile = pluginPackagePropertiesFile.getParentFile();
            parentFile.mkdirs();
            BufferedWriter bufferedWriter = Files.newBufferedWriter(pluginPackagePropertiesFile.toPath(), StandardOpenOption.CREATE);
            pluginPackageProperties.store(bufferedWriter, null);
        }
        catch (IOException ioException) {
            throw new GradleException(ioException.getMessage(), (Throwable)ioException);
        }
    }

    private String _validateAndGetClassificationGrouping(Set<ClientExtension> clientExtensions) {
        HashSet classifications = new HashSet();
        clientExtensions.forEach(clientExtension -> classifications.add(clientExtension.getClassification()));
        if (_groupConfiguration.containsAll(classifications)) {
            return "configuration";
        }
        if (_groupBatch.containsAll(classifications)) {
            long siteInitializerTypeCount;
            Stream stream = clientExtensions.stream();
            Map<String, Long> typeCountMap = stream.collect(Collectors.groupingBy(clientExtension -> clientExtension.type, Collectors.counting()));
            long batchTypeCount = typeCountMap.getOrDefault("batch", 0L);
            if (batchTypeCount + (siteInitializerTypeCount = typeCountMap.getOrDefault("siteInitializer", 0L).longValue()) > 1L) {
                throw new GradleException("A client extension project must not contain more than one batch or siteInitializer type client extension");
            }
            Long oAuthApplicationHeadlessServerTypeCount = typeCountMap.getOrDefault("oAuthApplicationHeadlessServer", 0L);
            if (oAuthApplicationHeadlessServerTypeCount != 1L) {
                throw new GradleException("A batch or siteInitializer type client extension requires exactly one oAuthApplicationHeadlessServer type client extension");
            }
            return "batch";
        }
        if (_groupFrontend.containsAll(classifications)) {
            return "frontend";
        }
        if (_groupMicroservice.containsAll(classifications)) {
            return "microservice";
        }
        if (!classifications.isEmpty()) {
            throw new GradleException(StringUtil.concat("The combination of client extensions in ", classifications, " cannot be grouped in a single project. The following ", "groupings are allowed: ", _groupBatch, _groupFrontend, _groupMicroservice));
        }
        return "frontend";
    }

    private void _writeToOutputFile(String content, File outputFile, Map<String, String> substitutionMap) {
        if (content == null) {
            throw new GradleException(String.format("Required file %s not found in project %s", StringUtil.quote(outputFile.getName()), StringUtil.quote(this._project.getName())));
        }
        try {
            for (Map.Entry<String, String> entry : substitutionMap.entrySet()) {
                content = content.replace(entry.getKey(), entry.getValue());
            }
            Files.write(outputFile.toPath(), content.getBytes(), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new GradleException(String.format("Unable to write file %s", StringUtil.quote(outputFile.getName())), (Throwable)ioException);
        }
    }
}

