/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import com.liferay.portal.tools.bundle.support.commands.DownloadCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.Properties;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ResourceUtil {
    private static final Logger _logger = Logging.getLogger(ResourceUtil.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper();

    public static Resolver getClassLoaderResolver(Class<?> clazz, String resourcePath) {
        return () -> {
            ResourceUtil._logInfo("Trying to get resource from class path: {}", resourcePath);
            return Objects.requireNonNull(clazz.getResourceAsStream(resourcePath), "Unable to get resource from class path: " + resourcePath);
        };
    }

    public static Resolver getClassLoaderResolver(String resourcePath) {
        return ResourceUtil.getClassLoaderResolver(ResourceUtil.class, resourcePath);
    }

    public static Resolver getLocalFileResolver(File file) {
        return () -> {
            ResourceUtil._logInfo("Trying to get resource from local file: {}", file.getAbsolutePath());
            ResourceUtil._checkFileExists(file);
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        };
    }

    public static Resolver getLocalFileResolver(File file, long maxAge, TemporalUnit temporalUnit) {
        return () -> {
            ResourceUtil._logInfo("Trying to get resource from local file with max age of {} {}: {}", maxAge, temporalUnit, file.getAbsolutePath());
            ResourceUtil._checkFileExists(file);
            BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = basicFileAttributes.lastModifiedTime();
            Duration age = Duration.between(fileTime.toInstant(), Instant.now());
            if (age.compareTo(Duration.of(maxAge, temporalUnit)) > 0) {
                throw new Exception(String.format("Cached file %s is older than max age of %s %s", file, maxAge, temporalUnit));
            }
            return Files.newInputStream(file.toPath(), new OpenOption[0]);
        };
    }

    public static Resolver getURIResolver(File cacheDir, URI uri) {
        return () -> {
            ResourceUtil._logInfo("Trying to get resource from URL {}", uri);
            URL url = uri.toURL();
            try {
                DownloadCommand downloadCommand = new DownloadCommand();
                downloadCommand.setCacheDir(cacheDir);
                downloadCommand.setConnectionTimeout(5000);
                downloadCommand.setPassword(null);
                downloadCommand.setQuiet(true);
                downloadCommand.setToken(false);
                downloadCommand.setUrl(url);
                downloadCommand.setUserName(null);
                downloadCommand.execute();
                Path downloadPath = downloadCommand.getDownloadPath();
                Files.setLastModifiedTime(downloadPath, FileTime.from(Instant.now()));
                return Files.newInputStream(downloadPath, new OpenOption[0]);
            }
            catch (Exception exception) {
                throw new Exception(String.format("Unable to get resource from URL %s: %s", url, exception.getMessage()), exception);
            }
        };
    }

    public static Resolver getURLResolver(File cacheDir, String url) {
        return ResourceUtil.getURIResolver(cacheDir, URI.create(url));
    }

    public static <T> T readJson(Class<T> clazz, Resolver ... resolvers) {
        return (T)ResourceUtil._withInputStream(inputStream -> _objectMapper.readValue(inputStream, clazz), resolvers);
    }

    public static Properties readProperties(Resolver ... resolvers) {
        return ResourceUtil._withInputStream(inputStream -> {
            Properties properties = new Properties();
            properties.load(inputStream);
            return properties;
        }, resolvers);
    }

    public static String readString(Resolver ... resolvers) {
        return ResourceUtil._withInputStream(StringUtil::read, resolvers);
    }

    private static void _checkFileExists(File file) throws Exception {
        if (!file.exists()) {
            throw new FileNotFoundException("Unable to get resource from local file: " + file.getAbsolutePath());
        }
    }

    private static void _logInfo(String message, Object ... args) {
        if (_logger.isInfoEnabled()) {
            _logger.info(message, args);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T _withInputStream(Transformer<T> transformer, Resolver ... resolvers) {
        InputStream inputStream1 = null;
        for (Resolver resolver : resolvers) {
            try {
                inputStream1 = resolver.resolve();
            }
            catch (Exception exception) {
                ResourceUtil._logInfo(exception.getMessage(), new Object[0]);
            }
            if (inputStream1 != null) break;
        }
        if (inputStream1 == null) {
            ResourceUtil._logInfo("Resource not found", new Object[0]);
            return null;
        }
        try (InputStream inputStream2 = inputStream1;){
            ResourceUtil._logInfo("Found resource", new Object[0]);
            T t = transformer.transform(inputStream2);
            return t;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to read resource", exception);
        }
    }

    @FunctionalInterface
    public static interface Transformer<T> {
        public T transform(InputStream var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Resolver {
        public InputStream resolve() throws Exception;
    }
}

