/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.client.extension;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.gradle.plugins.workspace.internal.util.ResourceUtil;
import com.liferay.gradle.plugins.workspace.internal.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ClientExtension {
    public String description = "";
    public String id;
    public String name = "";
    public String projectId;
    public String projectName;
    public Map<String, Object> properties = Collections.emptyMap();
    public String sourceCodeURL = "";
    public String type;
    @JsonIgnore
    public Map<String, Object> typeSettings = new HashMap<String, Object>();
    @JsonProperty(value="dxp.lxc.liferay.com.virtualInstanceId")
    public String virtualInstanceId = "default";
    private static final Properties _clientExtensionProperties = ResourceUtil.readProperties(ResourceUtil.getClassLoaderResolver(ClientExtension.class, "client-extension.properties"));

    public String getClassification() {
        String classification = _clientExtensionProperties.getProperty(this.type + ".classification");
        if (classification != null) {
            return classification;
        }
        throw new GradleException(String.format("Client extension %s with type %s is of unknown classification", this.id, this.type));
    }

    @JsonAnySetter
    public void ignored(String name, Object value) {
        this.typeSettings.put(name, value);
    }

    public Map<String, Object> toJSONMap() {
        HashMap<String, Object> typeSettings = new HashMap<String, Object>(this.typeSettings);
        String pid = _clientExtensionProperties.getProperty(this.type + ".pid");
        if (Objects.equals(this.type, "instanceSettings")) {
            pid = typeSettings.remove("pid") + ".scoped";
        }
        if (pid == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put(":configurator:policy", "force");
        configMap.put("baseURL", typeSettings.getOrDefault("baseURL", "${portalURL}/o/" + this.projectName));
        configMap.put("buildTimestamp", System.currentTimeMillis());
        configMap.put("description", this.description);
        configMap.put("dxp.lxc.liferay.com.virtualInstanceId", this.virtualInstanceId);
        configMap.put("name", this.name);
        configMap.put("projectId", this.projectId);
        configMap.put("projectName", this.projectName);
        configMap.put("properties", this._encode(this.properties));
        configMap.put("sourceCodeURL", this.sourceCodeURL);
        configMap.put("type", this.type);
        configMap.put("webContextPath", typeSettings.getOrDefault("webContextPath", "/" + this.projectName));
        if (!pid.contains("CETConfiguration")) {
            configMap.putAll(typeSettings);
        }
        if (this.type.equals("oAuthApplicationHeadlessServer") || this.type.equals("oAuthApplicationUserAgent")) {
            configMap.put("homePageURL", typeSettings.getOrDefault("homePageURL", "$[conf:.serviceScheme]://$[conf:.serviceAddress]"));
        }
        configMap.put("typeSettings", this._encode(typeSettings));
        jsonMap.put(pid + "~" + this.id, configMap);
        return jsonMap;
    }

    private List<String> _encode(Map<String, Object> map) {
        Set<Map.Entry<String, Object>> set = map.entrySet();
        Stream stream = set.stream();
        return stream.map(entry -> {
            Object value = entry.getValue();
            if (value instanceof List) {
                value = StringUtil.join("\n", (List)value);
            }
            return StringUtil.concat(entry.getKey(), "=", value);
        }).collect(Collectors.toList());
    }
}

