/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.workspace;

import aQute.bnd.annotation.ProviderType;

import java.io.File;

import org.gradle.api.Plugin;
import org.gradle.api.Project;

/**
 * @author Andrea Di Giorgi
 */
@ProviderType
public interface ProjectConfigurator extends Plugin<Project> {

	public void configureRootProject(
		Project project, WorkspaceExtension workspaceExtension);

	public Iterable<File> getDefaultRootDirs();

	public String getName();

	public Iterable<File> getProjectDirs(File rootDir);

}